/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DiskQueryRelay;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.jar.BasicJarHandler;
import com.intellij.openapi.vfs.impl.jar.JarHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarFileSystemImpl
extends JarFileSystem {
    private final Set<String> myNoCopyJarPaths;
    private final File myNoCopyJarDir;
    private final DiskQueryRelay<VirtualFile, FileAttributes> myAttrGetter = new DiskQueryRelay<VirtualFile, FileAttributes>(x$0 -> super.getAttributes(x$0));
    private final DiskQueryRelay<VirtualFile, String[]> myChildrenGetter = new DiskQueryRelay<VirtualFile, String[]>(x$0 -> super.list(x$0));

    public JarFileSystemImpl() {
        boolean noCopy = SystemProperties.getBooleanProperty((String)"idea.jars.nocopy", (!SystemInfo.isWindows ? 1 : 0) != 0);
        this.myNoCopyJarPaths = noCopy ? null : ConcurrentCollectionFactory.createConcurrentSet(FileUtil.PATH_HASHING_STRATEGY);
        boolean runningFromDist = new File(PathManager.getLibPath(), "openapi.jar").exists();
        this.myNoCopyJarDir = !runningFromDist ? null : new File(PathManager.getHomePath());
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        return this.myAttrGetter.accessDiskWithCheckCanceled(file2);
    }

    public String @NotNull [] list(@NotNull VirtualFile file2) {
        return this.myChildrenGetter.accessDiskWithCheckCanceled(file2);
    }

    public void setNoCopyJarForPath(@NotNull String pathInJar) {
        if (this.myNoCopyJarPaths == null) {
            return;
        }
        int index = pathInJar.indexOf("!/");
        if (index < 0) {
            return;
        }
        String path = FileUtil.toSystemIndependentName((String)pathInJar.substring(0, index));
        this.myNoCopyJarPaths.add(path);
    }

    @Nullable
    public File getMirroredFile(@NotNull VirtualFile vFile) {
        VirtualFile root = this.getRootByLocal(vFile);
        if (root != null) {
            ArchiveHandler handler2 = this.getHandler(root);
            if (handler2 instanceof JarHandler) {
                return ((JarHandler)handler2).getFileToUse();
            }
            return handler2.getFile();
        }
        return null;
    }

    public boolean isMakeCopyOfJar(@NotNull File originalJar) {
        if (this.myNoCopyJarPaths == null || this.myNoCopyJarPaths.contains(FileUtil.toSystemIndependentName((String)originalJar.getPath()))) {
            return false;
        }
        return this.myNoCopyJarDir == null || !FileUtil.isAncestor((File)this.myNoCopyJarDir, (File)originalJar, (boolean)false);
    }

    @NotNull
    public String getProtocol() {
        return "jar";
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        return super.extractPresentableUrl(StringUtil.trimEnd((String)path, (String)"!/"));
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        int separatorIndex = path.indexOf("!/");
        return separatorIndex > 0 ? FileUtil.normalize((String)path.substring(0, separatorIndex)) + path.substring(separatorIndex) : null;
    }

    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        int separatorIndex = normalizedPath.indexOf("!/");
        return separatorIndex > 0 ? normalizedPath.substring(0, separatorIndex + "!/".length()) : "";
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        return StringUtil.trimEnd((String)rootPath, (String)"!/");
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        return localPath + "!/";
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        boolean useNewJarHandler = SystemInfo.isWindows && Registry.is((String)"vfs.use.new.jar.handler");
        return VfsImplUtil.getHandler((ArchiveFileSystem)this, entryFile, useNewJarHandler ? BasicJarHandler::new : JarHandler::new);
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        return JarFileSystemImpl.isValid(path) ? VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path) : null;
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        return JarFileSystemImpl.isValid(path) ? VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path) : null;
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return JarFileSystemImpl.isValid(path) ? VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path) : null;
    }

    private static boolean isValid(String path) {
        return path.contains("!/");
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, asynchronous);
    }

    public static void cleanupForNextTest() {
        BasicJarHandler.closeOpenedZipReferences();
    }
}

