/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightFilePointer
implements VirtualFilePointer {
    @NotNull
    private final String myUrl;
    @Nullable
    private volatile VirtualFile myFile;
    private volatile boolean myRefreshed;

    public LightFilePointer(@NotNull String url) {
        this.myUrl = url;
    }

    public LightFilePointer(@NotNull VirtualFile file2) {
        this.myUrl = file2.getUrl();
        this.myFile = file2;
    }

    @Nullable
    public VirtualFile getFile() {
        this.refreshFile();
        return this.myFile;
    }

    @NotNull
    public String getUrl() {
        return this.myUrl;
    }

    @NotNull
    public String getFileName() {
        VirtualFile file2 = this.myFile;
        if (file2 != null) {
            return file2.getName();
        }
        int index = this.myUrl.lastIndexOf(47);
        return index >= 0 ? this.myUrl.substring(index + 1) : this.myUrl;
    }

    @NotNull
    public String getPresentableUrl() {
        VirtualFile file2 = this.getFile();
        if (file2 != null) {
            return file2.getPresentableUrl();
        }
        return LightFilePointer.toPresentableUrl(this.myUrl);
    }

    @NotNull
    private static String toPresentableUrl(@NotNull String url) {
        String path = VirtualFileManager.extractPath((String)url);
        String protocol = VirtualFileManager.extractProtocol((String)url);
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem(protocol);
        return ((VirtualFileSystem)ObjectUtils.notNull((Object)fileSystem, (Object)StandardFileSystems.local())).extractPresentableUrl(path);
    }

    public boolean isValid() {
        return this.getFile() != null;
    }

    private void refreshFile() {
        VirtualFile file2 = this.myFile;
        if (file2 != null && file2.isValid()) {
            return;
        }
        VirtualFileManager vfManager = VirtualFileManager.getInstance();
        VirtualFile virtualFile = vfManager.findFileByUrl(this.myUrl);
        if (virtualFile == null && !this.myRefreshed) {
            this.myRefreshed = true;
            Application application = ApplicationManager.getApplication();
            if (application.isDispatchThread() || !application.isReadAccessAllowed()) {
                virtualFile = vfManager.refreshAndFindFileByUrl(this.myUrl);
            } else {
                application.executeOnPooledThread(() -> vfManager.refreshAndFindFileByUrl(this.myUrl));
            }
        }
        this.myFile = virtualFile != null && virtualFile.isValid() ? virtualFile : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LightFilePointer)) {
            return false;
        }
        return this.myUrl.equals(((LightFilePointer)o).myUrl);
    }

    public int hashCode() {
        return this.myUrl.hashCode();
    }
}

