/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import org.jetbrains.annotations.NotNull;

class IdentityVirtualFilePointer
extends VirtualFilePointerImpl
implements VirtualFilePointer,
Disposable {
    private final VirtualFile myFile;
    private final String myUrl;

    IdentityVirtualFilePointer(VirtualFile file2, @NotNull String url, VirtualFilePointerListener listener2) {
        super(listener2);
        this.myFile = file2;
        this.myUrl = url;
    }

    @Override
    @NotNull
    public String getFileName() {
        return this.getUrl();
    }

    @Override
    public VirtualFile getFile() {
        return this.isValid() ? this.myFile : null;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.myUrl;
    }

    @Override
    @NotNull
    public String getPresentableUrl() {
        return this.getUrl();
    }

    @Override
    public boolean isValid() {
        return this.myFile == null || this.myFile.isValid();
    }

    @Override
    public void dispose() {
        this.incrementUsageCount(-1);
    }
}

