/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerListener;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingReference;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.xmlb.annotations.Attribute;
import gnu.trove.Equality;
import gnu.trove.THashSet;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@com.intellij.openapi.components.State(name="Encoding", storages={@Storage(value="encoding.xml")})
public class EncodingManagerImpl
extends EncodingManager
implements PersistentStateComponent<State>,
Disposable {
    private static final Logger LOG = Logger.getInstance(EncodingManagerImpl.class);
    private static final Equality<Reference<Document>> REFERENCE_EQUALITY = new Equality<Reference<Document>>(){

        public boolean equals(Reference<Document> o1, Reference<Document> o2) {
            Equality v1 = o1 == null ? REFERENCE_EQUALITY : o1.get();
            Equality v2 = o2 == null ? REFERENCE_EQUALITY : o2.get();
            return v1 == v2;
        }
    };
    private State myState = new State();
    private static final Key<Charset> CACHED_CHARSET_FROM_CONTENT = Key.create((String)"CACHED_CHARSET_FROM_CONTENT");
    private final ExecutorService changedDocumentExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"EncodingManagerImpl Document Pool", (Executor)PooledThreadExecutor.INSTANCE, (int)JobSchedulerImpl.getJobPoolParallelism(), (Disposable)this);
    private final AtomicBoolean myDisposed = new AtomicBoolean();
    @NonNls
    public static final String PROP_CACHED_ENCODING_CHANGED = "cachedEncoding";
    private static final Key<AtomicInteger> RUNNING_REDETECTS_KEY = Key.create((String)"DETECTING_ENCODING_KEY");

    public EncodingManagerImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appClosing() {
                EncodingManagerImpl.this.myDisposed.set(true);
                EncodingManagerImpl.this.clearDocumentQueue();
            }
        });
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                Document document = e.getDocument();
                if (EncodingManagerImpl.isEditorOpenedFor(document)) {
                    EncodingManagerImpl.this.queueUpdateEncodingFromContent(document);
                }
            }
        }, (Disposable)this);
        editorFactory.addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                EncodingManagerImpl.this.queueUpdateEncodingFromContent(event.getEditor().getDocument());
            }
        }, (Disposable)this);
    }

    private static boolean isEditorOpenedFor(@NotNull Document document) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return false;
        }
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        return project != null && !project.isDisposed() && FileEditorManager.getInstance((Project)project).isFileOpen(virtualFile);
    }

    private void handleDocument(@NotNull Document document) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return;
        }
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        while (project == null || !project.isDisposed()) {
            Charset oldCached;
            int nRequests = EncodingManagerImpl.addNumberOfRequestedRedetects(document, 0);
            Charset charset = LoadTextUtil.charsetFromContentOrNull(project, virtualFile, document.getImmutableCharSequence());
            if (!Comparing.equal((Object)charset, (Object)(oldCached = this.getCachedCharsetFromContent(document)))) {
                this.setCachedCharsetFromContent(charset, oldCached, document);
            }
            if (EncodingManagerImpl.addNumberOfRequestedRedetects(document, -nRequests) != 0) continue;
            break;
        }
    }

    private void setCachedCharsetFromContent(Charset charset, Charset oldCached, @NotNull Document document) {
        document.putUserData(CACHED_CHARSET_FROM_CONTENT, (Object)charset);
        this.firePropertyChange(document, PROP_CACHED_ENCODING_CHANGED, oldCached, charset, null);
    }

    @Nullable(value="returns null if charset set cannot be determined from content")
    @Nullable(value="returns null if charset set cannot be determined from content") Charset computeCharsetFromContent(@NotNull VirtualFile virtualFile) {
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        Charset cached = EncodingManager.getInstance().getCachedCharsetFromContent(document);
        if (cached != null) {
            return cached;
        }
        Project project = ProjectLocator.getInstance().guessProjectForFile(virtualFile);
        return (Charset)ReadAction.compute(() -> {
            Charset charsetFromContent = LoadTextUtil.charsetFromContentOrNull(project, virtualFile, document.getImmutableCharSequence());
            if (charsetFromContent != null) {
                this.setCachedCharsetFromContent(charsetFromContent, null, document);
            }
            return charsetFromContent;
        });
    }

    public void dispose() {
        this.myDisposed.set(true);
    }

    private static int addNumberOfRequestedRedetects(@NotNull Document document, int delta) {
        AtomicInteger oldData = (AtomicInteger)document.getUserData(RUNNING_REDETECTS_KEY);
        if (oldData == null) {
            oldData = (AtomicInteger)((UserDataHolderEx)document).putUserDataIfAbsent(RUNNING_REDETECTS_KEY, (Object)new AtomicInteger());
        }
        return oldData.addAndGet(delta);
    }

    void queueUpdateEncodingFromContent(@NotNull Document document) {
        if (this.myDisposed.get()) {
            return;
        }
        if (EncodingManagerImpl.addNumberOfRequestedRedetects(document, 1) == 1) {
            this.changedDocumentExecutor.execute(new DocumentEncodingDetectRequest(document, this.myDisposed));
        }
    }

    @Nullable
    public Charset getCachedCharsetFromContent(@NotNull Document document) {
        return (Charset)document.getUserData(CACHED_CHARSET_FROM_CONTENT);
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
    }

    @NotNull
    public Collection<Charset> getFavorites() {
        Project[] projects;
        THashSet result2 = new THashSet();
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            result2.addAll(EncodingProjectManager.getInstance((Project)project).getFavorites());
        }
        result2.addAll(EncodingProjectManagerImpl.widelyKnownCharsets());
        return result2;
    }

    @Nullable
    public Charset getEncoding(@Nullable VirtualFile virtualFile, boolean useParentDefaults) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        if (project == null) {
            return null;
        }
        EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)project);
        if (encodingManager == null) {
            return null;
        }
        return encodingManager.getEncoding(virtualFile, useParentDefaults);
    }

    public void clearDocumentQueue() {
        if (((BoundedTaskExecutor)this.changedDocumentExecutor).isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call clearDocumentQueue() from under write action because some queued detectors require read action");
        }
        ((BoundedTaskExecutor)this.changedDocumentExecutor).clearAndCancelAll();
        this.waitAllTasksExecuted(1L, TimeUnit.MINUTES);
    }

    void waitAllTasksExecuted(long timeout, @NotNull TimeUnit unit) {
        try {
            ((BoundedTaskExecutor)this.changedDocumentExecutor).waitAllTasksExecuted(timeout, unit);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    private static Project guessProject(@Nullable VirtualFile virtualFile) {
        return ProjectLocator.getInstance().guessProjectForFile(virtualFile);
    }

    public void setEncoding(@Nullable VirtualFile virtualFileOrDir, @Nullable Charset charset) {
        Project project = EncodingManagerImpl.guessProject(virtualFileOrDir);
        if (project != null) {
            EncodingProjectManager.getInstance((Project)project).setEncoding(virtualFileOrDir, charset);
        }
    }

    public boolean isNative2Ascii(@NotNull VirtualFile virtualFile) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        return project != null && EncodingProjectManager.getInstance((Project)project).isNative2Ascii(virtualFile);
    }

    public boolean isNative2AsciiForPropertiesFiles() {
        Project project = EncodingManagerImpl.guessProject(null);
        return project != null && EncodingProjectManager.getInstance((Project)project).isNative2AsciiForPropertiesFiles();
    }

    public void setNative2AsciiForPropertiesFiles(VirtualFile virtualFile, boolean native2Ascii) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        if (project == null) {
            return;
        }
        EncodingProjectManager.getInstance((Project)project).setNative2AsciiForPropertiesFiles(virtualFile, native2Ascii);
    }

    @NotNull
    public Charset getDefaultCharset() {
        return this.myState.myDefaultEncoding.dereference();
    }

    @NotNull
    public String getDefaultCharsetName() {
        return this.myState.getDefaultCharsetName();
    }

    public void setDefaultCharsetName(@NotNull String name) {
        this.myState.setDefaultCharsetName(name);
    }

    @Nullable
    public Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        if (project == null) {
            return null;
        }
        return EncodingProjectManager.getInstance((Project)project).getDefaultCharsetForPropertiesFiles(virtualFile);
    }

    public void setDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile, Charset charset) {
        Project project = EncodingManagerImpl.guessProject(virtualFile);
        if (project == null) {
            return;
        }
        EncodingProjectManager.getInstance((Project)project).setDefaultCharsetForPropertiesFiles(virtualFile, charset);
    }

    @NotNull
    public Charset getDefaultConsoleEncoding() {
        return this.myState.myDefaultConsoleEncoding.dereference();
    }

    @NotNull
    public EncodingReference getDefaultConsoleEncodingReference() {
        return this.myState.myDefaultConsoleEncoding;
    }

    public void setDefaultConsoleEncodingReference(@NotNull EncodingReference encodingReference) {
        this.myState.myDefaultConsoleEncoding = encodingReference;
    }

    void firePropertyChange(@Nullable Document document, @NotNull String propertyName, Object oldValue, Object newValue2, @Nullable Project project) {
        MessageBus messageBus = (project != null ? project : ApplicationManager.getApplication()).getMessageBus();
        EncodingManagerListener publisher = (EncodingManagerListener)messageBus.syncPublisher(EncodingManagerListener.ENCODING_MANAGER_CHANGES);
        publisher.propertyChanged(document, propertyName, oldValue, newValue2);
    }

    private static class DocumentEncodingDetectRequest
    implements Runnable {
        private final Reference<Document> ref;
        @NotNull
        private final AtomicBoolean myDisposed;

        private DocumentEncodingDetectRequest(@NotNull Document document, @NotNull AtomicBoolean disposed) {
            this.ref = new WeakReference<Document>(document);
            this.myDisposed = disposed;
        }

        @Override
        public void run() {
            if (this.myDisposed.get()) {
                return;
            }
            Document document = this.ref.get();
            if (document == null) {
                return;
            }
            ((EncodingManagerImpl)EncodingManager.getInstance()).handleDocument(document);
        }
    }

    static final class State {
        @NotNull
        private EncodingReference myDefaultEncoding = new EncodingReference(StandardCharsets.UTF_8);
        @NotNull
        private EncodingReference myDefaultConsoleEncoding = EncodingReference.DEFAULT;

        State() {
        }

        @Attribute(value="default_encoding")
        @NotNull
        public String getDefaultCharsetName() {
            return this.myDefaultEncoding.getCharset() == null ? "" : this.myDefaultEncoding.getCharset().name();
        }

        public void setDefaultCharsetName(@NotNull String name) {
            this.myDefaultEncoding = new EncodingReference(StringUtil.nullize((String)name));
        }

        @Attribute(value="default_console_encoding")
        @NotNull
        public String getDefaultConsoleEncodingName() {
            return this.myDefaultConsoleEncoding.getCharset() == null ? "" : this.myDefaultConsoleEncoding.getCharset().name();
        }

        public void setDefaultConsoleEncodingName(@NotNull String name) {
            this.myDefaultConsoleEncoding = new EncodingReference(StringUtil.nullize((String)name));
        }
    }
}

