/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="UnknownFeatures", storages={@Storage(value="$WORKSPACE_FILE$")})
public class UnknownFeaturesCollector
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String FEATURE_ID = "featureType";
    @NonNls
    private static final String IMPLEMENTATION_NAME = "implementationName";
    private final Set<UnknownFeature> myUnknownFeatures = new HashSet<UnknownFeature>();
    private final Set<UnknownFeature> myIgnoredUnknownFeatures = new HashSet<UnknownFeature>();

    public static UnknownFeaturesCollector getInstance(Project project) {
        return (UnknownFeaturesCollector)ServiceManager.getService((Project)project, UnknownFeaturesCollector.class);
    }

    public void registerUnknownRunConfiguration(@NotNull String configurationId, @Nullable String factoryName) {
        this.registerUnknownFeature("com.intellij.configurationType", configurationId, "Run Configuration", StringUtil.notNullize((String)factoryName, (String)configurationId));
    }

    public void registerUnknownFeature(@NotNull String featureType, @NotNull String implementationName, @NotNull String featureDisplayName) {
        this.registerUnknownFeature(featureType, implementationName, featureDisplayName, implementationName);
    }

    public void registerUnknownFeature(@NotNull String featureType, @NotNull String implementationName, @NotNull String featureDisplayName, @NotNull String implementationDisplayName) {
        UnknownFeature feature = new UnknownFeature(featureType, featureDisplayName, implementationName, implementationDisplayName);
        if (!this.isIgnored(feature)) {
            this.myUnknownFeatures.add(feature);
        }
    }

    public boolean isIgnored(UnknownFeature feature) {
        return this.myIgnoredUnknownFeatures.contains(feature);
    }

    public void ignoreFeature(UnknownFeature feature) {
        this.myIgnoredUnknownFeatures.add(feature);
    }

    public Set<UnknownFeature> getUnknownFeatures() {
        return this.myUnknownFeatures;
    }

    @Nullable
    public Element getState() {
        if (this.myIgnoredUnknownFeatures.isEmpty()) {
            return null;
        }
        Element ignored = new Element("ignored");
        for (UnknownFeature feature : this.myIgnoredUnknownFeatures) {
            Element option2 = new Element("option");
            option2.setAttribute(FEATURE_ID, feature.getFeatureType());
            option2.setAttribute(IMPLEMENTATION_NAME, feature.getImplementationName());
            ignored.addContent(option2);
        }
        return ignored;
    }

    public void loadState(@NotNull Element state) {
        this.myIgnoredUnknownFeatures.clear();
        for (Element element2 : state.getChildren()) {
            this.myIgnoredUnknownFeatures.add(new UnknownFeature(element2.getAttributeValue(FEATURE_ID), null, element2.getAttributeValue(IMPLEMENTATION_NAME), null));
        }
    }
}

