/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorListenerAdapter;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTask;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkDownloadTracker {
    private static final Logger LOG = Logger.getInstance(SdkDownloadTracker.class);
    private final List<PendingDownload> myPendingTasks = new CopyOnWriteArrayList<PendingDownload>();

    @NotNull
    public static SdkDownloadTracker getInstance() {
        return (SdkDownloadTracker)ApplicationManager.getApplication().getService(SdkDownloadTracker.class);
    }

    public SdkDownloadTracker() {
        ApplicationManager.getApplication().getMessageBus().simpleConnect().subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)new ProjectJdkTable.Listener(){

            public void jdkRemoved(@NotNull Sdk jdk) {
                SdkDownloadTracker.this.onSdkRemoved(jdk);
            }
        });
    }

    public void onSdkRemoved(@NotNull Sdk sdk2) {
        PendingDownload task2 = this.findTask(sdk2);
        if (task2 == null) {
            return;
        }
        task2.cancel();
    }

    private void removeTask(@NotNull PendingDownload task2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myPendingTasks.remove(task2);
    }

    @Nullable
    private PendingDownload findTask(@NotNull Sdk sdk2) {
        for (PendingDownload task2 : this.myPendingTasks) {
            if (!task2.containsSdk(sdk2)) continue;
            return task2;
        }
        return null;
    }

    public void registerEditableSdk(@NotNull Sdk original, @NotNull Sdk editable) {
        PendingDownload task2 = this.findTask(original);
        if (task2 == null) {
            return;
        }
        LOG.assertTrue(this.findTask(editable) == null, (Object)("Download is already running for the SDK " + editable));
        task2.registerEditableSdk(editable);
    }

    public void registerSdkDownload(@NotNull Sdk originalSdk, @NotNull SdkDownloadTask item) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.findTask(originalSdk) == null, (Object)("Download is already running for the SDK " + originalSdk));
        PendingDownload pd = new PendingDownload(originalSdk, item);
        pd.configureSdk(originalSdk);
        this.myPendingTasks.add(pd);
    }

    public void tryRegisterSdkDownloadFailureHandler(@NotNull Sdk originalSdk, @NotNull Runnable onSdkFailed) {
        PendingDownload task2 = this.findTask(originalSdk);
        if (task2 == null) {
            return;
        }
        task2.mySdkFailedHandlers.add(onSdkFailed);
    }

    public void startSdkDownloadIfNeeded(@NotNull Sdk sdkFromTable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PendingDownload task2 = this.findTask(sdkFromTable);
        if (task2 == null) {
            return;
        }
        task2.startDownloadIfNeeded(sdkFromTable);
    }

    @NotNull
    public List<Sdk> findDownloadingSdks(@Nullable String sdkName) {
        if (sdkName == null) {
            return Collections.emptyList();
        }
        ArrayList<Sdk> result2 = new ArrayList<Sdk>();
        for (PendingDownload task2 : this.myPendingTasks) {
            for (Sdk sdk2 : task2.myEditableSdks.copy()) {
                if (!Objects.equals(sdkName, sdk2.getName())) continue;
                result2.add(sdk2);
            }
        }
        return result2;
    }

    public boolean isDownloading(@NotNull Sdk sdk2) {
        return this.findTask(sdk2) != null;
    }

    public boolean tryRegisterDownloadingListener(@NotNull Sdk sdk2, @NotNull Disposable lifetime, @NotNull ProgressIndicator indicator, @NotNull Consumer<Boolean> onDownloadCompleteCallback) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PendingDownload pd = this.findTask(sdk2);
        if (pd == null) {
            return false;
        }
        pd.registerListener(lifetime, indicator, onDownloadCompleteCallback);
        return true;
    }

    private static class PendingDownload {
        final SdkDownloadTask myTask;
        final ProgressIndicatorBase myProgressIndicator = new ProgressIndicatorBase();
        final PendingDownloadModalityTracker myModalityTracker = new PendingDownloadModalityTracker();
        final SynchronizedIdentityHashSet<Sdk> myEditableSdks = new SynchronizedIdentityHashSet();
        final SynchronizedIdentityHashSet<Runnable> mySdkFailedHandlers = new SynchronizedIdentityHashSet();
        final SynchronizedIdentityHashSet<Consumer<Boolean>> myCompleteListeners = new SynchronizedIdentityHashSet();
        final SynchronizedIdentityHashSet<Disposable> myDisposables = new SynchronizedIdentityHashSet();
        final AtomicBoolean myIsDownloading = new AtomicBoolean(false);

        PendingDownload(@NotNull Sdk sdk2, @NotNull SdkDownloadTask task2) {
            this.myEditableSdks.add(sdk2);
            this.myTask = task2;
        }

        boolean containsSdk(@NotNull Sdk sdk2) {
            return this.myEditableSdks.contains(sdk2);
        }

        void registerEditableSdk(@NotNull Sdk editable) {
            this.myEditableSdks.add(editable);
        }

        void startDownloadIfNeeded(@NotNull Sdk sdkFromTable) {
            if (!this.myIsDownloading.compareAndSet(false, true)) {
                return;
            }
            if (this.myProgressIndicator.isCanceled()) {
                return;
            }
            this.myModalityTracker.updateModality();
            final SdkType type = (SdkType)sdkFromTable.getSdkType();
            String message = ProjectBundle.message((String)"sdk.configure.downloading", (Object[])new Object[]{type.getPresentableName()});
            Task.Backgroundable task2 = new Task.Backgroundable(null, message, true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(final @NotNull ProgressIndicator indicator) {
                    try {
                        ProgressIndicatorBase middleMan2 = new ProgressIndicatorBase(){

                            @Override
                            protected void delegateProgressChange(@NotNull AbstractProgressIndicatorExBase.IndicatorAction action2) {
                                action2.execute((ProgressIndicatorEx)indicator);
                            }
                        };
                        new ProgressIndicatorListenerAdapter(){

                            @Override
                            public void cancelled() {
                                myProgressIndicator.cancel();
                            }
                        }.installToProgress((ProgressIndicatorEx)indicator);
                        myProgressIndicator.addStateDelegate(middleMan2);
                        myProgressIndicator.checkCanceled();
                        try {
                            myTask.doDownload(myProgressIndicator);
                        }
                        finally {
                            myProgressIndicator.removeStateDelegate(middleMan2);
                        }
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (File[])new File[]{new File(myTask.getPlannedHomeDir())});
                        this.onSdkDownloadCompleted(false);
                    }
                    catch (ProcessCanceledException e) {
                        this.onSdkDownloadCompleted(true);
                    }
                    catch (Throwable e) {
                        if (!myProgressIndicator.isCanceled()) {
                            LOG.warn("SDK Download failed. " + e.getMessage(), e);
                            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                                myModalityTracker.invokeLater(() -> Messages.showErrorDialog((String)ProjectBundle.message((String)"error.message.sdk.download.failed", (Object[])new Object[]{type.getPresentableName()}), (String)this.getTitle()));
                            }
                        }
                        this.onSdkDownloadCompleted(true);
                    }
                }
            };
            ProgressManager.getInstance().run((Task)task2);
        }

        void registerListener(@NotNull Disposable lifetime, final @NotNull ProgressIndicator uiIndicator, final @NotNull Consumer<Boolean> completedCallback) {
            this.myModalityTracker.updateModality();
            if (!this.myCompleteListeners.add(completedCallback)) {
                return;
            }
            this.myProgressIndicator.addStateDelegate((ProgressIndicatorEx)uiIndicator);
            Disposable unsubscribe = new Disposable(){

                public void dispose() {
                    myProgressIndicator.removeStateDelegate((ProgressIndicatorEx)uiIndicator);
                    myCompleteListeners.remove((Consumer<Boolean>)completedCallback);
                    myDisposables.remove(this);
                }
            };
            Disposer.register((Disposable)lifetime, (Disposable)unsubscribe);
            this.myDisposables.add(unsubscribe);
        }

        void onSdkDownloadCompleted(boolean failed) {
            if (!failed) {
                this.myModalityTracker.invokeLater(() -> WriteAction.run(() -> {
                    for (Sdk sdk2 : this.myEditableSdks.copy()) {
                        try {
                            SdkType sdkType = (SdkType)sdk2.getSdkType();
                            this.configureSdk(sdk2);
                            try {
                                String actualVersion = sdkType.getVersionString(sdk2);
                                SdkModificator modificator = sdk2.getSdkModificator();
                                modificator.setVersionString(actualVersion);
                                modificator.commitChanges();
                            }
                            catch (Exception e) {
                                LOG.warn("Failed to configure a downloaded SDK. " + e.getMessage(), (Throwable)e);
                            }
                            sdkType.setupSdkPaths(sdk2);
                        }
                        catch (Exception e) {
                            LOG.warn("Failed to set up SDK " + sdk2 + ". " + e.getMessage(), (Throwable)e);
                        }
                    }
                }));
            }
            this.disposeNow(!failed);
        }

        void disposeNow(boolean succeeded) {
            this.myModalityTracker.invokeLater(() -> {
                SdkDownloadTracker.getInstance().removeTask(this);
                this.myCompleteListeners.copy().forEach(it -> it.consume((Object)succeeded));
                this.myDisposables.copy().forEach(it -> Disposer.dispose((Disposable)it));
                if (!succeeded) {
                    this.mySdkFailedHandlers.copy().forEach(Runnable::run);
                }
            });
        }

        void cancel() {
            this.myProgressIndicator.cancel();
            this.disposeNow(false);
        }

        void configureSdk(@NotNull Sdk sdk2) {
            SdkModificator mod = sdk2.getSdkModificator();
            mod.setVersionString(this.myTask.getPlannedVersion());
            mod.setHomePath(FileUtil.toSystemIndependentName((String)this.myTask.getPlannedHomeDir()));
            mod.commitChanges();
        }
    }

    private static class SynchronizedIdentityHashSet<T> {
        private final Set<T> myCollection = Sets.newIdentityHashSet();

        private SynchronizedIdentityHashSet() {
        }

        synchronized boolean add(@NotNull T sdk2) {
            return this.myCollection.add(sdk2);
        }

        synchronized void remove(@NotNull T sdk2) {
            this.myCollection.remove(sdk2);
        }

        synchronized boolean contains(@NotNull T sdk2) {
            return this.myCollection.contains(sdk2);
        }

        @NotNull
        synchronized List<T> copy() {
            return new ArrayList<T>(this.myCollection);
        }
    }

    private static class PendingDownloadModalityTracker {
        ModalityState myModalityState = PendingDownloadModalityTracker.modality();

        private PendingDownloadModalityTracker() {
        }

        @NotNull
        static ModalityState modality() {
            ModalityState state = ApplicationManager.getApplication().getCurrentModalityState();
            TransactionGuard.getInstance().assertWriteSafeContext(state);
            return state;
        }

        synchronized void updateModality() {
            ModalityState newModality = PendingDownloadModalityTracker.modality();
            if (newModality != this.myModalityState && newModality.dominates(this.myModalityState)) {
                this.myModalityState = newModality;
            }
        }

        synchronized void invokeLater(@NotNull Runnable r) {
            ApplicationManager.getApplication().invokeLater(r, this.myModalityState);
        }
    }
}

