/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class ContentEntryEditingAction
extends ToggleAction
implements DumbAware {
    protected final JTree myTree;

    protected ContentEntryEditingAction(JTree tree) {
        this.myTree = tree;
        this.getTemplatePresentation().setEnabled(true);
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Presentation presentation2 = e.getPresentation();
        presentation2.setEnabled(true);
        VirtualFile[] files2 = this.getSelectedFiles();
        if (files2.length == 0) {
            presentation2.setEnabled(false);
            return;
        }
        for (VirtualFile file2 : files2) {
            if (file2 != null && file2.isDirectory()) continue;
            presentation2.setEnabled(false);
            break;
        }
    }

    protected final VirtualFile @NotNull [] getSelectedFiles() {
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths == null) {
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList<VirtualFile> selected2 = new ArrayList<VirtualFile>();
        for (TreePath treePath : selectionPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object nodeDescriptor = node.getUserObject();
            if (!(nodeDescriptor instanceof FileNodeDescriptor)) {
                return VirtualFile.EMPTY_ARRAY;
            }
            FileElement fileElement = ((FileNodeDescriptor)((Object)nodeDescriptor)).getElement();
            VirtualFile file2 = fileElement.getFile();
            if (file2 == null) continue;
            selected2.add(file2);
        }
        return selected2.toArray(VirtualFile.EMPTY_ARRAY);
    }

    public boolean displayTextInToolbar() {
        return true;
    }
}

