/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkDetector {
    private static final Logger LOG = Logger.getInstance(SdkDetector.class);
    private final AtomicBoolean myIsRunning = new AtomicBoolean(false);
    private final Object myPublicationLock = new Object();
    private final Set<DetectedSdkListener> myListeners = new HashSet<DetectedSdkListener>();
    private final List<Consumer<DetectedSdkListener>> myDetectedResults = new ArrayList<Consumer<DetectedSdkListener>>();
    private final DetectedSdkListener myMulticaster = new DetectedSdkListener(){

        void logEvent(@NotNull Consumer<DetectedSdkListener> e) {
            SdkDetector.this.myDetectedResults.add(e);
            for (DetectedSdkListener listener2 : SdkDetector.this.myListeners) {
                e.accept(listener2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSearchStarted() {
            Object object = SdkDetector.this.myPublicationLock;
            synchronized (object) {
                SdkDetector.this.myDetectedResults.clear();
                this.logEvent(listener2 -> listener2.onSearchStarted());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSdkDetected(@NotNull SdkType type, @NotNull String version2, @NotNull String home) {
            Object object = SdkDetector.this.myPublicationLock;
            synchronized (object) {
                this.logEvent(listener2 -> listener2.onSdkDetected(type, version2, home));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSearchCompleted() {
            Object object = SdkDetector.this.myPublicationLock;
            synchronized (object) {
                SdkDetector.this.myIsRunning.set(false);
                this.logEvent(e -> e.onSearchCompleted());
            }
        }
    };

    @NotNull
    public static SdkDetector getInstance() {
        return (SdkDetector)ApplicationManager.getApplication().getService(SdkDetector.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDetectedSdksWithUpdate(@Nullable Project project, @NotNull Disposable lifetime, @NotNull ModalityState callbackModality, @NotNull DetectedSdkListener listener2) {
        ApplicationManager.getApplication().assertIsWriteThread();
        if (!SdkDetector.isDetectorEnabled()) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            LOG.warn("Sdks detection is skipped, because deadlock is coming for synchronous detection");
            return;
        }
        EdtDetectedSdkListener actualListener = new EdtDetectedSdkListener(callbackModality, listener2);
        Object object = this.myPublicationLock;
        synchronized (object) {
            if (!this.myListeners.add(actualListener)) {
                return;
            }
            if (this.myListeners.size() <= 1 && this.myIsRunning.compareAndSet(false, true)) {
                this.myDetectedResults.clear();
                SdkDetector.startSdkDetection(project, this.myMulticaster);
            }
            this.myDetectedResults.forEach(result2 -> result2.accept(listener2));
        }
        Disposer.register((Disposable)lifetime, () -> this.myListeners.remove(actualListener));
    }

    private static boolean isDetectorEnabled() {
        return Registry.is((String)"sdk.detector.enabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detectSdks(@NotNull SdkType type, @NotNull ProgressIndicator indicator, @NotNull DetectedSdkListener callback2) {
        callback2.onSearchStarted();
        try {
            if (SdkDetector.isDetectorEnabled()) {
                SdkDetector.detect(type, indicator, callback2);
            }
        }
        finally {
            callback2.onSearchCompleted();
        }
    }

    private static void detect(@NotNull SdkType type, @NotNull ProgressIndicator indicator, @NotNull DetectedSdkListener callback2) {
        try {
            Collection suggestedPaths = type.suggestHomePaths();
            for (String path : suggestedPaths) {
                String version2;
                block10: {
                    indicator.checkCanceled();
                    if (path == null) continue;
                    try {
                        if (!new File(path).exists()) continue;
                        if (!type.isValidSdkHome(path)) {
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to process detected SDK for " + type + " at " + path + ". " + e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                try {
                    version2 = type.getVersionString(path);
                }
                catch (Exception e) {
                    LOG.warn("Failed to get the detected SDK version for " + type + " at " + path + ". " + e.getMessage(), (Throwable)e);
                    continue;
                }
                if (version2 == null) {
                    LOG.warn("No version is returned for detected SDK " + type + " at " + path);
                    continue;
                }
                callback2.onSdkDetected(type, version2, path);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Failed to detect SDK: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void startSdkDetection(@Nullable Project project, final @NotNull DetectedSdkListener callback2) {
        Task.Backgroundable task2 = new Task.Backgroundable(project, ProjectBundle.message((String)"progress.title.detecting.sdks", (Object[])new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    SdkType[] types;
                    callback2.onSearchStarted();
                    indicator.setIndeterminate(false);
                    int item = 0;
                    for (SdkType type : types = SdkType.getAllTypes()) {
                        indicator.setFraction((double)((float)item++ / (float)types.length));
                        indicator.checkCanceled();
                        SdkDetector.detect(type, indicator, callback2);
                    }
                }
                finally {
                    callback2.onSearchCompleted();
                }
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    private static class EdtDetectedSdkListener
    implements DetectedSdkListener {
        private final ModalityState myState;
        private final DetectedSdkListener myTarget;

        EdtDetectedSdkListener(@NotNull ModalityState state, @NotNull DetectedSdkListener target2) {
            this.myState = state;
            this.myTarget = target2;
        }

        void dispatch(@NotNull Runnable r) {
            ApplicationManager.getApplication().invokeLater(r, this.myState);
        }

        @Override
        public void onSdkDetected(@NotNull SdkType type, @NotNull String version2, @NotNull String home) {
            this.dispatch(() -> this.myTarget.onSdkDetected(type, version2, home));
        }

        @Override
        public void onSearchStarted() {
            this.dispatch(() -> this.myTarget.onSearchStarted());
        }

        @Override
        public void onSearchCompleted() {
            this.dispatch(() -> this.myTarget.onSearchCompleted());
        }

        public int hashCode() {
            return this.myTarget.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof EdtDetectedSdkListener && Objects.equals(((EdtDetectedSdkListener)obj).myTarget, this.myTarget);
        }
    }

    public static interface DetectedSdkListener {
        public void onSdkDetected(@NotNull SdkType var1, @NotNull String var2, @NotNull String var3);

        default public void onSearchStarted() {
        }

        default public void onSearchCompleted() {
        }
    }
}

