/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.roots.ui.SdkAppearanceService;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkAppearanceServiceImpl
extends SdkAppearanceService {
    @NotNull
    public CellAppearanceEx forNullSdk(boolean selected2) {
        return FileAppearanceService.getInstance().forInvalidUrl(ProjectBundle.message((String)"sdk.missing.item", (Object[])new Object[0]));
    }

    @NotNull
    public CellAppearanceEx forSdk(@Nullable Sdk sdk2, boolean isInComboBox, boolean selected2, boolean showVersion) {
        if (sdk2 == null) {
            return this.forNullSdk(selected2);
        }
        String name = sdk2.getName();
        SdkType sdkType = (SdkType)sdk2.getSdkType();
        boolean hasValidPath = sdkType.sdkHasValidPath(sdk2);
        String versionString = showVersion ? sdk2.getVersionString() : null;
        return this.forSdk((SdkTypeId)sdkType, name, versionString, hasValidPath, isInComboBox, selected2);
    }

    @NotNull
    public CellAppearanceEx forSdk(@NotNull SdkTypeId sdkType, @NotNull String name, @Nullable String versionString, boolean hasValidPath, boolean isInComboBox, boolean selected2) {
        CompositeAppearance appearance = new CompositeAppearance();
        if (sdkType instanceof SdkType) {
            appearance.setIcon(((SdkType)sdkType).getIcon());
        }
        SimpleTextAttributes attributes = SdkAppearanceServiceImpl.getTextAttributes(hasValidPath, selected2);
        CompositeAppearance.DequeEnd ending = appearance.getEnding();
        ending.addText(StringUtil.shortenTextWithEllipsis((String)name, (int)50, (int)0), attributes);
        if (versionString != null && !versionString.equals(name) && !StringUtil.isEmptyOrSpaces((String)versionString)) {
            SimpleTextAttributes textAttributes = isInComboBox && !selected2 ? SimpleTextAttributes.SYNTHETIC_ATTRIBUTES : (SystemInfo.isMac && selected2 ? new SimpleTextAttributes(0, (Color)JBColor.WHITE) : SimpleTextAttributes.GRAY_ATTRIBUTES);
            ending.addComment(StringUtil.shortenTextWithEllipsis((String)versionString, (int)30, (int)0), textAttributes);
        }
        return ending.getAppearance();
    }

    private static SimpleTextAttributes getTextAttributes(boolean valid, boolean selected2) {
        if (!valid) {
            return SimpleTextAttributes.ERROR_ATTRIBUTES;
        }
        if (!(!selected2 || SystemInfo.isWinVistaOrNewer && UIManager.getLookAndFeel().getName().contains("Windows"))) {
            return SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }
}

