/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.storage;

import com.intellij.ProjectTopics;
import com.intellij.application.options.PathMacrosCollector;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClasspathStorage
extends StateStorageBase<Boolean> {
    private static final Key<Boolean> ERROR_NOTIFIED_KEY = Key.create((String)"ClasspathStorage.ERROR_NOTIFIED_KEY");
    private static final Logger LOG = Logger.getInstance(ClasspathStorage.class);
    private final ClasspathStorageProvider.ClasspathConverter myConverter;
    private final PathMacroSubstitutor myPathMacroSubstitutor;

    public ClasspathStorage(final @NotNull Module module, @NotNull StateStorageManager storageManager) {
        String storageType = module.getOptionValue("classpath");
        if (storageType == null) {
            throw new IllegalStateException("Classpath storage requires non-default storage type");
        }
        ClasspathStorageProvider provider = ClasspathStorage.getProvider(storageType);
        if (provider == null) {
            if (module.getUserData(ERROR_NOTIFIED_KEY) == null) {
                Notification n = new Notification("Load Error", ProjectBundle.message((String)"notification.title.cannot.load.module.0", (Object[])new Object[]{module.getName()}), ProjectBundle.message((String)"notification.content.support.for.0.format.is.not.installed", (Object[])new Object[]{storageType}), NotificationType.ERROR);
                n.notify(module.getProject());
                module.putUserData(ERROR_NOTIFIED_KEY, (Object)Boolean.TRUE);
                LOG.info("Classpath storage provider " + storageType + " not found");
            }
            this.myConverter = new MissingClasspathConverter();
        } else {
            this.myConverter = provider.createConverter(module);
        }
        this.myPathMacroSubstitutor = storageManager.getMacroSubstitutor();
        final List<String> paths = this.myConverter.getFilePaths();
        MessageBusConnection busConnection = module.getMessageBus().connect();
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (paths.isEmpty()) {
                    return;
                }
                for (VFileEvent vFileEvent : events) {
                    if (!vFileEvent.isFromRefresh() || !(vFileEvent instanceof VFileContentChangeEvent) || !StateStorageManagerKt.isFireStorageFileChangedEvent(vFileEvent)) continue;
                    String eventPath = vFileEvent.getPath();
                    for (String path : paths) {
                        if (!path.equals(eventPath)) continue;
                        StoreReloadManager.getInstance().storageFilesChanged(Collections.singletonMap(module, Collections.singletonList(ClasspathStorage.this)));
                        return;
                    }
                }
            }
        });
        busConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules2, @NotNull Function<Module, String> oldNameProvider) {
                for (Module renamedModule : modules2) {
                    ClasspathStorageProvider provider;
                    if (!renamedModule.equals(module) || (provider = ClasspathStorage.getProvider(ClassPathStorageUtil.getStorageType(module))) == null) continue;
                    provider.moduleRenamed(module, (String)oldNameProvider.fun((Object)module), module.getName());
                    provider.modulePathChanged(module);
                }
            }
        });
    }

    @Override
    @Nullable
    public <S> S deserializeState(@Nullable Element serializedState, @NotNull Class<S> stateClass, @Nullable S mergeInto) {
        if (serializedState == null) {
            return null;
        }
        ModuleRootManagerImpl.ModuleRootManagerState state = new ModuleRootManagerImpl.ModuleRootManagerState();
        state.readExternal(serializedState);
        return (S)state;
    }

    @Override
    protected boolean hasState(@NotNull Boolean storageData, @NotNull String componentName) {
        return storageData == false;
    }

    @Override
    @Nullable
    public Element getSerializedState(@NotNull Boolean storageData, Object component2, @NotNull String componentName, boolean archive) {
        if (storageData.booleanValue()) {
            return null;
        }
        Element element2 = new Element("component");
        ApplicationManager.getApplication().runReadAction(() -> {
            ModifiableRootModel model = null;
            try {
                model = ((ModuleRootManager)component2).getModifiableModel();
                model.clear();
                try {
                    this.myConverter.readClasspath(model);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ((RootModelImpl)model).writeExternal(element2);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
            }
            finally {
                if (model != null) {
                    model.dispose();
                }
            }
        });
        if (this.myPathMacroSubstitutor != null) {
            this.myPathMacroSubstitutor.expandPaths(element2);
            if (this.myPathMacroSubstitutor instanceof TrackingPathMacroSubstitutor) {
                ((TrackingPathMacroSubstitutor)this.myPathMacroSubstitutor).addUnknownMacros("NewModuleRootManager", PathMacrosCollector.getMacroNames(element2));
            }
        }
        this.getStorageDataRef().set(true);
        return element2;
    }

    @Override
    @NotNull
    protected Boolean loadData() {
        return false;
    }

    @Nullable
    public SaveSessionProducer createSaveSessionProducer() {
        return this.myConverter.startExternalization();
    }

    public void analyzeExternalChangesAndUpdateIfNeeded(@NotNull Set<String> componentNames) {
        componentNames.add("NewModuleRootManager");
        this.getStorageDataRef().set(false);
    }

    @Override
    public boolean isUseVfsForWrite() {
        return true;
    }

    @Nullable
    public static ClasspathStorageProvider getProvider(@NotNull String type) {
        if (type.equals("default")) {
            return null;
        }
        for (ClasspathStorageProvider provider : (ClasspathStorageProvider[])ClasspathStorageProvider.EXTENSION_POINT_NAME.getExtensions()) {
            if (!type.equals(provider.getID())) continue;
            return provider;
        }
        return null;
    }

    @NotNull
    public static String getStorageRootFromOptions(@NotNull Module module) {
        String moduleRoot = ModuleUtilCore.getModuleDirPath((Module)module);
        String storageRef = module.getOptionValue("classpath-dir");
        if (storageRef == null) {
            return moduleRoot;
        }
        storageRef = FileUtil.toSystemIndependentName((String)storageRef);
        if (SystemInfo.isWindows ? FileUtil.isAbsolutePlatformIndependent((String)storageRef) : FileUtil.isUnixAbsolutePath((String)storageRef)) {
            return storageRef;
        }
        return moduleRoot + '/' + storageRef;
    }

    public static void setStorageType(@NotNull ModuleRootModel model, @NotNull String storageId) {
        Module module = model.getModule();
        String oldStorageType = ClassPathStorageUtil.getStorageType(module);
        if (oldStorageType.equals(storageId)) {
            return;
        }
        ClasspathStorageProvider provider = ClasspathStorage.getProvider(oldStorageType);
        if (provider != null) {
            provider.detach(module);
        }
        module.setOption("classpath", (provider = ClasspathStorage.getProvider(storageId)) == null ? null : storageId);
        module.setOption("classpath-dir", provider == null ? null : provider.getContentRoot(model));
    }

    public static void modulePathChanged(@NotNull Module module) {
        ClasspathStorageProvider provider = ClasspathStorage.getProvider(ClassPathStorageUtil.getStorageType(module));
        if (provider != null) {
            provider.modulePathChanged(module);
        }
    }

    private static class MissingClasspathConverter
    implements ClasspathStorageProvider.ClasspathConverter {
        private MissingClasspathConverter() {
        }

        @Override
        @NotNull
        public List<String> getFilePaths() {
            return Collections.emptyList();
        }

        @Override
        public void readClasspath(@NotNull ModifiableRootModel model) {
        }
    }
}

