/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RenameLibraryHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance(RenameLibraryHandler.class);

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Library library = (Library)LangDataKeys.LIBRARY.getData(dataContext);
        return library != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        LOG.assertTrue(false);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements2, @NotNull DataContext dataContext) {
        Library library = (Library)LangDataKeys.LIBRARY.getData(dataContext);
        LOG.assertTrue(library != null);
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.library.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.library", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)library.getName(), (InputValidator)new MyInputValidator(project, library));
    }

    public String getActionTitle() {
        return IdeBundle.message((String)"title.rename.library", (Object[])new Object[0]);
    }

    private static class MyInputValidator
    implements InputValidator {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Library myLibrary;

        MyInputValidator(@NotNull Project project, @NotNull Library library) {
            this.myProject = project;
            this.myLibrary = library;
        }

        public boolean checkInput(String inputString) {
            return inputString != null && !inputString.isEmpty() && this.myLibrary.getTable().getLibraryByName(inputString) == null;
        }

        public boolean canClose(final String inputString) {
            final String oldName = this.myLibrary.getName();
            Library.ModifiableModel modifiableModel = this.renameLibrary(inputString);
            Ref success = Ref.create((Object)Boolean.TRUE);
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                BasicUndoableAction action2 = new BasicUndoableAction(){

                    public void undo() {
                        Library.ModifiableModel modifiableModel1 = this.renameLibrary(oldName);
                        modifiableModel1.commit();
                    }

                    public void redo() {
                        Library.ModifiableModel modifiableModel1 = this.renameLibrary(inputString);
                        modifiableModel1.commit();
                    }
                };
                UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)action2);
                ApplicationManager.getApplication().runWriteAction(() -> modifiableModel.commit());
            }, IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{oldName}), null);
            return (Boolean)success.get();
        }

        @NotNull
        private Library.ModifiableModel renameLibrary(String inputString) {
            Library.ModifiableModel modifiableModel = this.myLibrary.getModifiableModel();
            modifiableModel.setName(inputString);
            return modifiableModel;
        }
    }
}

