/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JavaSyntheticLibrary;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import com.intellij.openapi.roots.impl.DirectoryInfoWithExcludePatterns;
import com.intellij.openapi.roots.impl.NonProjectDirectoryInfo;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.PackageDirectoryCache;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.CollectionQuery;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.Stack;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

class RootIndex {
    static final Comparator<OrderEntry> BY_OWNER_MODULE = (o1, o2) -> {
        String name1 = o1.getOwnerModule().getName();
        String name2 = o2.getOwnerModule().getName();
        return name1.compareTo(name2);
    };
    private static final Logger LOG = Logger.getInstance(RootIndex.class);
    private static final FileTypeRegistry ourFileTypes = FileTypeRegistry.getInstance();
    private final Map<VirtualFile, String> myPackagePrefixByRoot;
    private final Map<VirtualFile, DirectoryInfo> myRootInfos;
    private final ConcurrentBitSet myNonInterestingIds = new ConcurrentBitSet();
    @NotNull
    private final Project myProject;
    final PackageDirectoryCache myPackageDirectoryCache;
    private OrderEntryGraph myOrderEntryGraph;

    RootIndex(@NotNull Project project) {
        ModuleManager manager;
        this.myProject = project;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (project.isDefault()) {
            LOG.error("Directory index may not be queried for default project");
        }
        if ((manager = ModuleManager.getInstance((Project)project)) instanceof ModuleManagerImpl) {
            LOG.assertTrue(((ModuleManagerImpl)manager).areModulesLoaded(), (Object)"Directory index can only be queried after project initialization");
        }
        RootInfo info = this.buildRootInfo(project);
        Set<VirtualFile> allRoots = info.getAllRoots();
        MultiMap rootsByPackagePrefix = MultiMap.create((int)allRoots.size(), (float)0.75f);
        this.myRootInfos = new HashMap<VirtualFile, DirectoryInfo>(allRoots.size());
        this.myPackagePrefixByRoot = new HashMap<VirtualFile, String>(allRoots.size());
        ArrayList<List<VirtualFile>> hierarchies = new ArrayList<List<VirtualFile>>(allRoots.size());
        for (VirtualFile root : allRoots) {
            Pair<DirectoryInfo, String> pair;
            List<VirtualFile> hierarchy = RootIndex.getHierarchy(root, allRoots, info);
            hierarchies.add(hierarchy);
            if (hierarchy != null) {
                pair = RootIndex.calcDirectoryInfoAndPackagePrefix(root, hierarchy, info);
            } else {
                Pair<DirectoryInfo, String> pair2;
                pair = pair2;
                super((Object)NonProjectDirectoryInfo.IGNORED, null);
            }
            Pair<DirectoryInfo, String> pair3 = pair;
            this.myRootInfos.put(root, (DirectoryInfo)pair3.first);
            String packagePrefix = (String)pair3.second;
            rootsByPackagePrefix.putValue((Object)packagePrefix, (Object)root);
            this.myPackagePrefixByRoot.put(root, packagePrefix);
        }
        this.storeContentsBeneathExcluded(allRoots, hierarchies);
        this.myPackageDirectoryCache = new PackageDirectoryCache(rootsByPackagePrefix){

            @Override
            protected boolean isPackageDirectory(@NotNull VirtualFile dir, @NotNull String packageName) {
                return RootIndex.this.getInfoForFile(dir).isInProject(dir) && packageName.equals(RootIndex.this.getPackageName(dir));
            }
        };
    }

    private void storeContentsBeneathExcluded(@NotNull Set<? extends VirtualFile> allRoots, @NotNull List<? extends List<VirtualFile>> hierarchies) {
        int i2 = 0;
        for (VirtualFile virtualFile : allRoots) {
            DirectoryInfo parentInfo;
            VirtualFile parentRoot;
            List<VirtualFile> hierarchy;
            if ((hierarchy = hierarchies.get(i2++)) == null) continue;
            DirectoryInfo dirInfo = this.myRootInfos.get(virtualFile);
            assert (dirInfo != null);
            boolean hasContent = !RootIndex.isExcluded(dirInfo) && dirInfo.getContentRoot() != null;
            if (!hasContent || (parentRoot = hierarchy.size() >= 2 ? hierarchy.get(1) : null) == null || !RootIndex.isExcluded(parentInfo = this.myRootInfos.get(parentRoot))) continue;
            this.addContentBeneathExcludedInfo(parentInfo, parentRoot, dirInfo);
        }
    }

    private void addContentBeneathExcludedInfo(@NotNull DirectoryInfo parentExcludedInfo, @NotNull VirtualFile parentFile, @NotNull DirectoryInfo childInfo) {
        List<DirectoryInfoImpl> beneathInfo;
        if (parentExcludedInfo instanceof NonProjectDirectoryInfo.WithBeneathInfo) {
            beneathInfo = ((NonProjectDirectoryInfo.WithBeneathInfo)parentExcludedInfo).myContentInfosBeneath;
        } else if (parentExcludedInfo instanceof NonProjectDirectoryInfo) {
            NonProjectDirectoryInfo.WithBeneathInfo newInfo = new NonProjectDirectoryInfo.WithBeneathInfo((NonProjectDirectoryInfo)parentExcludedInfo);
            this.myRootInfos.put(parentFile, newInfo);
            beneathInfo = newInfo.myContentInfosBeneath;
        } else if (parentExcludedInfo instanceof DirectoryInfoImpl) {
            beneathInfo = ((DirectoryInfoImpl)parentExcludedInfo).myContentInfosBeneath;
        } else {
            throw new RuntimeException("unknown info: " + parentExcludedInfo);
        }
        beneathInfo.add((DirectoryInfoImpl)childInfo);
    }

    private static boolean isExcluded(@NotNull DirectoryInfo info) {
        return info instanceof DirectoryInfoImpl && info.isExcluded(((DirectoryInfoImpl)info).getRoot()) || info instanceof NonProjectDirectoryInfo && ((NonProjectDirectoryInfo)info).isExcluded();
    }

    void onLowMemory() {
        this.myPackageDirectoryCache.onLowMemory();
    }

    @NotNull
    private RootInfo buildRootInfo(@NotNull Project project) {
        RootInfo info = new RootInfo();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (VirtualFile contentRoot : moduleRootManager.getContentRoots()) {
                if (info.contentRootOf.containsKey(contentRoot) || !RootIndex.ensureValid(contentRoot, module)) continue;
                info.contentRootOf.put(contentRoot, module);
            }
            for (ContentEntry contentEntry : moduleRootManager.getContentEntries()) {
                Object patterns;
                int n;
                if (!(contentEntry instanceof ContentEntryImpl) || !((ContentEntryImpl)contentEntry).isDisposed()) {
                    VirtualFile[] virtualFileArray = contentEntry.getExcludeFolderFiles();
                    int n2 = virtualFileArray.length;
                    for (n = 0; n < n2; ++n) {
                        VirtualFile excludeRoot = virtualFileArray[n];
                        if (!RootIndex.ensureValid(excludeRoot, contentEntry)) continue;
                        info.excludedFromModule.put(excludeRoot, module);
                    }
                    patterns = contentEntry.getExcludePatterns();
                    if (!patterns.isEmpty()) {
                        FileTypeAssocTable table = new FileTypeAssocTable();
                        Iterator iterator2 = patterns.iterator();
                        while (iterator2.hasNext()) {
                            String pattern = (String)iterator2.next();
                            table.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(pattern), (Object)Boolean.TRUE);
                        }
                        info.excludeFromContentRootTables.put(contentEntry.getFile(), table);
                    }
                }
                patterns = contentEntry.getSourceFolders();
                int table = ((SourceFolder[])patterns).length;
                for (n = 0; n < table; ++n) {
                    VirtualFile[] sourceFolder = patterns[n];
                    VirtualFile sourceFolderRoot = sourceFolder.getFile();
                    if (sourceFolderRoot == null || !RootIndex.ensureValid(sourceFolderRoot, sourceFolder)) continue;
                    info.sourceFolders.put(sourceFolderRoot, sourceFolder);
                    info.classAndSourceRoots.add(sourceFolderRoot);
                    info.sourceRootOf.putValue((Object)sourceFolderRoot, (Object)module);
                    info.packagePrefix.put(sourceFolderRoot, sourceFolder.getPackagePrefix());
                }
            }
            for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                Library library;
                if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                VirtualFile[] sourceRoots = entry.getRootFiles(OrderRootType.SOURCES);
                VirtualFile[] classRoots = entry.getRootFiles(OrderRootType.CLASSES);
                for (VirtualFile sourceRoot : sourceRoots) {
                    if (!RootIndex.ensureValid(sourceRoot, entry)) continue;
                    info.classAndSourceRoots.add(sourceRoot);
                    info.libraryOrSdkSources.add(sourceRoot);
                    info.packagePrefix.put(sourceRoot, "");
                }
                for (VirtualFile classRoot : classRoots) {
                    if (!RootIndex.ensureValid(classRoot, entry)) continue;
                    info.classAndSourceRoots.add(classRoot);
                    info.libraryOrSdkClasses.add(classRoot);
                    info.packagePrefix.put(classRoot, "");
                }
                if (!(orderEntry instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)orderEntry).getLibrary()) == null) continue;
                for (VirtualFile root : ((LibraryEx)library).getExcludedRoots()) {
                    if (!RootIndex.ensureValid(root, library)) continue;
                    info.excludedFromLibraries.putValue((Object)root, (Object)library);
                }
                for (VirtualFile root : sourceRoots) {
                    if (!RootIndex.ensureValid(root, library)) continue;
                    info.sourceOfLibraries.putValue((Object)root, (Object)library);
                }
                for (VirtualFile root : classRoots) {
                    if (!RootIndex.ensureValid(root, library)) continue;
                    info.classOfLibraries.putValue((Object)root, (Object)library);
                }
            }
        }
        for (AdditionalLibraryRootsProvider provider : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
            Collection<SyntheticLibrary> libraries = provider.getAdditionalProjectLibraries(project);
            for (SyntheticLibrary library : libraries) {
                for (VirtualFile sourceRoot : library.getSourceRoots()) {
                    if (!RootIndex.ensureValid(sourceRoot, library, provider)) continue;
                    info.libraryOrSdkSources.add(sourceRoot);
                    info.classAndSourceRoots.add(sourceRoot);
                    if (library instanceof JavaSyntheticLibrary) {
                        info.packagePrefix.put(sourceRoot, "");
                    }
                    info.sourceOfLibraries.putValue((Object)sourceRoot, (Object)library);
                }
                for (VirtualFile classRoot : library.getBinaryRoots()) {
                    if (!RootIndex.ensureValid(classRoot, project, provider)) continue;
                    info.libraryOrSdkClasses.add(classRoot);
                    info.classAndSourceRoots.add(classRoot);
                    if (library instanceof JavaSyntheticLibrary) {
                        info.packagePrefix.put(classRoot, "");
                    }
                    info.classOfLibraries.putValue((Object)classRoot, (Object)library);
                }
                for (VirtualFile file3 : library.getExcludedRoots()) {
                    if (!RootIndex.ensureValid(file3, project, provider)) continue;
                    info.excludedFromLibraries.putValue((Object)file3, (Object)library);
                }
            }
        }
        for (DirectoryIndexExcludePolicy policy : (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)project)) {
            List files2 = ContainerUtil.mapNotNull((Object[])policy.getExcludeUrlsForProject(), url -> VirtualFileManager.getInstance().findFileByUrl(url));
            info.excludedFromProject.addAll(ContainerUtil.filter((Collection)files2, file2 -> RootIndex.ensureValid(file2, project, policy)));
            Function<Sdk, List<VirtualFile>> fun = policy.getExcludeSdkRootsStrategy();
            if (fun == null) continue;
            HashSet<Sdk> sdks = new HashSet<Sdk>();
            for (Module m : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                Sdk sdk2 = ModuleRootManager.getInstance((Module)m).getSdk();
                if (sdk2 == null) continue;
                sdks.add(sdk2);
            }
            HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
            for (Sdk sdk3 : sdks) {
                roots.addAll(Arrays.asList(sdk3.getRootProvider().getFiles(OrderRootType.CLASSES)));
            }
            for (Sdk sdk4 : sdks) {
                info.excludedFromSdkRoots.addAll(ContainerUtil.filter((Collection)((Collection)fun.fun((Object)sdk4)), file2 -> RootIndex.ensureValid(file2, sdk4, policy) && !roots.contains(file2)));
            }
        }
        for (UnloadedModuleDescription description : moduleManager.getUnloadedModuleDescriptions()) {
            for (VirtualFilePointer pointer : description.getContentRoots()) {
                VirtualFile contentRoot = pointer.getFile();
                if (contentRoot == null || !RootIndex.ensureValid(contentRoot, description)) continue;
                info.contentRootOfUnloaded.put(contentRoot, description.getName());
            }
        }
        return info;
    }

    private static boolean ensureValid(@NotNull VirtualFile file2, @NotNull Object container2) {
        return RootIndex.ensureValid(file2, container2, null);
    }

    private static boolean ensureValid(@NotNull VirtualFile file2, @NotNull Object container2, @Nullable Object containerProvider) {
        if (!(file2 instanceof VirtualFileWithId)) {
            return false;
        }
        if (!file2.isValid()) {
            if (containerProvider != null) {
                LOG.error("Invalid root " + file2 + " in " + container2 + " provided by " + containerProvider.getClass());
            } else {
                LOG.error("Invalid root " + file2 + " in " + container2);
            }
            return false;
        }
        return true;
    }

    @NotNull
    private synchronized OrderEntryGraph getOrderEntryGraph() {
        if (this.myOrderEntryGraph == null) {
            RootInfo rootInfo = this.buildRootInfo(this.myProject);
            this.myOrderEntryGraph = new OrderEntryGraph(this.myProject, rootInfo);
        }
        return this.myOrderEntryGraph;
    }

    @NotNull
    DirectoryInfo getInfoForFile(@NotNull VirtualFile file2) {
        if (!file2.isValid() || !(file2 instanceof VirtualFileWithId)) {
            return NonProjectDirectoryInfo.INVALID;
        }
        for (VirtualFile each = file2; each != null; each = each.getParent()) {
            DirectoryInfo info;
            int id2 = ((VirtualFileWithId)each).getId();
            if (this.myNonInterestingIds.get(id2) || (info = this.handleInterestingId(id2, each)) == null) continue;
            return info;
        }
        return NonProjectDirectoryInfo.NOT_UNDER_PROJECT_ROOTS;
    }

    @Nullable
    private DirectoryInfo handleInterestingId(int id2, @NotNull VirtualFile file2) {
        DirectoryInfo info = this.myRootInfos.get(file2);
        if (info != null) {
            return info;
        }
        if (ourFileTypes.isFileIgnored(file2)) {
            return NonProjectDirectoryInfo.IGNORED;
        }
        if ((id2 > 500000000 || id2 < 0) && LOG.isDebugEnabled()) {
            LOG.error("Invalid id: " + id2 + " for " + file2 + " of " + file2.getClass());
        }
        this.myNonInterestingIds.set(id2);
        return null;
    }

    @NotNull
    Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        List result2 = this.myPackageDirectoryCache.getDirectoriesByPackageName(packageName);
        if (!includeLibrarySources) {
            result2 = ContainerUtil.filter(result2, file2 -> {
                DirectoryInfo info = this.getInfoForFile((VirtualFile)file2);
                return info.isInProject((VirtualFile)file2) && (!info.isInLibrarySource((VirtualFile)file2) || info.isInModuleSource((VirtualFile)file2) || info.hasLibraryClassRoot());
            });
        }
        return new CollectionQuery(result2);
    }

    @Nullable
    String getPackageName(@NotNull VirtualFile dir) {
        if (dir.isDirectory()) {
            if (ourFileTypes.isFileIgnored(dir)) {
                return null;
            }
            if (this.myPackagePrefixByRoot.containsKey(dir)) {
                return this.myPackagePrefixByRoot.get(dir);
            }
            VirtualFile parent = dir.getParent();
            if (parent != null) {
                return RootIndex.getPackageNameForSubdir(this.getPackageName(parent), dir.getName());
            }
        }
        return null;
    }

    private static String getPackageNameForSubdir(@Nullable String parentPackageName, @NotNull String subdirName) {
        if (parentPackageName == null) {
            return null;
        }
        return parentPackageName.isEmpty() ? subdirName : parentPackageName + "." + subdirName;
    }

    @Nullable(value="returns null only if dir is under ignored folder")
    private static @Nullable(value="returns null only if dir is under ignored folder") List<VirtualFile> getHierarchy(@NotNull VirtualFile deepDir, @NotNull Set<? extends VirtualFile> allRoots, @NotNull RootInfo info) {
        ArrayList<VirtualFile> hierarchy = new ArrayList<VirtualFile>();
        boolean hasContentRoots = false;
        for (VirtualFile dir = deepDir; dir != null; dir = dir.getParent()) {
            if (!(hasContentRoots |= info.contentRootOf.get(dir) != null) && ourFileTypes.isFileIgnored(dir)) {
                return null;
            }
            if (!allRoots.contains(dir)) continue;
            hierarchy.add(dir);
        }
        return hierarchy;
    }

    @NotNull
    private static Pair<DirectoryInfo, String> calcDirectoryInfoAndPackagePrefix(@NotNull VirtualFile root, @NotNull List<? extends VirtualFile> hierarchy, @NotNull RootInfo info) {
        VirtualFile nearestContentRoot;
        boolean inProject;
        VirtualFile moduleContentRoot = info.findNearestContentRoot(hierarchy);
        Pair librarySourceRootInfo = info.findLibraryRootInfo(hierarchy, true);
        VirtualFile librarySourceRoot = (VirtualFile)Pair.getFirst((Pair)librarySourceRootInfo);
        Pair libraryClassRootInfo = info.findLibraryRootInfo(hierarchy, false);
        VirtualFile libraryClassRoot = (VirtualFile)Pair.getFirst((Pair)libraryClassRootInfo);
        boolean bl = inProject = moduleContentRoot != null || (libraryClassRoot != null || librarySourceRoot != null) && !info.excludedFromSdkRoots.contains(root);
        if (inProject) {
            nearestContentRoot = moduleContentRoot;
        } else {
            nearestContentRoot = info.findNearestContentRootForExcluded(hierarchy);
            if (nearestContentRoot == null) {
                return new Pair((Object)NonProjectDirectoryInfo.EXCLUDED, null);
            }
        }
        VirtualFile sourceRoot = info.findPackageRootInfo(hierarchy, moduleContentRoot, null, librarySourceRoot);
        VirtualFile moduleSourceRoot = librarySourceRoot == null ? sourceRoot : info.findPackageRootInfo(hierarchy, moduleContentRoot, null, null);
        boolean inModuleSources = moduleSourceRoot != null;
        boolean inLibrarySource = librarySourceRoot != null;
        SourceFolder sourceFolder = moduleSourceRoot != null ? (SourceFolder)info.sourceFolders.get(moduleSourceRoot) : null;
        Module module = (Module)info.contentRootOf.get(nearestContentRoot);
        String unloadedModuleName = (String)info.contentRootOfUnloaded.get(nearestContentRoot);
        FileTypeAssocTable contentExcludePatterns = moduleContentRoot != null ? (FileTypeAssocTable)info.excludeFromContentRootTables.get(moduleContentRoot) : null;
        Condition<? super VirtualFile> libraryExclusionPredicate = RootIndex.getLibraryExclusionPredicate((List)Pair.getSecond((Pair)librarySourceRootInfo));
        DirectoryInfoImpl directoryInfo = contentExcludePatterns != null || libraryExclusionPredicate != null ? new DirectoryInfoWithExcludePatterns(root, module, nearestContentRoot, sourceRoot, sourceFolder, libraryClassRoot, inModuleSources, inLibrarySource, !inProject, (FileTypeAssocTable<Boolean>)contentExcludePatterns, libraryExclusionPredicate, unloadedModuleName) : new DirectoryInfoImpl(root, module, nearestContentRoot, sourceRoot, sourceFolder, libraryClassRoot, inModuleSources, inLibrarySource, !inProject, unloadedModuleName);
        VirtualFile packageRoot = libraryClassRoot == null ? sourceRoot : info.findPackageRootInfo(hierarchy, moduleContentRoot, libraryClassRoot, librarySourceRoot);
        String packagePrefix = info.calcPackagePrefix(root, packageRoot);
        return Pair.create((Object)directoryInfo, (Object)packagePrefix);
    }

    @Nullable
    private static Condition<? super VirtualFile> getLibraryExclusionPredicate(@Nullable List<? extends Condition<? super VirtualFile>> exclusions) {
        if (exclusions != null) {
            Condition result2 = Conditions.alwaysFalse();
            for (Condition<? super VirtualFile> condition : exclusions) {
                result2 = Conditions.or((Condition)result2, condition);
            }
            return result2 == Conditions.alwaysFalse() ? null : result2;
        }
        return null;
    }

    @NotNull
    List<OrderEntry> getOrderEntries(@NotNull DirectoryInfo info) {
        if (!(info instanceof DirectoryInfoImpl)) {
            return Collections.emptyList();
        }
        return this.getOrderEntryGraph().getOrderEntries(((DirectoryInfoImpl)info).getRoot());
    }

    @NotNull
    Set<String> getDependentUnloadedModules(@NotNull Module module) {
        return this.getOrderEntryGraph().getDependentUnloadedModules(module);
    }

    static abstract class SynchronizedSLRUCache<K, V>
    extends SLRUMap<K, V> {
        private final Object myLock = ObjectUtils.sentinel((String)"Root index lock");

        SynchronizedSLRUCache(int protectedQueueSize, int probationalQueueSize) {
            super(protectedQueueSize, probationalQueueSize);
        }

        @NotNull
        public abstract V createValue(@NotNull K var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public V get(K key) {
            Object value2;
            Object object = this.myLock;
            synchronized (object) {
                value2 = super.get(key);
                if (value2 != null) {
                    return (V)value2;
                }
            }
            value2 = this.createValue(key);
            object = this.myLock;
            synchronized (object) {
                this.put(key, value2);
            }
            return (V)value2;
        }
    }

    private static class RootInfo {
        @NotNull
        private final Set<VirtualFile> classAndSourceRoots = new LinkedHashSet<VirtualFile>();
        @NotNull
        private final Set<VirtualFile> libraryOrSdkSources = new HashSet<VirtualFile>();
        @NotNull
        private final Set<VirtualFile> libraryOrSdkClasses = new HashSet<VirtualFile>();
        @NotNull
        private final Map<VirtualFile, Module> contentRootOf = new HashMap<VirtualFile, Module>();
        @NotNull
        private final Map<VirtualFile, String> contentRootOfUnloaded = new HashMap<VirtualFile, String>();
        @NotNull
        private final MultiMap<VirtualFile, Module> sourceRootOf = MultiMap.createSet();
        @NotNull
        private final Map<VirtualFile, SourceFolder> sourceFolders = new HashMap<VirtualFile, SourceFolder>();
        @NotNull
        private final MultiMap<VirtualFile, Object> excludedFromLibraries = MultiMap.createSet();
        @NotNull
        private final MultiMap<VirtualFile, Object> classOfLibraries = MultiMap.createSet();
        @NotNull
        private final MultiMap<VirtualFile, Object> sourceOfLibraries = MultiMap.createSet();
        @NotNull
        private final Set<VirtualFile> excludedFromProject = new HashSet<VirtualFile>();
        @NotNull
        private final Set<VirtualFile> excludedFromSdkRoots = new HashSet<VirtualFile>();
        @NotNull
        private final Map<VirtualFile, Module> excludedFromModule = new HashMap<VirtualFile, Module>();
        @NotNull
        private final Map<VirtualFile, FileTypeAssocTable<Boolean>> excludeFromContentRootTables = new HashMap<VirtualFile, FileTypeAssocTable<Boolean>>();
        @NotNull
        private final Map<VirtualFile, String> packagePrefix = new HashMap<VirtualFile, String>();

        private RootInfo() {
        }

        @NotNull
        Set<VirtualFile> getAllRoots() {
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
            result2.addAll(this.classAndSourceRoots);
            result2.addAll(this.contentRootOf.keySet());
            result2.addAll(this.contentRootOfUnloaded.keySet());
            result2.addAll(this.excludedFromLibraries.keySet());
            result2.addAll(this.excludedFromModule.keySet());
            result2.addAll(this.excludedFromProject);
            result2.addAll(this.excludedFromSdkRoots);
            return result2;
        }

        @Nullable
        private VirtualFile findNearestContentRoot(@NotNull List<? extends VirtualFile> hierarchy) {
            Collection sourceRootOwners = null;
            boolean underExcludedSourceRoot = false;
            for (VirtualFile virtualFile : hierarchy) {
                Collection modulesForSourceRoot;
                FileTypeAssocTable<Boolean> table;
                Module module = this.contentRootOf.get(virtualFile);
                Module excludedFrom = this.excludedFromModule.get(virtualFile);
                if (module != null && (table = this.excludeFromContentRootTables.get(virtualFile)) != null && RootInfo.isExcludedByPattern(virtualFile, hierarchy, table)) {
                    excludedFrom = module;
                }
                if (module != null && (excludedFrom != module || underExcludedSourceRoot && sourceRootOwners.contains(module))) {
                    return virtualFile;
                }
                if (excludedFrom != null || this.excludedFromProject.contains(virtualFile) || this.contentRootOfUnloaded.containsKey(virtualFile)) {
                    if (sourceRootOwners == null) {
                        return null;
                    }
                    underExcludedSourceRoot = true;
                }
                if (underExcludedSourceRoot || !this.sourceRootOf.containsKey((Object)virtualFile) || (modulesForSourceRoot = this.sourceRootOf.get((Object)virtualFile)).isEmpty()) continue;
                sourceRootOwners = sourceRootOwners == null ? modulesForSourceRoot : ContainerUtil.union((Collection)sourceRootOwners, (Collection)modulesForSourceRoot);
            }
            return null;
        }

        private static boolean isExcludedByPattern(@NotNull VirtualFile contentRoot, @NotNull List<? extends VirtualFile> hierarchy, @NotNull FileTypeAssocTable<Boolean> table) {
            for (VirtualFile virtualFile : hierarchy) {
                if (table.findAssociatedFileType(virtualFile.getNameSequence()) != null) {
                    return true;
                }
                if (!virtualFile.equals(contentRoot)) continue;
                break;
            }
            return false;
        }

        @Nullable
        private VirtualFile findNearestContentRootForExcluded(@NotNull List<? extends VirtualFile> hierarchy) {
            for (VirtualFile virtualFile : hierarchy) {
                if (!this.contentRootOf.containsKey(virtualFile) && !this.contentRootOfUnloaded.containsKey(virtualFile)) continue;
                return virtualFile;
            }
            return null;
        }

        @Nullable
        private Pair<VirtualFile, List<Condition<? super VirtualFile>>> findLibraryRootInfo(@NotNull List<? extends VirtualFile> hierarchy, boolean source) {
            HashSet<Object> librariesToIgnore = new HashSet<Object>();
            for (VirtualFile virtualFile : hierarchy) {
                List<Condition<? super VirtualFile>> found;
                librariesToIgnore.addAll(this.excludedFromLibraries.get((Object)virtualFile));
                if (!(source && this.libraryOrSdkSources.contains(virtualFile) ? (found = RootInfo.findInLibraryProducers(virtualFile, this.sourceOfLibraries, librariesToIgnore)) != null : !source && this.libraryOrSdkClasses.contains(virtualFile) && (found = RootInfo.findInLibraryProducers(virtualFile, this.classOfLibraries, librariesToIgnore)) != null)) continue;
                return Pair.create((Object)virtualFile, found);
            }
            return null;
        }

        private static List<Condition<? super VirtualFile>> findInLibraryProducers(@NotNull VirtualFile root, @NotNull MultiMap<VirtualFile, Object> libraryRoots, @NotNull Set<Object> librariesToIgnore) {
            if (!libraryRoots.containsKey((Object)root)) {
                return Collections.emptyList();
            }
            Collection producers = libraryRoots.get((Object)root);
            HashSet libraries = new HashSet(producers.size());
            SmartList exclusions = new SmartList();
            for (Object library : producers) {
                Condition<VirtualFile> exclusion;
                if (librariesToIgnore.contains(library)) continue;
                if (library instanceof SyntheticLibrary && (exclusion = ((SyntheticLibrary)library).getExcludeFileCondition()) != null) {
                    exclusions.add(exclusion);
                    if (exclusion.value((Object)root)) continue;
                }
                libraries.add(library);
            }
            if (!libraries.isEmpty()) {
                return exclusions;
            }
            return null;
        }

        private String calcPackagePrefix(@NotNull VirtualFile root, VirtualFile packageRoot) {
            String prefix = this.packagePrefix.get(packageRoot);
            if (prefix != null && !root.equals(packageRoot)) {
                assert (packageRoot != null);
                String relative = VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)packageRoot, (char)'.');
                prefix = StringUtil.isEmpty((String)prefix) ? relative : prefix + '.' + relative;
            }
            return prefix;
        }

        @Nullable
        private VirtualFile findPackageRootInfo(@NotNull List<? extends VirtualFile> hierarchy, VirtualFile moduleContentRoot, VirtualFile libraryClassRoot, VirtualFile librarySourceRoot) {
            for (VirtualFile virtualFile : hierarchy) {
                if (moduleContentRoot != null && this.sourceRootOf.get((Object)virtualFile).contains(this.contentRootOf.get(moduleContentRoot)) && librarySourceRoot == null) {
                    return virtualFile;
                }
                if (virtualFile.equals(libraryClassRoot) || virtualFile.equals(librarySourceRoot)) {
                    return virtualFile;
                }
                if (!virtualFile.equals(moduleContentRoot) || this.sourceRootOf.containsKey((Object)virtualFile) || librarySourceRoot != null || libraryClassRoot != null) continue;
                return null;
            }
            return null;
        }

        @NotNull
        private Set<OrderEntry> getLibraryOrderEntries(@NotNull List<? extends VirtualFile> hierarchy, @Nullable VirtualFile libraryClassRoot, @Nullable VirtualFile librarySourceRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libSourceRootEntries) {
            LinkedHashSet<OrderEntry> orderEntries = new LinkedHashSet<OrderEntry>();
            for (VirtualFile virtualFile : hierarchy) {
                if (virtualFile.equals(libraryClassRoot) && !this.sourceRootOf.containsKey((Object)virtualFile)) {
                    orderEntries.addAll(libClassRootEntries.get((Object)virtualFile));
                }
                if (virtualFile.equals(librarySourceRoot) && libraryClassRoot == null) {
                    orderEntries.addAll(libSourceRootEntries.get((Object)virtualFile));
                }
                if (!libClassRootEntries.containsKey((Object)virtualFile) && (!this.sourceRootOf.containsKey((Object)virtualFile) || librarySourceRoot != null)) continue;
                break;
            }
            return orderEntries;
        }

        @Nullable
        private ModuleSourceOrderEntry getModuleSourceEntry(@NotNull List<? extends VirtualFile> hierarchy, @NotNull VirtualFile moduleContentRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries) {
            Module module = this.contentRootOf.get(moduleContentRoot);
            for (VirtualFile virtualFile : hierarchy) {
                if (this.sourceRootOf.get((Object)virtualFile).contains(module)) {
                    return (ModuleSourceOrderEntry)ContainerUtil.findInstance((Object[])ModuleRootManager.getInstance((Module)module).getOrderEntries(), ModuleSourceOrderEntry.class);
                }
                if (!libClassRootEntries.containsKey((Object)virtualFile)) continue;
                return null;
            }
            return null;
        }
    }

    private static class OrderEntryGraph {
        private final Project myProject;
        private final RootInfo myRootInfo;
        private final Set<VirtualFile> myAllRoots;
        private final Graph myGraph;
        private final MultiMap<VirtualFile, Node> myRoots;
        private final SynchronizedSLRUCache<VirtualFile, List<OrderEntry>> myCache;
        private final SynchronizedSLRUCache<Module, Set<String>> myDependentUnloadedModulesCache;
        private final MultiMap<VirtualFile, OrderEntry> myLibClassRootEntries;
        private final MultiMap<VirtualFile, OrderEntry> myLibSourceRootEntries;

        OrderEntryGraph(@NotNull Project project, @NotNull RootInfo rootInfo) {
            this.myProject = project;
            this.myRootInfo = rootInfo;
            this.myAllRoots = this.myRootInfo.getAllRoots();
            int cacheSize = Math.max(25, this.myAllRoots.size() / 100 * 2);
            this.myCache = new SynchronizedSLRUCache<VirtualFile, List<OrderEntry>>(cacheSize, cacheSize){

                @Override
                @NotNull
                public List<OrderEntry> createValue(@NotNull VirtualFile key) {
                    return this.collectOrderEntries(key);
                }
            };
            int dependentUnloadedModulesCacheSize = ModuleManager.getInstance((Project)project).getModules().length / 2;
            this.myDependentUnloadedModulesCache = new SynchronizedSLRUCache<Module, Set<String>>(dependentUnloadedModulesCacheSize, dependentUnloadedModulesCacheSize){

                @Override
                @NotNull
                public Set<String> createValue(@NotNull Module key) {
                    return this.collectDependentUnloadedModules(key);
                }
            };
            Pair<Graph, MultiMap<VirtualFile, Node>> pair = this.initGraphRoots();
            this.myGraph = (Graph)pair.getFirst();
            this.myRoots = (MultiMap)pair.getSecond();
            Pair<MultiMap<VirtualFile, OrderEntry>, MultiMap<VirtualFile, OrderEntry>> lpair = this.initLibraryClassSourceRoots();
            this.myLibClassRootEntries = (MultiMap)lpair.getFirst();
            this.myLibSourceRootEntries = (MultiMap)lpair.getSecond();
        }

        @NotNull
        private Pair<Graph, MultiMap<VirtualFile, Node>> initGraphRoots() {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            Module[] modules2 = moduleManager.getModules();
            Graph graph2 = new Graph(modules2.length);
            MultiMap roots = new MultiMap();
            for (Module module : modules2) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                List<OrderEnumerationHandler> handlers = OrderEnumeratorBase.getCustomHandlers(module);
                for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                    ModuleOrderEntry moduleOrderEntry;
                    Module depModule;
                    if (!(orderEntry instanceof ModuleOrderEntry) || (depModule = (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                    Node node = (Node)graph2.myNodes.get(depModule);
                    OrderEnumerator en = OrderEnumerator.orderEntries((Module)depModule).exportedOnly();
                    if (node == null) {
                        VirtualFile[] importedSourceRoots;
                        VirtualFile[] importedClassRoots;
                        node = new Node(depModule);
                        graph2.myNodes.put(depModule, node);
                        for (VirtualFile importedClassRoot : importedClassRoots = en.classes().usingCache().getRoots()) {
                            roots.putValue((Object)importedClassRoot, (Object)node);
                        }
                        for (VirtualFile sourceRoot : importedSourceRoots = en.sources().usingCache().getRoots()) {
                            roots.putValue((Object)sourceRoot, (Object)node);
                        }
                    }
                    boolean shouldRecurse = en.recursively().shouldRecurse(moduleOrderEntry, handlers);
                    node.myEdges.add(new Edge(module, moduleOrderEntry, shouldRecurse));
                }
            }
            for (UnloadedModuleDescription description : moduleManager.getUnloadedModuleDescriptions()) {
                for (String depName : description.getDependencyModuleNames()) {
                    Module depModule = moduleManager.findModuleByName(depName);
                    if (depModule == null) continue;
                    Node node = (Node)graph2.myNodes.get(depModule);
                    if (node == null) {
                        node = new Node(depModule);
                        graph2.myNodes.put(depModule, node);
                    }
                    if (node.myUnloadedDependentModules == null) {
                        node.myUnloadedDependentModules = new LinkedHashSet();
                    }
                    node.myUnloadedDependentModules.add(description.getName());
                }
            }
            return Pair.create((Object)graph2, (Object)roots);
        }

        @NotNull
        private Pair<MultiMap<VirtualFile, OrderEntry>, MultiMap<VirtualFile, OrderEntry>> initLibraryClassSourceRoots() {
            MultiMap libClassRootEntries = new MultiMap();
            MultiMap libSourceRootEntries = new MultiMap();
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                    if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                    LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                    for (VirtualFile sourceRoot : entry.getRootFiles(OrderRootType.SOURCES)) {
                        libSourceRootEntries.putValue((Object)sourceRoot, (Object)orderEntry);
                    }
                    for (VirtualFile classRoot : entry.getRootFiles(OrderRootType.CLASSES)) {
                        libClassRootEntries.putValue((Object)classRoot, (Object)orderEntry);
                    }
                }
            }
            return Pair.create((Object)libClassRootEntries, (Object)libSourceRootEntries);
        }

        @NotNull
        private List<OrderEntry> getOrderEntries(@NotNull VirtualFile file2) {
            return this.myCache.get(file2);
        }

        @NotNull
        private List<OrderEntry> collectOrderEntries(@NotNull VirtualFile file2) {
            List roots = RootIndex.getHierarchy(file2, this.myAllRoots, this.myRootInfo);
            if (roots == null) {
                return Collections.emptyList();
            }
            Stack stack = new Stack(roots.size());
            for (VirtualFile root : roots) {
                Collection nodes = this.myRoots.get((Object)root);
                for (Node node : nodes) {
                    stack.push((Object)node);
                }
            }
            HashSet<Node> seen = new HashSet<Node>(stack.size());
            ArrayList<Object> result2 = new ArrayList<Object>(stack.size());
            while (!stack.isEmpty()) {
                Node node = (Node)stack.pop();
                if (!seen.add(node)) continue;
                for (Edge edge : node.myEdges) {
                    Node targetNode;
                    result2.add(edge.myOrderEntry);
                    if (!edge.myRecursive || (targetNode = (Node)this.myGraph.myNodes.get(edge.myKey)) == null) continue;
                    stack.push((Object)targetNode);
                }
            }
            Pair libraryClassRootInfo = this.myRootInfo.findLibraryRootInfo(roots, false);
            Pair librarySourceRootInfo = this.myRootInfo.findLibraryRootInfo(roots, true);
            result2.addAll(this.myRootInfo.getLibraryOrderEntries(roots, (VirtualFile)Pair.getFirst((Pair)libraryClassRootInfo), (VirtualFile)Pair.getFirst((Pair)librarySourceRootInfo), (MultiMap<VirtualFile, OrderEntry>)this.myLibClassRootEntries, (MultiMap<VirtualFile, OrderEntry>)this.myLibSourceRootEntries));
            VirtualFile moduleContentRoot = this.myRootInfo.findNearestContentRoot(roots);
            if (moduleContentRoot != null) {
                ContainerUtil.addIfNotNull(result2, (Object)this.myRootInfo.getModuleSourceEntry(roots, moduleContentRoot, (MultiMap<VirtualFile, OrderEntry>)this.myLibClassRootEntries));
            }
            result2.sort(BY_OWNER_MODULE);
            return ContainerUtil.immutableList(result2);
        }

        @NotNull
        Set<String> getDependentUnloadedModules(@NotNull Module module) {
            return this.myDependentUnloadedModulesCache.get(module);
        }

        @NotNull
        private Set<String> collectDependentUnloadedModules(@NotNull Module module) {
            Node start2 = (Node)this.myGraph.myNodes.get(module);
            if (start2 == null) {
                return Collections.emptySet();
            }
            ArrayDeque<Node> stack = new ArrayDeque<Node>();
            stack.push(start2);
            HashSet<Node> seen = new HashSet<Node>();
            Set<String> result2 = null;
            while (!stack.isEmpty()) {
                Node node = (Node)stack.pop();
                if (!seen.add(node)) continue;
                if (node.myUnloadedDependentModules != null) {
                    if (result2 == null) {
                        result2 = new LinkedHashSet<String>(node.myUnloadedDependentModules);
                    } else {
                        result2.addAll(node.myUnloadedDependentModules);
                    }
                }
                for (Edge edge : node.myEdges) {
                    Node targetNode;
                    if (!edge.myRecursive || (targetNode = (Node)this.myGraph.myNodes.get(edge.myKey)) == null) continue;
                    stack.push(targetNode);
                }
            }
            return result2 != null ? result2 : Collections.emptySet();
        }

        private static class Graph {
            private final Map<Module, Node> myNodes;

            Graph(int moduleCount) {
                this.myNodes = new HashMap<Module, Node>(moduleCount);
            }
        }

        private static class Node {
            private final Module myKey;
            private final List<Edge> myEdges = new ArrayList<Edge>();
            private Set<String> myUnloadedDependentModules;

            private Node(@NotNull Module key) {
                this.myKey = key;
            }

            public String toString() {
                return this.myKey.toString();
            }
        }

        private static class Edge {
            private final Module myKey;
            private final ModuleOrderEntry myOrderEntry;
            private final boolean myRecursive;

            Edge(@NotNull Module key, @NotNull ModuleOrderEntry orderEntry, boolean recursive) {
                this.myKey = key;
                this.myOrderEntry = orderEntry;
                this.myRecursive = recursive;
            }

            public String toString() {
                return this.myOrderEntry.toString();
            }
        }
    }
}

