/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.ProjectFileScanner;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.ui.GuiUtils;
import com.intellij.util.MathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PushedFilePropertiesUpdaterImpl
extends PushedFilePropertiesUpdater {
    private static final Logger LOG = Logger.getInstance(PushedFilePropertiesUpdater.class);
    private final Project myProject;
    private final Queue<Runnable> myTasks = new ConcurrentLinkedQueue<Runnable>();

    public PushedFilePropertiesUpdaterImpl(final @NotNull Project project) {
        this.myProject = project;
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(new Throwable("Processing roots changed event (caused by file type change: " + event.isCausedByFileTypesChange() + ")"));
                }
                for (FilePropertyPusher pusher : FilePropertyPusher.EP_NAME.getExtensionList()) {
                    pusher.afterRootsChanged(project);
                }
            }
        });
        FilePropertyPusher.EP_NAME.addExtensionPointListener(new ExtensionPointListener<FilePropertyPusher<?>>(){

            public void extensionAdded(@NotNull FilePropertyPusher<?> pusher, @NotNull PluginDescriptor pluginDescriptor) {
                PushedFilePropertiesUpdaterImpl.this.queueFullUpdate();
            }
        }, (Disposable)project);
    }

    private void queueFullUpdate() {
        this.myTasks.clear();
        this.queueTasks(Arrays.asList(this::initializeProperties, () -> this.doPushAll(FilePropertyPusher.EP_NAME.getExtensionList(), ProjectFileScanner.EP_NAME.getExtensionList())));
    }

    @ApiStatus.Internal
    public void processAfterVfsChanges(@NotNull List<? extends VFileEvent> events) {
        boolean pushingSomethingSynchronously;
        ArrayList syncTasks = new ArrayList();
        ArrayList delayedTasks = new ArrayList();
        List filePushers = PushedFilePropertiesUpdaterImpl.getFilePushers();
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2;
            if (vFileEvent instanceof VFileCreateEvent) {
                List pushers;
                boolean isDirectory = ((VFileCreateEvent)vFileEvent).isDirectory();
                List list2 = pushers = isDirectory ? FilePropertyPusher.EP_NAME.getExtensionList() : filePushers;
                if (!vFileEvent.isFromRefresh()) {
                    ContainerUtil.addIfNotNull(syncTasks, (Object)this.createRecursivePushTask(vFileEvent, pushers));
                    continue;
                }
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(((VFileCreateEvent)vFileEvent).getChildName());
                boolean isProjectOrWorkspaceFile = fileType instanceof InternalFileType || VfsUtilCore.findContainingDirectory((VirtualFile)((VFileCreateEvent)vFileEvent).getParent(), (CharSequence)".idea") != null;
                if (isProjectOrWorkspaceFile) continue;
                ContainerUtil.addIfNotNull(delayedTasks, (Object)this.createRecursivePushTask(vFileEvent, pushers));
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileCopyEvent) || (file2 = PushedFilePropertiesUpdaterImpl.getFile(vFileEvent)) == null) continue;
            boolean isDirectory = file2.isDirectory();
            List pushers = isDirectory ? FilePropertyPusher.EP_NAME.getExtensionList() : filePushers;
            for (FilePropertyPusher pusher : pushers) {
                file2.putUserData(pusher.getFileDataKey(), null);
            }
            ContainerUtil.addIfNotNull(syncTasks, (Object)this.createRecursivePushTask(vFileEvent, pushers));
        }
        boolean bl = pushingSomethingSynchronously = !syncTasks.isEmpty() && syncTasks.size() < FileBasedIndexProjectHandler.ourMinFilesToStartDumMode;
        if (pushingSomethingSynchronously) {
            syncTasks.forEach(Runnable::run);
        } else {
            delayedTasks.addAll(syncTasks);
        }
        if (!delayedTasks.isEmpty()) {
            this.queueTasks(delayedTasks);
        }
        if (pushingSomethingSynchronously) {
            GuiUtils.invokeLaterIfNeeded(() -> this.scheduleDumbModeReindexingIfNeeded(), (ModalityState)ModalityState.defaultModalityState());
        }
    }

    private static VirtualFile getFile(@NotNull VFileEvent event) {
        VirtualFile file2 = event.getFile();
        if (event instanceof VFileCopyEvent) {
            file2 = ((VFileCopyEvent)event).getNewParent().findChild(((VFileCopyEvent)event).getNewChildName());
        }
        return file2;
    }

    public void runConcurrentlyIfPossible(List<Runnable> tasks) {
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
    }

    public void initializeProperties() {
        FilePropertyPusher.EP_NAME.forEachExtensionSafe(pusher -> pusher.initExtra(this.myProject));
    }

    public void pushAllPropertiesNow() {
        this.performPushTasks();
        this.doPushAll(FilePropertyPusher.EP_NAME.getExtensionList(), ProjectFileScanner.EP_NAME.getExtensionList());
    }

    @Nullable
    private Runnable createRecursivePushTask(@NotNull VFileEvent event, @NotNull List<? extends FilePropertyPusher<?>> pushers) {
        List scanners = ProjectFileScanner.EP_NAME.getExtensionList();
        if (pushers.isEmpty() && scanners.isEmpty()) {
            return null;
        }
        return () -> {
            VirtualFile dir = PushedFilePropertiesUpdaterImpl.getFile(event);
            ProjectFileIndex fileIndex = (ProjectFileIndex)ReadAction.compute(() -> ProjectFileIndex.getInstance((Project)this.myProject));
            if (dir != null && ((Boolean)ReadAction.compute(() -> fileIndex.isInContent(dir))).booleanValue() && !ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)dir)) {
                this.doPushRecursively(dir, pushers, scanners, fileIndex);
            }
        };
    }

    private void doPushRecursively(@NotNull VirtualFile dir, @NotNull List<? extends FilePropertyPusher<?>> pushers, @NotNull List<ProjectFileScanner> scanners, @NotNull ProjectFileIndex fileIndex) {
        List sessions = ContainerUtil.map(scanners, visitor -> visitor.startSession(this.myProject, dir));
        fileIndex.iterateContentUnderDirectory(dir, fileOrDir -> {
            this.applyPushersToFile(fileOrDir, pushers, null);
            PushedFilePropertiesUpdaterImpl.applyScannersToFile(fileOrDir, sessions);
            return true;
        });
    }

    private static void applyScannersToFile(@NotNull VirtualFile fileOrDir, @NotNull List<ProjectFileScanner.ScanSession> sessions) {
        for (ProjectFileScanner.ScanSession session2 : sessions) {
            try {
                session2.visitFile(fileOrDir);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Failed to visit file", (Throwable)e, new Attachment[]{new Attachment("filePath.txt", fileOrDir.getPath())});
            }
        }
    }

    private void queueTasks(@NotNull List<? extends Runnable> actions) {
        actions.forEach(this.myTasks::offer);
        final DumbModeTask task2 = new DumbModeTask((Object)this){

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                indicator.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
                PushedFilePropertiesUpdaterImpl.this.performPushTasks();
            }
        };
        this.myProject.getMessageBus().connect((Disposable)task2).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                DumbService.getInstance((Project)PushedFilePropertiesUpdaterImpl.this.myProject).cancelTask(task2);
            }
        });
        FilePropertyPusher.EP_NAME.addChangeListener(() -> {
            DumbService.getInstance((Project)this.myProject).cancelTask(task2);
            this.queueFullUpdate();
        }, (Disposable)task2);
        DumbService.getInstance((Project)this.myProject).queueTask(task2);
    }

    private void performPushTasks() {
        Runnable task2;
        boolean hadTasks = false;
        while ((task2 = this.myTasks.poll()) != null) {
            try {
                task2.run();
                hadTasks = true;
            }
            catch (ProcessCanceledException e) {
                this.queueTasks(Collections.singletonList(task2));
                throw e;
            }
        }
        if (hadTasks) {
            this.scheduleDumbModeReindexingIfNeeded();
        }
    }

    private void scheduleDumbModeReindexingIfNeeded() {
        if (this.myProject.isDisposed()) {
            return;
        }
        DumbModeTask task2 = FileBasedIndexProjectHandler.createChangedFilesIndexingTask(this.myProject);
        if (task2 != null) {
            DumbService.getInstance((Project)this.myProject).queueTask(task2);
        }
    }

    public void filePropertiesChanged(@NotNull VirtualFile fileOrDir, @NotNull Condition<? super VirtualFile> acceptFileCondition) {
        if (fileOrDir.isDirectory()) {
            for (VirtualFile child2 : fileOrDir.getChildren()) {
                if (child2.isDirectory() || !acceptFileCondition.value((Object)child2)) continue;
                this.filePropertiesChanged(child2);
            }
        } else if (acceptFileCondition.value((Object)fileOrDir)) {
            this.filePropertiesChanged(fileOrDir);
        }
    }

    private static <T> T findNewPusherValue(Project project, VirtualFile fileOrDir, FilePropertyPusher<? extends T> pusher, T moduleValue) {
        Object immediateValue = pusher.getImmediateValue(project, fileOrDir);
        if (immediateValue != null) {
            return (T)immediateValue;
        }
        if (moduleValue != null) {
            return moduleValue;
        }
        return PushedFilePropertiesUpdaterImpl.findNewPusherValueFromParent(project, fileOrDir, pusher);
    }

    private static <T> T findNewPusherValueFromParent(Project project, VirtualFile fileOrDir, FilePropertyPusher<? extends T> pusher) {
        VirtualFile parent = fileOrDir.getParent();
        if (parent != null && ProjectFileIndex.getInstance((Project)project).isInContent(parent)) {
            Object userValue = parent.getUserData(pusher.getFileDataKey());
            if (userValue != null) {
                return (T)userValue;
            }
            return PushedFilePropertiesUpdaterImpl.findNewPusherValue(project, parent, pusher, null);
        }
        Object projectValue = pusher.getImmediateValue(project, null);
        return (T)(projectValue != null ? projectValue : pusher.getDefaultValue());
    }

    public void pushAll(FilePropertyPusher<?> ... pushers) {
        this.queueTasks(Collections.singletonList(() -> this.doPushAll(Arrays.asList(pushers), ProjectFileScanner.EP_NAME.getExtensionList())));
    }

    private void doPushAll(@NotNull List<? extends FilePropertyPusher<?>> pushers, @NotNull List<ProjectFileScanner> scanners) {
        List sessions = ContainerUtil.map(scanners, visitor -> visitor.startSession(this.myProject, null));
        PushedFilePropertiesUpdaterImpl.scanProject(this.myProject, module -> {
            Object[] moduleValues = new Object[pushers.size()];
            for (int i2 = 0; i2 < moduleValues.length; ++i2) {
                moduleValues[i2] = ((FilePropertyPusher)pushers.get(i2)).getImmediateValue(module);
            }
            return fileOrDir -> {
                this.applyPushersToFile(fileOrDir, pushers, moduleValues);
                PushedFilePropertiesUpdaterImpl.applyScannersToFile(fileOrDir, sessions);
                return ContentIteratorEx.Status.CONTINUE;
            };
        });
    }

    public static void scanProject(@NotNull Project project, @NotNull Function<Module, ContentIteratorEx> iteratorProducer) {
        Object[] modules2 = (Module[])ReadAction.compute(() -> ModuleManager.getInstance((Project)project).getModules());
        List tasks = ContainerUtil.mapNotNull((Object[])modules2, module -> (Runnable)ReadAction.compute(() -> {
            if (module.isDisposed()) {
                return null;
            }
            ProgressManager.checkCanceled();
            ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
            ContentIteratorEx iterator2 = (ContentIteratorEx)iteratorProducer.apply((Module)module);
            return () -> fileIndex.iterateContent((ContentIterator)iterator2);
        }));
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
    }

    public static void invokeConcurrentlyIfPossible(@NotNull List<? extends Runnable> tasks) {
        Runnable runnable2;
        if (tasks.isEmpty()) {
            return;
        }
        if (tasks.size() == 1 || ApplicationManager.getApplication().isWriteAccessAllowed()) {
            for (Runnable runnable3 : tasks) {
                runnable3.run();
            }
            return;
        }
        ProgressIndicator progress2 = ProgressManager.getInstance().getProgressIndicator();
        ConcurrentLinkedQueue<? extends Runnable> concurrentLinkedQueue = new ConcurrentLinkedQueue<Runnable>(tasks);
        ArrayList<Future> results = new ArrayList<Future>();
        if (tasks.size() > 1) {
            int numThreads = MathUtil.clamp((int)(tasks.size() - 1), (int)1, (int)(UnindexedFilesUpdater.getNumberOfIndexingThreads() - 1));
            for (int i2 = 0; i2 < numThreads; ++i2) {
                results.add(ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> {
                    Runnable runnable2;
                    while ((runnable2 = (Runnable)tasksQueue.poll()) != null) {
                        runnable2.run();
                    }
                }, (ProgressIndicator)ProgressWrapper.wrap(progress2))));
            }
        }
        while ((runnable2 = concurrentLinkedQueue.poll()) != null) {
            runnable2.run();
        }
        for (Future result2 : results) {
            try {
                result2.get();
            }
            catch (InterruptedException ex) {
                throw new ProcessCanceledException((Throwable)ex);
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
    }

    private void applyPushersToFile(VirtualFile fileOrDir, @NotNull List<? extends FilePropertyPusher<?>> pushers, Object[] moduleValues) {
        if (pushers.isEmpty()) {
            return;
        }
        if (fileOrDir.isDirectory()) {
            fileOrDir.getChildren();
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            ProgressManager.checkCanceled();
            if (!fileOrDir.isValid()) {
                return;
            }
            this.doApplyPushersToFile(fileOrDir, pushers, moduleValues);
        });
    }

    private void doApplyPushersToFile(@NotNull VirtualFile fileOrDir, @NotNull List<? extends FilePropertyPusher<?>> pushers, Object @Nullable [] moduleValues) {
        boolean isDir = fileOrDir.isDirectory();
        for (int i2 = 0; i2 < pushers.size(); ++i2) {
            FilePropertyPusher<?> pusher = pushers.get(i2);
            if (!isDir ? pusher.pushDirectoriesOnly() || !pusher.acceptsFile(fileOrDir, this.myProject) : !pusher.acceptsDirectory(fileOrDir, this.myProject)) continue;
            Object value2 = moduleValues != null ? moduleValues[i2] : null;
            this.findAndUpdateValue(fileOrDir, pusher, value2);
        }
    }

    public <T> void findAndUpdateValue(@NotNull VirtualFile fileOrDir, @NotNull FilePropertyPusher<T> pusher, @Nullable T moduleValue) {
        Object oldValue;
        T newValue2 = PushedFilePropertiesUpdaterImpl.findNewPusherValue(this.myProject, fileOrDir, pusher, moduleValue);
        if (newValue2 != (oldValue = fileOrDir.getUserData(pusher.getFileDataKey()))) {
            fileOrDir.putUserData(pusher.getFileDataKey(), newValue2);
            try {
                pusher.persistAttribute(this.myProject, fileOrDir, newValue2);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void filePropertiesChanged(@NotNull VirtualFile file2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (fileBasedIndex instanceof FileBasedIndexImpl) {
            ((FileBasedIndexImpl)fileBasedIndex).requestReindex(file2, false);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            PushedFilePropertiesUpdaterImpl.reloadPsi(file2, project);
        }
    }

    private static void reloadPsi(VirtualFile file2, Project project) {
        FileManagerImpl fileManager = (FileManagerImpl)PsiManagerEx.getInstanceEx(project).getFileManager();
        if (fileManager.findCachedViewProvider(file2) != null) {
            GuiUtils.invokeLaterIfNeeded(() -> WriteAction.run(() -> fileManager.forceReload(file2)), (ModalityState)ModalityState.defaultModalityState(), (Condition)project.getDisposed());
        }
    }

    private static List<FilePropertyPusher<?>> getFilePushers() {
        return ContainerUtil.findAll((Collection)FilePropertyPusher.EP_NAME.getExtensionList(), pusher -> !pusher.pushDirectoriesOnly());
    }
}

