/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ModuleLibraryTableBase
implements LibraryTable,
LibraryTable.ModifiableModel {
    public static final LibraryTablePresentation MODULE_LIBRARY_TABLE_PRESENTATION = new LibraryTablePresentation(){

        @NotNull
        public String getDisplayName(boolean plural) {
            return ProjectModelBundle.message((String)"module.library.display.name", (Object[])new Object[]{plural ? 2 : 1});
        }

        @NotNull
        public String getDescription() {
            return ProjectModelBundle.message((String)"libraries.node.text.module", (Object[])new Object[0]);
        }

        @NotNull
        public String getLibraryTableEditorTitle() {
            return ProjectModelBundle.message((String)"library.configure.module.title", (Object[])new Object[0]);
        }
    };

    public Library @NotNull [] getLibraries() {
        ArrayList result2 = new ArrayList();
        Iterator libraryIterator = this.getLibraryIterator();
        ContainerUtil.addAll(result2, (Iterator)libraryIterator);
        return result2.toArray(Library.EMPTY_ARRAY);
    }

    @NotNull
    public Library createLibrary() {
        return this.createLibrary(null);
    }

    @NotNull
    public Library createLibrary(String name) {
        return this.createLibrary(name, null);
    }

    @NotNull
    public Library createLibrary(String name, @Nullable PersistentLibraryKind<?> type) {
        return this.createLibrary(name, type, null);
    }

    @NotNull
    public String getTableLevel() {
        return "module";
    }

    @NotNull
    public LibraryTablePresentation getPresentation() {
        return MODULE_LIBRARY_TABLE_PRESENTATION;
    }

    @Nullable
    public Library getLibraryByName(@NotNull String name) {
        Iterator libraryIterator = this.getLibraryIterator();
        while (libraryIterator.hasNext()) {
            Library library = (Library)libraryIterator.next();
            if (!name.equals(library.getName())) continue;
            return library;
        }
        return null;
    }

    public void addListener(@NotNull LibraryTable.Listener listener2) {
        throw new UnsupportedOperationException();
    }

    public void addListener(@NotNull LibraryTable.Listener listener2, @NotNull Disposable parentDisposable) {
        throw new UnsupportedOperationException("Method addListener is not yet implemented in " + this.getClass().getName());
    }

    public void removeListener(@NotNull LibraryTable.Listener listener2) {
        throw new UnsupportedOperationException();
    }

    public void commit() {
    }

    public void dispose() {
    }

    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel() {
        return this;
    }
}

