/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.UnknownInvalidSdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkBalloonNotification;
import com.intellij.openapi.projectRoots.impl.UnknownSdkCollector;
import com.intellij.openapi.projectRoots.impl.UnknownSdkDownloader;
import com.intellij.openapi.projectRoots.impl.UnknownSdkEditorNotification;
import com.intellij.openapi.projectRoots.impl.UnknownSdkSnapshot;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkResolver;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Consumer;
import com.intellij.util.TripleFunction;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownSdkTracker {
    private static final Logger LOG = Logger.getInstance(UnknownSdkTracker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    private UnknownSdkSnapshot myPreviousRequestCache = null;

    @NotNull
    public static UnknownSdkTracker getInstance(@NotNull Project project) {
        return (UnknownSdkTracker)project.getService(UnknownSdkTracker.class);
    }

    public UnknownSdkTracker(@NotNull Project project) {
        this.myProject = project;
        this.myUpdateQueue = new MergingUpdateQueue(this.getClass().getSimpleName(), 700, true, null, (Disposable)this.myProject, null, false).usePassThroughInUnitTestMode();
    }

    @NotNull
    private Update newUpdateTask() {
        return new Update("update"){

            public void run() {
                if (!Registry.is((String)"unknown.sdk") || !UnknownSdkResolver.EP_NAME.hasAnyExtensions()) {
                    UnknownSdkTracker.this.showStatus(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
                    return;
                }
                new UnknownSdkCollector(UnknownSdkTracker.this.myProject).collectSdksPromise(snapshot -> {
                    if (snapshot.equals(UnknownSdkTracker.this.myPreviousRequestCache)) {
                        return;
                    }
                    UnknownSdkTracker.this.myPreviousRequestCache = snapshot;
                    UnknownSdkTracker.this.onFixableAndMissingSdksCollected(UnknownSdkTracker.filterOnlyAllowedEntries(snapshot.getResolvableSdks()), UnknownSdkTracker.filterOnlyAllowedSdkEntries(snapshot.getKnownSdks()));
                });
            }
        };
    }

    public void updateUnknownSdksNow() {
        this.myUpdateQueue.run(this.newUpdateTask());
    }

    public void updateUnknownSdks() {
        this.myUpdateQueue.queue(this.newUpdateTask());
    }

    private static boolean allowFixesFor(@NotNull SdkTypeId type) {
        return UnknownSdkResolver.EP_NAME.findFirstSafe(it -> it.supportsResolution(type)) != null;
    }

    @NotNull
    private static <E extends UnknownSdk> List<E> filterOnlyAllowedEntries(@NotNull List<? extends E> input) {
        ArrayList<UnknownSdk> copy2 = new ArrayList<UnknownSdk>();
        for (UnknownSdk item : input) {
            SdkType type = item.getSdkType();
            if (!UnknownSdkTracker.allowFixesFor((SdkTypeId)type)) continue;
            copy2.add(item);
        }
        return copy2;
    }

    @NotNull
    private static List<Sdk> filterOnlyAllowedSdkEntries(@NotNull List<Sdk> input) {
        ArrayList<Sdk> copy2 = new ArrayList<Sdk>();
        for (Sdk item : input) {
            SdkTypeId type = item.getSdkType();
            if (!UnknownSdkTracker.allowFixesFor(type)) continue;
            copy2.add(item);
        }
        return copy2;
    }

    private void onFixableAndMissingSdksCollected(final @NotNull List<UnknownSdk> fixable, final @NotNull List<Sdk> usedSdks) {
        if (fixable.isEmpty() && usedSdks.isEmpty()) {
            this.showStatus(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, ProjectBundle.message((String)"progress.title.resolving.sdks", (Object[])new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                List<UnknownInvalidSdk> invalidSdks = new ArrayList<UnknownInvalidSdk>();
                Map<UnknownSdk, UnknownSdkLocalSdkFix> localFixes = new HashMap<UnknownSdk, UnknownSdkLocalSdkFix>();
                Map<UnknownSdk, UnknownSdkDownloadableSdkFix> downloadFixes = new HashMap<UnknownSdk, UnknownSdkDownloadableSdkFix>();
                if (!usedSdks.isEmpty()) {
                    indicator.pushState();
                    indicator.setText(ProjectBundle.message((String)"progress.text.resolving.existing.sdks", (Object[])new Object[0]));
                    invalidSdks = UnknownInvalidSdk.resolveInvalidSdks(usedSdks);
                    fixable.addAll(invalidSdks);
                    indicator.popState();
                }
                if (!fixable.isEmpty()) {
                    indicator.pushState();
                    indicator.setText(ProjectBundle.message((String)"progress.text.resolving.missing.sdks", (Object[])new Object[0]));
                    List lookups = UnknownSdkTracker.this.collectSdkLookups(indicator);
                    if (!lookups.isEmpty()) {
                        indicator.setText(ProjectBundle.message((String)"progress.text.looking.for.local.sdks", (Object[])new Object[0]));
                        localFixes = UnknownSdkTracker.findFixesAndRemoveFixable(indicator, fixable, lookups, UnknownSdkResolver.UnknownSdkLookup::proposeLocalFix);
                        if (!fixable.isEmpty()) {
                            indicator.setText(ProjectBundle.message((String)"progress.text.looking.for.downloadable.sdks", (Object[])new Object[0]));
                            downloadFixes = UnknownSdkTracker.findFixesAndRemoveFixable(indicator, fixable, lookups, UnknownSdkResolver.UnknownSdkLookup::proposeDownload);
                        }
                    }
                    indicator.popState();
                }
                UnknownInvalidSdk.removeAndUpdate(invalidSdks, fixable, localFixes, downloadFixes);
                if (!localFixes.isEmpty()) {
                    indicator.pushState();
                    indicator.setText(ProjectBundle.message((String)"progress.text.configuring.sdks", (Object[])new Object[0]));
                    UnknownSdkTracker.this.configureLocalSdks(localFixes);
                    indicator.popState();
                }
                UnknownSdkTracker.this.showStatus(fixable, localFixes, downloadFixes, invalidSdks);
            }
        });
    }

    private void showStatus(@NotNull List<UnknownSdk> unknownSdksWithoutFix, @NotNull Map<UnknownSdk, UnknownSdkLocalSdkFix> localFixes, @NotNull Map<UnknownSdk, UnknownSdkDownloadableSdkFix> downloadFixes, @NotNull List<UnknownInvalidSdk> invalidSdks) {
        UnknownSdkBalloonNotification.getInstance(this.myProject).notifyFixedSdks(localFixes);
        UnknownSdkEditorNotification.getInstance(this.myProject).showNotifications(unknownSdksWithoutFix, downloadFixes, invalidSdks);
    }

    @NotNull
    private List<UnknownSdkResolver.UnknownSdkLookup> collectSdkLookups(@NotNull ProgressIndicator indicator) {
        ArrayList<UnknownSdkResolver.UnknownSdkLookup> lookups = new ArrayList<UnknownSdkResolver.UnknownSdkLookup>();
        UnknownSdkResolver.EP_NAME.forEachExtensionSafe(ext -> {
            UnknownSdkResolver.UnknownSdkLookup resolver = ext.createResolver(this.myProject, indicator);
            if (resolver != null) {
                lookups.add(resolver);
            }
        });
        return lookups;
    }

    public void applyDownloadableFix(@NotNull UnknownSdk info, @NotNull UnknownSdkDownloadableSdkFix fix) {
        UnknownSdkTracker.downloadFix(this.myProject, info, fix, (Consumer<? super Sdk>)((Consumer)sdk2 -> {}), (Consumer<? super Sdk>)((Consumer)sdk2 -> {
            if (sdk2 != null) {
                this.updateUnknownSdksNow();
            }
        }));
    }

    @ApiStatus.Internal
    public static void downloadFix(@Nullable Project project, @NotNull UnknownSdk info, @NotNull UnknownSdkDownloadableSdkFix fix, @NotNull Consumer<? super Sdk> onSdkNameReady, @NotNull Consumer<? super Sdk> onCompleted) {
        UnknownSdkDownloader.downloadFix(project, info, fix, task2 -> {
            String actualSdkName = info.getSdkName();
            if (actualSdkName == null) {
                actualSdkName = task2.getSuggestedSdkName();
            }
            return ProjectJdkTable.getInstance().createSdk(actualSdkName, (SdkTypeId)info.getSdkType());
        }, onSdkNameReady, (Consumer<? super Sdk>)((Consumer)sdk2 -> {
            if (sdk2 != null) {
                fix.configureSdk((Sdk)sdk2);
                UnknownSdkTracker.registerNewSdkInJdkTable(sdk2.getName(), sdk2);
            }
            onCompleted.consume(sdk2);
        }));
    }

    @NotNull
    public EditorNotificationPanel.ActionHandler createSdkSelectionPopup(@Nullable String sdkName, @Nullable SdkType sdkType) {
        return SdkPopupFactory.newBuilder().withProject(this.myProject).withSdkTypeFilter((Condition<SdkTypeId>)((Condition)type -> sdkType == null || Objects.equals(type, sdkType))).onSdkSelected(sdk2 -> {
            UnknownSdkTracker.registerNewSdkInJdkTable(sdkName, sdk2);
            this.updateUnknownSdks();
        }).buildEditorNotificationPanelHandler();
    }

    private void configureLocalSdks(@NotNull Map<UnknownSdk, UnknownSdkLocalSdkFix> localFixes) {
        if (localFixes.isEmpty()) {
            return;
        }
        for (Map.Entry<UnknownSdk, UnknownSdkLocalSdkFix> e : localFixes.entrySet()) {
            UnknownSdk info = e.getKey();
            UnknownSdkLocalSdkFix fix = e.getValue();
            UnknownSdkTracker.configureLocalSdk(info, fix, (Consumer<? super Sdk>)((Consumer)sdk2 -> {}));
        }
        this.updateUnknownSdks();
    }

    @ApiStatus.Internal
    public static void configureLocalSdk(@NotNull UnknownSdk info, @NotNull UnknownSdkLocalSdkFix fix, @NotNull Consumer<? super Sdk> onCompleted) {
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                String actualSdkName = info.getSdkName();
                if (actualSdkName == null) {
                    actualSdkName = fix.getSuggestedSdkName();
                }
                Sdk sdk2 = ProjectJdkTable.getInstance().createSdk(actualSdkName, (SdkTypeId)info.getSdkType());
                SdkModificator mod = sdk2.getSdkModificator();
                mod.setHomePath(FileUtil.toSystemIndependentName((String)fix.getExistingSdkHome()));
                mod.setVersionString(fix.getVersionString());
                mod.commitChanges();
                try {
                    info.getSdkType().setupSdkPaths(sdk2);
                }
                catch (Exception error) {
                    LOG.warn("Failed to setupPaths for " + sdk2 + ". " + error.getMessage(), (Throwable)error);
                }
                fix.configureSdk(sdk2);
                UnknownSdkTracker.registerNewSdkInJdkTable(actualSdkName, sdk2);
                LOG.info("Automatically set Sdk " + info + " to " + fix.getExistingSdkHome());
                onCompleted.consume((Object)sdk2);
            }
            catch (Exception error) {
                LOG.warn("Failed to configure " + info.getSdkType().getPresentableName() + "  for " + info + " for path " + fix + ". " + error.getMessage(), (Throwable)error);
                onCompleted.consume(null);
            }
        });
    }

    @NotNull
    private static <R> Map<UnknownSdk, R> findFixesAndRemoveFixable(@NotNull ProgressIndicator indicator, @NotNull List<UnknownSdk> infos, @NotNull List<UnknownSdkResolver.UnknownSdkLookup> lookups, @NotNull TripleFunction<UnknownSdkResolver.UnknownSdkLookup, UnknownSdk, ProgressIndicator, R> fun) {
        indicator.pushState();
        LinkedHashMap<UnknownSdk, Object> result2 = new LinkedHashMap<UnknownSdk, Object>();
        Iterator<UnknownSdk> iterator2 = infos.iterator();
        block0: while (iterator2.hasNext()) {
            UnknownSdk info = iterator2.next();
            for (UnknownSdkResolver.UnknownSdkLookup lookup2 : lookups) {
                indicator.pushState();
                Object fix = fun.fun((Object)lookup2, (Object)info, (Object)indicator);
                indicator.popState();
                if (fix == null) continue;
                result2.put(info, fix);
                iterator2.remove();
                continue block0;
            }
        }
        indicator.popState();
        return result2;
    }

    private static void registerNewSdkInJdkTable(@Nullable String sdkName, @NotNull Sdk sdk2) {
        WriteAction.run(() -> {
            ProjectJdkTable table = ProjectJdkTable.getInstance();
            if (sdkName != null) {
                Sdk clash = table.findJdk(sdkName);
                if (clash != null) {
                    LOG.warn("SDK with name " + sdkName + " already exists: clash=" + clash + ", new=" + sdk2);
                    return;
                }
                SdkModificator mod = sdk2.getSdkModificator();
                mod.setName(sdkName);
                mod.commitChanges();
            }
            table.addJdk(sdk2);
        });
    }
}

