/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.UnknownInvalidSdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkTracker;
import com.intellij.openapi.roots.ui.configuration.SdkListPresenter;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownSdkEditorNotification {
    public static final Key<List<EditorNotificationPanel>> NOTIFICATIONS = Key.create((String)"notifications added to the editor");
    private static final Key<?> EDITOR_NOTIFICATIONS_KEY = Key.create((String)"SdkSetupNotificationNew");
    private final Project myProject;
    private final FileEditorManager myFileEditorManager;
    private final AtomicReference<Set<SimpleSdkFixInfo>> myNotifications = new AtomicReference(new LinkedHashSet());

    @NotNull
    public static UnknownSdkEditorNotification getInstance(@NotNull Project project) {
        return (UnknownSdkEditorNotification)project.getService(UnknownSdkEditorNotification.class);
    }

    UnknownSdkEditorNotification(@NotNull Project project) {
        this.myProject = project;
        this.myFileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                for (FileEditor editor : UnknownSdkEditorNotification.this.myFileEditorManager.getEditors(file2)) {
                    UnknownSdkEditorNotification.this.updateEditorNotifications(editor);
                }
            }
        });
    }

    public boolean allowProjectSdkNotifications() {
        return this.myNotifications.get().isEmpty();
    }

    @NotNull
    public List<SimpleSdkFixInfo> getNotifications() {
        return ImmutableList.copyOf((Collection)this.myNotifications.get());
    }

    public void showNotifications(@NotNull List<UnknownSdk> unfixableSdks, @NotNull Map<UnknownSdk, UnknownSdkDownloadableSdkFix> files2, @NotNull List<UnknownInvalidSdk> invalidSdks) {
        ImmutableSet.Builder notifications = ImmutableSet.builder();
        if (Registry.is((String)"unknown.sdk.show.editor.actions")) {
            for (UnknownSdk unknownSdk2 : unfixableSdks) {
                @Nullable String name = unknownSdk2.getSdkName();
                SdkType type = unknownSdk2.getSdkType();
                if (name == null) continue;
                notifications.add((Object)new UnknownSdkFixInfo(name, type, null, null));
            }
            for (Map.Entry entry : files2.entrySet()) {
                UnknownSdk unknownSdk2 = (UnknownSdk)entry.getKey();
                String name = unknownSdk2.getSdkName();
                if (name == null) continue;
                UnknownSdkDownloadableSdkFix fix = (UnknownSdkDownloadableSdkFix)entry.getValue();
                notifications.add((Object)new UnknownSdkFixInfo(name, unknownSdk2.getSdkType(), unknownSdk2, fix));
            }
            for (UnknownInvalidSdk unknownInvalidSdk : invalidSdks) {
                notifications.add((Object)new InvalidSdkFixInfo(unknownInvalidSdk));
            }
        }
        this.myNotifications.set((Set<SimpleSdkFixInfo>)notifications.build());
        EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
        ApplicationManager.getApplication().invokeLater(() -> {
            for (FileEditor editor : this.myFileEditorManager.getAllEditors()) {
                this.updateEditorNotifications(editor);
            }
        });
    }

    private void updateEditorNotifications(@NotNull FileEditor editor) {
        if (!editor.isValid()) {
            return;
        }
        List notifications = (List)editor.getUserData(NOTIFICATIONS);
        if (notifications != null) {
            for (JComponent component2 : notifications) {
                this.myFileEditorManager.removeTopComponent(editor, component2);
            }
            notifications.clear();
        } else {
            notifications = new SmartList();
            editor.putUserData(NOTIFICATIONS, (Object)notifications);
        }
        for (SimpleSdkFixInfo info : this.myNotifications.get()) {
            EditorNotificationPanel notification;
            VirtualFile file2 = editor.getFile();
            if (file2 == null || (notification = info.createNotificationPanel(file2, this.myProject)) == null) continue;
            notifications.add(notification);
            this.myFileEditorManager.addTopComponent(editor, (JComponent)notification);
        }
    }

    private class InvalidSdkFixInfo
    extends SimpleSdkFixInfo {
        @NotNull
        private final String mySdkName;
        @NotNull
        private final UnknownInvalidSdk mySdk;

        InvalidSdkFixInfo(UnknownInvalidSdk invalidSdk) {
            super(invalidSdk.mySdkType);
            this.mySdkName = invalidSdk.getSdkName();
            this.mySdk = invalidSdk;
        }

        @Override
        @NotNull
        final EditorNotificationPanel createNotificationPanelImpl(@NotNull VirtualFile file2, @NotNull Project project) {
            String sdkTypeName = this.mySdkType.getPresentableName();
            String notificationText = ProjectBundle.message((String)"config.invalid.sdk.notification.text", (Object[])new Object[]{sdkTypeName, this.mySdkName});
            String configureText = ProjectBundle.message((String)"config.invalid.sdk.configure", (Object[])new Object[0]);
            UnknownSdkLocalSdkFix localFix2 = this.mySdk.myLocalSdkFix;
            UnknownSdkDownloadableSdkFix downloadFix2 = this.mySdk.myDownloadableSdkFix;
            String intentionActionText = ProjectBundle.message((String)"config.invalid.sdk.configure.missing", (Object[])new Object[]{sdkTypeName, this.mySdkName});
            String localText = "";
            String localTextTooltip = "";
            if (localFix2 != null) {
                localText = intentionActionText = ProjectBundle.message((String)"config.unknown.sdk.local", (Object[])new Object[]{sdkTypeName, localFix2.getPresentableVersionString()});
                localTextTooltip = SdkListPresenter.presentDetectedSdkPath(localFix2.getExistingSdkHome(), 90, 40);
            }
            String downloadText = downloadFix2 != null ? (intentionActionText = ProjectBundle.message((String)"config.unknown.sdk.download", (Object[])new Object[]{downloadFix2.getDownloadDescription()})) : "";
            EditorNotificationPanel notification = this.newNotificationPanel(intentionActionText);
            notification.setProject(UnknownSdkEditorNotification.this.myProject);
            notification.setProviderKey(EDITOR_NOTIFICATIONS_KEY);
            notification.setText(notificationText);
            if (localFix2 != null) {
                HyperlinkLabel actionLabel = notification.createActionLabel(localText, () -> this.mySdk.applyLocalFix(project), true);
                actionLabel.setToolTipText(localTextTooltip);
            } else if (downloadFix2 != null) {
                notification.createActionLabel(downloadText, () -> this.mySdk.applyDownloadFix(UnknownSdkEditorNotification.this.myProject), true);
            }
            notification.createActionLabel(configureText, this.mySdk.createSdkSelectionPopup(project), true);
            return notification;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("InvalidSdkFixInfo { name: ").append(this.mySdkName);
            if (this.mySdk.myLocalSdkFix != null) {
                sb.append(", fix: ").append(this.mySdk.myLocalSdkFix.getExistingSdkHome());
            }
            if (this.mySdk.myDownloadableSdkFix != null) {
                sb.append(", fix: ").append(this.mySdk.myDownloadableSdkFix.getDownloadDescription());
            }
            sb.append("}");
            return sb.toString();
        }
    }

    private class UnknownSdkFixInfo
    extends SimpleSdkFixInfo {
        @NotNull
        private final String mySdkName;
        @Nullable
        private final UnknownSdk mySdk;
        @Nullable
        private final UnknownSdkDownloadableSdkFix myFix;

        UnknownSdkFixInfo(@NotNull String sdkName, @Nullable SdkType sdkType, @Nullable UnknownSdk sdk2, UnknownSdkDownloadableSdkFix fix) {
            super(sdkType);
            this.mySdkName = sdkName;
            this.mySdk = sdk2;
            this.myFix = fix;
        }

        @Override
        @NotNull
        final EditorNotificationPanel createNotificationPanelImpl(@NotNull VirtualFile file2, @NotNull Project project) {
            String sdkTypeName = this.mySdkType.getPresentableName();
            String notificationText = ProjectBundle.message((String)"config.unknown.sdk.notification.text", (Object[])new Object[]{sdkTypeName, this.mySdkName});
            String configureText = ProjectBundle.message((String)"config.unknown.sdk.configure", (Object[])new Object[0]);
            boolean hasDownload = this.myFix != null && this.mySdk != null;
            String downloadText = hasDownload ? ProjectBundle.message((String)"config.unknown.sdk.download", (Object[])new Object[]{this.myFix.getDownloadDescription()}) : "";
            String intentionActionText = hasDownload ? downloadText : ProjectBundle.message((String)"config.unknown.sdk.configure.missing", (Object[])new Object[]{sdkTypeName, this.mySdkName});
            EditorNotificationPanel notification = this.newNotificationPanel(intentionActionText);
            notification.setProject(UnknownSdkEditorNotification.this.myProject);
            notification.setProviderKey(EDITOR_NOTIFICATIONS_KEY);
            notification.setText(notificationText);
            if (hasDownload) {
                AtomicBoolean isRunning = new AtomicBoolean(false);
                notification.createActionLabel(downloadText, () -> {
                    if (isRunning.compareAndSet(false, true)) {
                        UnknownSdkTracker.getInstance(UnknownSdkEditorNotification.this.myProject).applyDownloadableFix(this.mySdk, this.myFix);
                    }
                }, true);
            }
            notification.createActionLabel(configureText, UnknownSdkTracker.getInstance(UnknownSdkEditorNotification.this.myProject).createSdkSelectionPopup(this.mySdkName, this.mySdkType), true);
            return notification;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SdkFixInfo { name: ").append(this.mySdkName);
            if (this.myFix != null) {
                sb.append(", fix: ").append(this.myFix.getDownloadDescription());
            }
            sb.append("}");
            return sb.toString();
        }
    }

    public static abstract class SimpleSdkFixInfo {
        @NotNull
        protected final SdkType mySdkType;

        protected SimpleSdkFixInfo(@NotNull SdkType sdkType) {
            this.mySdkType = sdkType;
        }

        @Nullable
        final EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull Project project) {
            if (!this.mySdkType.isRelevantForFile(project, file2)) {
                return null;
            }
            return this.createNotificationPanelImpl(file2, project);
        }

        @NotNull
        abstract EditorNotificationPanel createNotificationPanelImpl(@NotNull VirtualFile var1, @NotNull Project var2);

        @NotNull
        protected EditorNotificationPanel newNotificationPanel(final @NotNull String intentionActionText) {
            return new EditorNotificationPanel(){

                protected String getIntentionActionText() {
                    return intentionActionText;
                }

                @NotNull
                protected PriorityAction.Priority getIntentionActionPriority() {
                    return PriorityAction.Priority.HIGH;
                }

                @NotNull
                protected String getIntentionActionFamilyName() {
                    return ProjectBundle.message((String)"config.unknown.sdk.configuration", (Object[])new Object[0]);
                }
            };
        }
    }
}

