/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.MissingSdkInfo;
import com.intellij.openapi.projectRoots.impl.UnknownSdkCollectorKt;
import com.intellij.openapi.projectRoots.impl.UnknownSdkContributor;
import com.intellij.openapi.projectRoots.impl.UnknownSdkSnapshot;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\b\u0010\r\u001a\u00020\fH\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/projectRoots/impl/UnknownSdkCollector;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "collectSdksPromise", "", "onCompleted", "Ljava/util/function/Consumer;", "Lcom/intellij/openapi/projectRoots/impl/UnknownSdkSnapshot;", "collectSdksUnderReadAction", "intellij.platform.lang.impl"})
public final class UnknownSdkCollector {
    private final Logger LOG;
    private final Project myProject;

    public final void collectSdksPromise(@NotNull Consumer<UnknownSdkSnapshot> onCompleted) {
        ReadAction.nonBlocking((Callable)new Callable<UnknownSdkSnapshot>(this){
            final /* synthetic */ UnknownSdkCollector this$0;

            public final UnknownSdkSnapshot call() {
                return UnknownSdkCollector.access$collectSdksUnderReadAction(this.this$0);
            }
            {
                this.this$0 = unknownSdkCollector;
            }
        }).expireWith((Disposable)this.myProject).coalesceBy(new Object[]{this.myProject, Reflection.getOrCreateKotlinClass(UnknownSdkCollector.class)}).finishOnUiThread(ApplicationManager.getApplication().getNoneModalityState(), onCompleted).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    /*
     * WARNING - void declaration
     */
    private final UnknownSdkSnapshot collectSdksUnderReadAction() {
        void $this$mapNotNullTo$iv$iv;
        Sdk moduleJdk;
        Object moduleRootManager;
        Object sdkName;
        boolean bl = false;
        Set knownSdks = new LinkedHashSet();
        SetMultimap sdkToTypes = MultimapBuilder.treeKeys((Comparator)String.CASE_INSENSITIVE_ORDER).hashSetValues().build();
        ProgressManager.checkCanceled();
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)this.myProject);
        Sdk projectSdk = rootManager.getProjectSdk();
        if (projectSdk == null) {
            sdkName = rootManager.getProjectSdkName();
            String sdkTypeName = rootManager.getProjectSdkTypeName();
            if (sdkName != null) {
                sdkToTypes.put(sdkName, (Object)sdkTypeName);
            }
        } else {
            sdkName = knownSdks;
            boolean sdkTypeName = false;
            sdkName.add(projectSdk);
        }
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleJdkOrderEntry jdkEntry;
            void $this$filterIsInstanceTo$iv$iv;
            ProgressManager.checkCanceled();
            moduleRootManager = ModuleRootManager.getInstance((Module)module);
            if (moduleRootManager.getExternalSource() != null) continue;
            OrderEntry[] $this$filterIsInstance$iv = moduleRootManager.getOrderEntries();
            boolean $i$f$filterIsInstance = false;
            OrderEntry[] orderEntryArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ModuleJdkOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            if ((ModuleJdkOrderEntry)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)) == null) {
                continue;
            }
            moduleJdk = jdkEntry.getJdk();
            if (moduleJdk == null) {
                String jdkName = jdkEntry.getJdkName();
                String jdkTypeName = jdkEntry.getJdkTypeName();
                if (jdkName == null) continue;
                sdkToTypes.put((Object)jdkName, (Object)jdkTypeName);
                continue;
            }
            Collection jdkName = knownSdks;
            boolean jdkTypeName = false;
            jdkName.add(moduleJdk);
        }
        TreeSet<void> totallyUnknownSdks = new TreeSet<void>(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        boolean bl2 = false;
        List resolvableSdks = new ArrayList();
        moduleRootManager = sdkToTypes.asMap();
        boolean jdkEntry = false;
        Iterator iterator2 = moduleRootManager.entrySet().iterator();
        while (iterator2.hasNext()) {
            void sdkName2;
            Sdk sdk2;
            moduleJdk = sdk2 = iterator2.next();
            boolean jdkName = false;
            moduleRootManager = (String)moduleJdk.getKey();
            moduleJdk = sdk2;
            jdkName = false;
            Collection sdkTypes = (Collection)moduleJdk.getValue();
            String singleSdkTypeName = (String)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)CollectionsKt.filterNotNull((Iterable)sdkTypes)));
            if (singleSdkTypeName == null) {
                totallyUnknownSdks.add(sdkName2);
                continue;
            }
            SdkType sdkType = SdkType.findByName((String)singleSdkTypeName);
            if (sdkType == null) continue;
            resolvableSdks.add(new MissingSdkInfo((String)sdkName2, sdkType));
        }
        Iterable $this$mapNotNull$iv = resolvableSdks;
        boolean $i$f$mapNotNull = false;
        Iterable sdkTypes = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl3 = false;
            UnknownSdk it = (UnknownSdk)element$iv$iv;
            boolean bl4 = false;
            if (it.getSdkName() == null) continue;
            boolean bl5 = false;
            boolean bl6 = false;
            String it$iv$iv = string;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set detectedUnknownSdkNames = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        UnknownSdkCollectorKt.access$getEP_NAME$p().forEachExtensionSafe((Consumer)new Consumer<UnknownSdkContributor>(this, detectedUnknownSdkNames, resolvableSdks, knownSdks){
            final /* synthetic */ UnknownSdkCollector this$0;
            final /* synthetic */ Set $detectedUnknownSdkNames;
            final /* synthetic */ List $resolvableSdks;
            final /* synthetic */ Set $knownSdks;

            public final void accept(UnknownSdkContributor it) {
                boolean bl;
                List list2;
                try {
                    list2 = it.contributeUnknownSdks(UnknownSdkCollector.access$getMyProject$p(this.this$0));
                }
                catch (ProcessCanceledException e) {
                    throw (Throwable)e;
                }
                catch (Throwable t) {
                    UnknownSdkCollector.access$getLOG$p(this.this$0).warn("Failed to contribute SDKs with " + it.getClass().getName() + ". " + t.getMessage(), t);
                    bl = false;
                    list2 = CollectionsKt.emptyList();
                }
                List contrib = list2;
                for (Object unknownSdk2 : contrib) {
                    String name;
                    if (unknownSdk2.getSdkName() == null) {
                        continue;
                    }
                    if (!this.$detectedUnknownSdkNames.add(name)) continue;
                    Collection collection = this.$resolvableSdks;
                    boolean bl2 = false;
                    collection.add(unknownSdk2);
                }
                try {
                    Object unknownSdk2;
                    unknownSdk2 = this.$knownSdks;
                    Iterable iterable = it.contributeKnownSdks(UnknownSdkCollector.access$getMyProject$p(this.this$0));
                    bl = false;
                    CollectionsKt.addAll((Collection)unknownSdk2, (Iterable)iterable);
                }
                catch (ProcessCanceledException e) {
                    throw (Throwable)e;
                }
                catch (Throwable t) {
                    UnknownSdkCollector.access$getLOG$p(this.this$0).warn("Failed to contribute SDKs with " + it.getClass().getName() + ". " + t.getMessage(), t);
                }
            }
            {
                this.this$0 = unknownSdkCollector;
                this.$detectedUnknownSdkNames = set;
                this.$resolvableSdks = list2;
                this.$knownSdks = set2;
            }
        });
        Iterable $this$sortedBy$iv = CollectionsKt.toList((Iterable)knownSdks);
        boolean $i$f$sortedBy = false;
        boolean bl8 = false;
        return new UnknownSdkSnapshot((Set<String>)totallyUnknownSdks, resolvableSdks, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Sdk it = (Sdk)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Sdk)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        }));
    }

    public UnknownSdkCollector(@NotNull Project myProject) {
        this.myProject = myProject;
        boolean $i$f$logger = false;
        this.LOG = Logger.getInstance(UnknownSdkCollector.class);
    }

    public static final /* synthetic */ UnknownSdkSnapshot access$collectSdksUnderReadAction(UnknownSdkCollector $this) {
        return $this.collectSdksUnderReadAction();
    }

    public static final /* synthetic */ Project access$getMyProject$p(UnknownSdkCollector $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ Logger access$getLOG$p(UnknownSdkCollector $this) {
        return $this.LOG;
    }
}

