/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderBasic;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaHomeFinderMac
extends JavaHomeFinderBasic {
    public static final String JAVA_HOME_FIND_UTIL = "/usr/libexec/java_home";
    static String defaultJavaLocation = "/Library/Java/JavaVirtualMachines";

    JavaHomeFinderMac(boolean forceEmbeddedJava) {
        super(forceEmbeddedJava, defaultJavaLocation, "/System/Library/Java/JavaVirtualMachines", FileUtil.expandUserHome((String)"~/Library/Java/JavaVirtualMachines"));
        this.registerFinder(() -> this.scanAll(JavaHomeFinderMac.getSystemDefaultJavaHome(), false));
    }

    @Nullable
    private static File getSystemDefaultJavaHome() {
        String homePath = null;
        if (SystemInfo.isMacOSLeopard) {
            if (new File(JAVA_HOME_FIND_UTIL).canExecute()) {
                homePath = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{JAVA_HOME_FIND_UTIL}));
            }
        } else {
            homePath = "/Library/Java/Home";
        }
        if (homePath != null) {
            return new File(homePath);
        }
        return null;
    }

    @Override
    @NotNull
    protected List<File> listPossibleJdkHomesFromInstallRoot(@NotNull File file2) {
        return Arrays.asList(file2, new File(file2, "/Home"), new File(file2, "Contents/Home"));
    }

    @Override
    @NotNull
    protected List<File> listPossibleJdkInstallRootsFromHomes(@NotNull File file2) {
        File parentFile;
        ArrayList<File> result2 = new ArrayList<File>();
        result2.add(file2);
        if (file2.getName().equalsIgnoreCase("Home") && (parentFile = file2.getParentFile()) != null) {
            File parentParentFile;
            result2.add(parentFile);
            if (parentFile.getName().equalsIgnoreCase("Contents") && (parentParentFile = parentFile.getParentFile()) != null) {
                result2.add(parentParentFile);
            }
        }
        return result2;
    }
}

