/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class ExcludeRootsCache {
    private volatile CachedUrls myCache;

    ExcludeRootsCache(@NotNull MessageBusConnection connection) {
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                ExcludeRootsCache.this.myCache = null;
            }

            public void projectClosed(@NotNull Project project) {
                ExcludeRootsCache.this.myCache = null;
            }
        });
    }

    @NotNull
    final List<String> getExcludedUrls() {
        return (List)ReadAction.compute(() -> {
            Object[] urls;
            CachedUrls cache = this.myCache;
            long actualModCount = Arrays.stream(ProjectManager.getInstance().getOpenProjects()).map(ProjectRootManager::getInstance).mapToLong(SimpleModificationTracker::getModificationCount).sum();
            if (cache != null && actualModCount == cache.myModificationCount) {
                urls = cache.myUrls;
            } else {
                HashSet excludedUrls = new HashSet();
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                        Collections.addAll(excludedUrls, ModuleRootManager.getInstance((Module)module).getExcludeRootUrls());
                    }
                }
                urls = ArrayUtilRt.toStringArray(excludedUrls);
                Arrays.sort(urls);
                this.myCache = new CachedUrls(actualModCount, (String[])urls);
            }
            return Arrays.asList(urls);
        });
    }

    private static final class CachedUrls {
        private final long myModificationCount;
        private final String @NotNull [] myUrls;

        private CachedUrls(long count, String @NotNull [] urls) {
            this.myModificationCount = count;
            this.myUrls = urls;
        }
    }
}

