/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class DumbUtilImpl
implements DumbUtil {
    private final Project myProject;

    public DumbUtilImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @Contract(pure=true)
    @NotNull
    public <T> List<T> filterByDumbAwarenessHonoringIgnoring(@NotNull Collection<? extends T> collection) {
        if (!this.mayUseIndices()) {
            return DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(collection);
        }
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<T>(collection);
    }

    public boolean mayUseIndices() {
        return !DumbService.getInstance((Project)this.myProject).isDumb() || FileBasedIndex.getInstance().getCurrentDumbModeAccessType() != null;
    }
}

