/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.internal.statistic.IdeActivity;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbServiceMergingTaskQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

final class DumbServiceGuiTaskQueue {
    private static final Logger LOG = Logger.getInstance(DumbServiceGuiTaskQueue.class);
    private final Project myProject;
    private final DumbServiceMergingTaskQueue myTaskQueue;

    DumbServiceGuiTaskQueue(@NotNull Project project, @NotNull DumbServiceMergingTaskQueue queue) {
        this.myProject = project;
        this.myTaskQueue = queue;
    }

    void processTasksWithProgress(@NotNull Consumer<ProgressIndicatorEx> bindProgress, @NotNull IdeActivity activity) {
        while (!this.myProject.isDisposed()) {
            DumbServiceMergingTaskQueue.QueuedDumbModeTask pair = this.myTaskQueue.extractNextTask();
            Throwable throwable = null;
            try {
                if (pair == null) break;
                bindProgress.accept(pair.getIndicator());
                pair.registerStageStarted(activity);
                AccessToken ignored = HeavyProcessLatch.INSTANCE.processStarted("Performing indexing tasks", HeavyProcessLatch.Type.Indexing);
                Throwable throwable2 = null;
                try {
                    DumbServiceGuiTaskQueue.runSingleTask(pair);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable2 != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (pair == null) continue;
                if (throwable != null) {
                    try {
                        pair.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                pair.close();
            }
        }
    }

    private static void runSingleTask(@NotNull DumbServiceMergingTaskQueue.QueuedDumbModeTask task2) {
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("Running dumb mode task: " + task2.getInfoString());
        }
        ProgressManager.getInstance().runProcess(() -> {
            try {
                task2.executeTask();
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable unexpected) {
                LOG.error("Failed to execute task " + task2 + ". " + unexpected.getMessage(), unexpected);
            }
        }, (ProgressIndicator)task2.getIndicator());
    }
}

