/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.concurrency.PlainEdtExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressManagerImpl
extends CoreProgressManager
implements Disposable {
    private static final Key<Boolean> SAFE_PROGRESS_INDICATOR = Key.create((String)"SAFE_PROGRESS_INDICATOR");
    private final Set<CoreProgressManager.CheckCanceledHook> myHooks = ContainerUtil.newConcurrentSet();
    private final CoreProgressManager.CheckCanceledHook mySleepHook = __ -> this.sleepIfNeededToGivePriorityToAnotherThread();

    public ProgressManagerImpl() {
        ExtensionPointImpl.setCheckCanceledAction(ProgressManager::checkCanceled);
    }

    @Override
    public boolean hasUnsafeProgressIndicator() {
        return super.hasUnsafeProgressIndicator() || ContainerUtil.exists(this.getCurrentIndicators(), ProgressManagerImpl::isUnsafeIndicator);
    }

    private static boolean isUnsafeIndicator(ProgressIndicator indicator) {
        return indicator instanceof ProgressIndicatorBase && ((ProgressIndicatorBase)indicator).getUserData(SAFE_PROGRESS_INDICATOR) == null;
    }

    public void markProgressSafe(@NotNull UserDataHolder progress2) {
        progress2.putUserData(SAFE_PROGRESS_INDICATOR, (Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process2, ProgressIndicator progress2) throws ProcessCanceledException {
        CoreProgressManager.CheckCanceledHook hook2;
        CoreProgressManager.CheckCanceledHook checkCanceledHook = hook2 = progress2 instanceof PingProgress && ApplicationManager.getApplication().isDispatchThread() ? p -> {
            ((PingProgress)progress2).interact();
            return true;
        } : null;
        if (hook2 != null) {
            this.addCheckCanceledHook(hook2);
        }
        try {
            super.executeProcessUnderProgress(process2, progress2);
        }
        finally {
            if (hook2 != null) {
                this.removeCheckCanceledHook(hook2);
            }
        }
    }

    public static void __testWhileAlwaysCheckingCanceled(@NotNull Runnable runnable2) {
        Thread fake = new Thread("fake");
        try {
            threadsUnderCanceledIndicator.add(fake);
            runnable2.run();
        }
        finally {
            threadsUnderCanceledIndicator.remove(fake);
        }
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Task task2, @Nullable JComponent parentComponent) {
        long start2 = System.currentTimeMillis();
        boolean result2 = super.runProcessWithProgressSynchronously(task2, parentComponent);
        if (result2) {
            JFrame frame;
            long end = System.currentTimeMillis();
            Task.NotificationInfo notificationInfo = task2.notifyFinished();
            long time = end - start2;
            if (notificationInfo != null && time > 5000L && (frame = WindowManager.getInstance().getFrame(task2.getProject())) != null && !frame.hasFocus()) {
                ProgressManagerImpl.systemNotify(notificationInfo);
            }
        }
        return result2;
    }

    private static void systemNotify(@NotNull Task.NotificationInfo info) {
        SystemNotifications.getInstance().notify(info.getNotificationName(), info.getNotificationTitle(), info.getNotificationText());
    }

    @Override
    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task2) {
        CompletableFuture<ProgressIndicator> progressIndicator2 = CompletableFuture.supplyAsync(() -> {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return new BackgroundableProcessIndicator(task2);
            }
            return ProgressManagerImpl.shouldRunHeadlessTasksSynchronously() ? new ProgressIndicatorBase() : new EmptyProgressIndicator();
        }, (Executor)PlainEdtExecutor.INSTANCE);
        return this.runProcessWithProgressAsync(task2, progressIndicator2, null, null, null);
    }

    @Override
    void notifyTaskFinished(@NotNull Task.Backgroundable task2, long elapsed) {
        Window window;
        Task.NotificationInfo notificationInfo = task2.notifyFinished();
        if (notificationInfo != null && elapsed > 5000L && ((window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null || notificationInfo.isShowWhenFocused())) {
            ProgressManagerImpl.systemNotify(notificationInfo);
        }
    }

    @Override
    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action2, @Nullable ProgressIndicator indicator) {
        return ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action2, indicator);
    }

    void addCheckCanceledHook(@NotNull CoreProgressManager.CheckCanceledHook hook2) {
        if (this.myHooks.add(hook2)) {
            this.updateShouldCheckCanceled();
        }
    }

    void removeCheckCanceledHook(@NotNull CoreProgressManager.CheckCanceledHook hook2) {
        if (this.myHooks.remove(hook2)) {
            this.updateShouldCheckCanceled();
        }
    }

    @Override
    @Nullable
    protected CoreProgressManager.CheckCanceledHook createCheckCanceledHook() {
        if (this.myHooks.isEmpty()) {
            return null;
        }
        CoreProgressManager.CheckCanceledHook[] activeHooks = this.myHooks.toArray(new CoreProgressManager.CheckCanceledHook[0]);
        return activeHooks.length == 1 ? activeHooks[0] : indicator -> {
            boolean result2 = false;
            for (CoreProgressManager.CheckCanceledHook hook2 : activeHooks) {
                if (!hook2.runHook(indicator)) continue;
                result2 = true;
            }
            return result2;
        };
    }

    @Override
    protected void prioritizingStarted() {
        this.addCheckCanceledHook(this.mySleepHook);
    }

    @Override
    protected void prioritizingFinished() {
        this.removeCheckCanceledHook(this.mySleepHook);
    }
}

