/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CancellationCheck;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.util.Clock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u001f\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0005\u00a2\u0006\u0002\u0010\u001aR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/progress/impl/CancellationCheck;", "", "thresholdMs", "", "(J)V", "Lkotlin/Function0;", "checkEnabled", "", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getCheckEnabled", "()Lkotlin/jvm/functions/Function0;", "hook", "Lcom/intellij/openapi/progress/impl/CoreProgressManager$CheckCanceledHook;", "statusRecord", "Ljava/lang/ThreadLocal;", "Lcom/intellij/openapi/progress/impl/CancellationCheck$CanceledStatusRecord;", "kotlin.jvm.PlatformType", "getThresholdMs", "checkCancellationDiff", "", "record", "enableCancellationTimer", "enabled", "withCancellationCheck", "T", "block", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "CanceledStatusRecord", "Companion", "intellij.platform.ide.impl"})
public final class CancellationCheck {
    private final ThreadLocal<CanceledStatusRecord> statusRecord;
    private final CoreProgressManager.CheckCanceledHook hook;
    @NotNull
    private final Function0<Long> thresholdMs;
    @NotNull
    private final Function0<Boolean> checkEnabled;
    private static final Logger LOG;
    private static final CancellationCheck INSTANCE;
    public static final Companion Companion;

    private final void checkCancellationDiff(CanceledStatusRecord record) {
        if (record.getEnabled()) {
            long now = Clock.getTime();
            long diff = now - record.getTimestamp();
            if (diff > ((Number)this.thresholdMs.invoke()).longValue()) {
                LOG.error(Thread.currentThread().getName() + " last checkCanceled was " + diff + " ms ago");
            }
            record.setTimestamp(now);
        }
    }

    private final void enableCancellationTimer(CanceledStatusRecord record, boolean enabled) {
        ProgressManager progressManager = ProgressManager.getInstance();
        if (progressManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.progress.impl.ProgressManagerImpl");
        }
        ProgressManagerImpl progressManagerImpl = (ProgressManagerImpl)progressManager;
        if (enabled) {
            progressManagerImpl.addCheckCanceledHook(this.hook);
        } else {
            progressManagerImpl.removeCheckCanceledHook(this.hook);
        }
        record.setEnabled(enabled);
        record.setTimestamp(Clock.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withCancellationCheck(@NotNull Function0<? extends T> block) {
        if (!((Boolean)this.checkEnabled.invoke()).booleanValue()) {
            return (T)block.invoke();
        }
        CanceledStatusRecord record = this.statusRecord.get();
        if (record.getEnabled()) {
            return (T)block.invoke();
        }
        this.enableCancellationTimer(record, true);
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            try {
                this.checkCancellationDiff(record);
            }
            finally {
                this.enableCancellationTimer(record, false);
            }
        }
    }

    @NotNull
    public final Function0<Long> getThresholdMs() {
        return this.thresholdMs;
    }

    @NotNull
    public final Function0<Boolean> getCheckEnabled() {
        return this.checkEnabled;
    }

    private CancellationCheck(Function0<Long> thresholdMs, Function0<Boolean> checkEnabled) {
        this.thresholdMs = thresholdMs;
        this.checkEnabled = checkEnabled;
        this.statusRecord = ThreadLocal.withInitial(statusRecord.1.INSTANCE);
        this.hook = new CoreProgressManager.CheckCanceledHook(this){
            final /* synthetic */ CancellationCheck this$0;

            public final boolean runHook(@Nullable ProgressIndicator it) {
                CancellationCheck.access$checkCancellationDiff(this.this$0, (CanceledStatusRecord)CancellationCheck.access$getStatusRecord$p(this.this$0).get());
                return false;
            }
            {
                this.this$0 = cancellationCheck;
            }
        };
    }

    public CancellationCheck(final long thresholdMs) {
        this((Function0<Long>)((Function0)new Function0<Long>(){

            public final long invoke() {
                return thresholdMs;
            }
        }), (Function0<Boolean>)((Function0)2.INSTANCE));
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(CancellationCheck.class);
        INSTANCE = new CancellationCheck((Function0<Long>)((Function0)Companion.INSTANCE.1.INSTANCE), (Function0<Boolean>)((Function0)Companion.INSTANCE.2.INSTANCE));
    }

    public static final /* synthetic */ void access$checkCancellationDiff(CancellationCheck $this, CanceledStatusRecord record) {
        $this.checkCancellationDiff(record);
    }

    public static final /* synthetic */ ThreadLocal access$getStatusRecord$p(CancellationCheck $this) {
        return $this.statusRecord;
    }

    @JvmStatic
    public static final <T> T runWithCancellationCheck(@NotNull Function0<? extends T> block) {
        return Companion.runWithCancellationCheck(block);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/progress/impl/CancellationCheck$CanceledStatusRecord;", "", "enabled", "", "timestamp", "", "(ZJ)V", "getEnabled", "()Z", "setEnabled", "(Z)V", "getTimestamp", "()J", "setTimestamp", "(J)V", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    private static final class CanceledStatusRecord {
        private boolean enabled;
        private long timestamp;

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(long l) {
            this.timestamp = l;
        }

        public CanceledStatusRecord(boolean enabled, long timestamp) {
            this.enabled = enabled;
            this.timestamp = timestamp;
        }

        public /* synthetic */ CanceledStatusRecord(boolean bl, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                l = Clock.getTime();
            }
            this(bl, l);
        }

        public CanceledStatusRecord() {
            this(false, 0L, 3, null);
        }

        public final boolean component1() {
            return this.enabled;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final CanceledStatusRecord copy(boolean enabled, long timestamp) {
            return new CanceledStatusRecord(enabled, timestamp);
        }

        public static /* synthetic */ CanceledStatusRecord copy$default(CanceledStatusRecord canceledStatusRecord, boolean bl, long l, int n, Object object) {
            if ((n & 1) != 0) {
                bl = canceledStatusRecord.enabled;
            }
            if ((n & 2) != 0) {
                l = canceledStatusRecord.timestamp;
            }
            return canceledStatusRecord.copy(bl, l);
        }

        @NotNull
        public String toString() {
            return "CanceledStatusRecord(enabled=" + this.enabled + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int n = this.enabled ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n * 31 + Long.hashCode(this.timestamp);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CanceledStatusRecord)) break block3;
                    CanceledStatusRecord canceledStatusRecord = (CanceledStatusRecord)object;
                    if (this.enabled != canceledStatusRecord.enabled || this.timestamp != canceledStatusRecord.timestamp) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\fH\u0007\u00a2\u0006\u0002\u0010\rR\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/progress/impl/CancellationCheck$Companion;", "", "()V", "INSTANCE", "Lcom/intellij/openapi/progress/impl/CancellationCheck;", "getINSTANCE$annotations", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "runWithCancellationCheck", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void getINSTANCE$annotations() {
        }

        @JvmStatic
        public final <T> T runWithCancellationCheck(@NotNull Function0<? extends T> block) {
            return INSTANCE.withCancellationCheck(block);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

