/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.paths.StaticPathReferenceProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathReferenceManagerImpl
extends PathReferenceManager {
    private final StaticPathReferenceProvider myStaticProvider = new StaticPathReferenceProvider(null);
    private final PathReferenceProvider myGlobalPathsProvider = new GlobalPathReferenceProvider();
    private static final Comparator<PsiReference> START_OFFSET_COMPARATOR = Comparator.comparingInt(o -> o.getRangeInElement().getStartOffset());

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element2, PathReferenceProvider ... additionalProviders) {
        PathReference pathReference;
        for (PathReferenceProvider provider : PathReferenceManagerImpl.getProviders()) {
            pathReference = provider.getPathReference(path, element2);
            if (pathReference == null) continue;
            return pathReference;
        }
        for (PathReferenceProvider provider : additionalProviders) {
            pathReference = provider.getPathReference(path, element2);
            if (pathReference == null) continue;
            return pathReference;
        }
        pathReference = this.myStaticProvider.getPathReference(path, element2);
        if (pathReference != null) {
            return pathReference;
        }
        return null;
    }

    @Nullable
    public PathReference getCustomPathReference(@NotNull String path, @NotNull Module module, @NotNull PsiElement element2, PathReferenceProvider ... providers) {
        for (PathReferenceProvider provider : providers) {
            PathReference reference2 = provider.getPathReference(path, element2);
            if (reference2 == null) continue;
            return reference2;
        }
        return null;
    }

    @NotNull
    public PathReferenceProvider getGlobalWebPathReferenceProvider() {
        return this.myGlobalPathsProvider;
    }

    @NotNull
    public PathReferenceProvider createStaticPathReferenceProvider(boolean relativePathsAllowed) {
        StaticPathReferenceProvider provider = new StaticPathReferenceProvider(null);
        provider.setRelativePathsAllowed(relativePathsAllowed);
        return provider;
    }

    public PsiReference @NotNull [] createReferences(@NotNull PsiElement psiElement, boolean soft, boolean endingSlashNotAllowed, boolean relativePathsAllowed, PathReferenceProvider ... additionalProviders) {
        return this.createReferences(psiElement, soft, endingSlashNotAllowed, relativePathsAllowed, (FileType[])null, additionalProviders);
    }

    public PsiReference @NotNull [] createReferences(@NotNull PsiElement psiElement, boolean soft, boolean endingSlashNotAllowed, boolean relativePathsAllowed, FileType[] suitableFileTypes, PathReferenceProvider ... additionalProviders) {
        ArrayList<PsiReference> mergedReferences = new ArrayList<PsiReference>();
        PathReferenceManagerImpl.processProvider(psiElement, this.myGlobalPathsProvider, mergedReferences, soft);
        StaticPathReferenceProvider staticProvider = new StaticPathReferenceProvider(suitableFileTypes);
        staticProvider.setEndingSlashNotAllowed(endingSlashNotAllowed);
        staticProvider.setRelativePathsAllowed(relativePathsAllowed);
        PathReferenceManagerImpl.processProvider(psiElement, staticProvider, mergedReferences, soft);
        for (PathReferenceProvider provider : PathReferenceManagerImpl.getProviders()) {
            PathReferenceManagerImpl.processProvider(psiElement, provider, mergedReferences, soft);
        }
        for (PathReferenceProvider provider : additionalProviders) {
            PathReferenceManagerImpl.processProvider(psiElement, provider, mergedReferences, soft);
        }
        for (PathReferenceProvider provider : ANCHOR_REFERENCE_PROVIDER_EP.getExtensionList()) {
            PathReferenceManagerImpl.processProvider(psiElement, provider, mergedReferences, soft);
        }
        return PathReferenceManagerImpl.mergeReferences(psiElement, mergedReferences);
    }

    public PsiReference @NotNull [] createCustomReferences(@NotNull PsiElement psiElement, boolean soft, PathReferenceProvider ... providers) {
        PathReferenceProvider provider;
        boolean processed2;
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        PathReferenceProvider[] pathReferenceProviderArray = providers;
        int n = pathReferenceProviderArray.length;
        for (int j = 0; j < n && !(processed2 = PathReferenceManagerImpl.processProvider(psiElement, provider = pathReferenceProviderArray[j], references, soft)); ++j) {
        }
        return PathReferenceManagerImpl.mergeReferences(psiElement, references);
    }

    public PsiReference @NotNull [] createReferences(@NotNull PsiElement psiElement, boolean soft, PathReferenceProvider ... additionalProviders) {
        return this.createReferences(psiElement, soft, false, true, (FileType[])null, additionalProviders);
    }

    private static PsiReference[] mergeReferences(PsiElement element2, List<? extends PsiReference> references) {
        if (references.size() <= 1) {
            return references.toArray(PsiReference.EMPTY_ARRAY);
        }
        references.sort(START_OFFSET_COMPARATOR);
        ArrayList<PsiReference> intersecting = new ArrayList<PsiReference>();
        ArrayList<PsiReference> notIntersecting = new ArrayList<PsiReference>();
        TextRange intersectingRange = references.get(0).getRangeInElement();
        boolean intersected = false;
        for (int i2 = 1; i2 < references.size(); ++i2) {
            PsiReference reference2 = references.get(i2);
            TextRange range2 = reference2.getRangeInElement();
            int offset = range2.getStartOffset();
            if (intersectingRange.getStartOffset() <= offset && intersectingRange.getEndOffset() >= offset) {
                intersected = true;
                intersecting.add(references.get(i2 - 1));
                if (i2 == references.size() - 1) {
                    intersecting.add(reference2);
                }
                intersectingRange = intersectingRange.union(range2);
                continue;
            }
            if (intersected) {
                intersecting.add(references.get(i2 - 1));
                intersected = false;
            } else {
                notIntersecting.add(references.get(i2 - 1));
            }
            intersectingRange = range2;
            if (i2 != references.size() - 1) continue;
            notIntersecting.add(reference2);
        }
        List<PsiReference> result2 = PathReferenceManagerImpl.doMerge(element2, intersecting);
        result2.addAll(notIntersecting);
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    private static List<PsiReference> doMerge(PsiElement element2, List<? extends PsiReference> references) {
        TextRange range2;
        SmartList list2;
        ArrayList<PsiReference> resolvingRefs = new ArrayList<PsiReference>();
        ArrayList<PsiReference> nonResolvingRefs = new ArrayList<PsiReference>();
        for (int i2 = 0; i2 < references.size(); ++i2) {
            PsiReference reference2 = references.get(i2);
            assert (element2.equals(reference2.getElement()));
            if (reference2.resolve() != null) {
                resolvingRefs.add(reference2);
                continue;
            }
            nonResolvingRefs.add(reference2);
        }
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>(5);
        while (!resolvingRefs.isEmpty()) {
            list2 = new ArrayList(5);
            range2 = PathReferenceManagerImpl.getFirstIntersectingReferences(resolvingRefs, (List<? super PsiReference>)list2);
            TextRange textRange = PathReferenceManagerImpl.addIntersectingReferences(nonResolvingRefs, (List<? super PsiReference>)list2, range2);
            PathReferenceManagerImpl.addToResult(element2, result2, (List<? extends PsiReference>)list2, textRange);
        }
        while (!nonResolvingRefs.isEmpty()) {
            list2 = new SmartList();
            range2 = PathReferenceManagerImpl.getFirstIntersectingReferences(nonResolvingRefs, (List<? super PsiReference>)list2);
            int endOffset = range2.getEndOffset();
            for (PsiReference reference3 : list2) {
                endOffset = Math.min(endOffset, reference3.getRangeInElement().getEndOffset());
            }
            PathReferenceManagerImpl.addToResult(element2, result2, (List<? extends PsiReference>)list2, new TextRange(range2.getStartOffset(), endOffset));
        }
        return result2;
    }

    private static void addToResult(PsiElement element2, List<? super PsiReference> result2, List<? extends PsiReference> list2, TextRange range2) {
        if (list2.size() == 1) {
            result2.add((PsiReference)list2.get(0));
        } else {
            PsiDynaReference<PsiElement> psiDynaReference = new PsiDynaReference<PsiElement>(element2);
            psiDynaReference.addReferences(list2);
            psiDynaReference.setRangeInElement(range2);
            result2.add((PsiReference)psiDynaReference);
        }
    }

    private static TextRange addIntersectingReferences(List<PsiReference> set, List<? super PsiReference> toAdd, TextRange range2) {
        int startOffset = range2.getStartOffset();
        int endOffset = range2.getStartOffset();
        Iterator<PsiReference> iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            PsiReference reference2 = iterator2.next();
            TextRange rangeInElement = reference2.getRangeInElement();
            if (!PathReferenceManagerImpl.intersect(range2, rangeInElement)) continue;
            toAdd.add((PsiReference)reference2);
            iterator2.remove();
            startOffset = Math.min(startOffset, rangeInElement.getStartOffset());
            endOffset = Math.max(endOffset, rangeInElement.getEndOffset());
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean intersect(TextRange range1, TextRange range2) {
        return range2.intersectsStrict(range1) || range2.intersects(range1) && (range1.isEmpty() || range2.isEmpty());
    }

    private static TextRange getFirstIntersectingReferences(List<PsiReference> set, List<? super PsiReference> toAdd) {
        int startOffset = Integer.MAX_VALUE;
        int endOffset = -1;
        Iterator<PsiReference> it = set.iterator();
        while (it.hasNext()) {
            PsiReference reference2 = it.next();
            TextRange range2 = reference2.getRangeInElement();
            if (endOffset != -1 && range2.getStartOffset() > endOffset) break;
            startOffset = Math.min(startOffset, range2.getStartOffset());
            endOffset = Math.max(range2.getEndOffset(), endOffset);
            toAdd.add((PsiReference)reference2);
            it.remove();
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean processProvider(PsiElement psiElement, PathReferenceProvider provider, List<PsiReference> mergedReferences, boolean soft) {
        return provider.createReferences(psiElement, mergedReferences, soft);
    }

    private static List<PathReferenceProvider> getProviders() {
        return PATH_REFERENCE_PROVIDER_EP.getExtensionList();
    }
}

