/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryScopeBase
extends GlobalSearchScope {
    private final Set<VirtualFile> myEntries;
    protected final ProjectFileIndex myIndex;

    public LibraryScopeBase(Project project, VirtualFile[] classes, VirtualFile[] sources) {
        super(project);
        this.myIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myEntries = new LinkedHashSet<VirtualFile>(classes.length + sources.length);
        Collections.addAll(this.myEntries, classes);
        Collections.addAll(this.myEntries, sources);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        return this.myEntries.contains(this.getFileRoot(file2));
    }

    @Nullable
    protected VirtualFile getFileRoot(@NotNull VirtualFile file2) {
        if (this.myIndex.isInLibraryClasses(file2)) {
            return this.myIndex.getClassRootForFile(file2);
        }
        if (this.myIndex.isInLibrarySource(file2)) {
            return this.myIndex.getSourceRootForFile(file2);
        }
        return null;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile r1 = this.getFileRoot(file1);
        VirtualFile r2 = this.getFileRoot(file2);
        for (VirtualFile root : this.myEntries) {
            if (Comparing.equal((Object)r1, (Object)root)) {
                return 1;
            }
            if (!Comparing.equal((Object)r2, (Object)root)) continue;
            return -1;
        }
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return false;
    }

    public boolean isSearchInLibraries() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibraryScopeBase)) {
            return false;
        }
        return this.myEntries.equals(((LibraryScopeBase)((Object)o)).myEntries);
    }

    public int calcHashCode() {
        return this.myEntries.hashCode();
    }
}

