/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.impl.ui.KeymapScheme;
import com.intellij.openapi.keymap.impl.ui.KeymapSchemeManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.ui.MessageType;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.ui.JBDimension;
import java.awt.Component;
import java.awt.Dimension;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class KeymapSelector
extends SimpleSchemesPanel<KeymapScheme> {
    private KeymapSchemeManager manager;
    private final Consumer<? super Keymap> consumer;
    private String messageReplacement;
    private boolean messageShown;
    private boolean internal;

    KeymapSelector(Consumer<? super Keymap> consumer) {
        super(0);
        this.consumer = consumer;
    }

    void attachKeymapListener(@NotNull Disposable parentDisposable) {
        ApplicationManager.getApplication().getMessageBus().connect(parentDisposable).subscribe(KeymapManagerListener.TOPIC, (Object)new KeymapManagerListener(){

            public void keymapAdded(@NotNull Keymap keymap2) {
                KeymapSelector.this.manager.handleKeymapAdded(keymap2);
                KeymapSelector.this.resetSchemes(KeymapSelector.this.manager.getSchemes());
            }

            public void keymapRemoved(@NotNull Keymap keymap2) {
                KeymapSelector.this.manager.handleKeymapRemoved(keymap2);
                KeymapSelector.this.resetSchemes(KeymapSelector.this.manager.getSchemes());
            }

            public void activeKeymapChanged(@Nullable Keymap keymap2) {
                KeymapSelector.this.manager.handleActiveKeymapChanged(keymap2);
            }
        });
    }

    @NotNull
    public KeymapSchemeManager getManager() {
        if (this.manager == null) {
            this.manager = new KeymapSchemeManager(this);
        }
        return this.manager;
    }

    @Override
    @NotNull
    public SchemesModel<KeymapScheme> getModel() {
        return this.getManager();
    }

    @Override
    @Nullable
    protected String getComboBoxLabel() {
        return null;
    }

    @Override
    @NotNull
    protected AbstractSchemeActions<KeymapScheme> createSchemeActions() {
        return this.getManager();
    }

    @Override
    protected int getIndent(@NotNull KeymapScheme scheme) {
        return scheme.isMutable() ? 1 : 0;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return false;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return false;
    }

    @Override
    public boolean useBoldForNonRemovableSchemes() {
        return true;
    }

    @Override
    public void showMessage(@Nullable String message, @NotNull MessageType messageType) {
        this.messageShown = true;
        super.showMessage(message, messageType);
    }

    @Override
    public void clearMessage() {
        this.messageShown = false;
        super.showMessage(this.messageReplacement, MessageType.INFO);
    }

    @Override
    protected JComponent createTopComponent() {
        ActionLink link = new ActionLink(KeyMapBundle.message((String)"link.get.more.keymaps.in.0.plugins", (Object[])new Object[]{ShowSettingsUtil.getSettingsMenuName()}), e -> {
            Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)((ActionLink)e.getSource())));
            if (settings != null) {
                settings.select(settings.find("preferences.pluginManager"), "/tag:Keymap");
            }
        });
        Box row = new Box(0);
        row.add(Box.createRigidArea((Dimension)new JBDimension(2, 0)));
        row.add((Component)link);
        row.add(Box.createHorizontalGlue());
        Box box = new Box(1);
        box.add(Box.createRigidArea((Dimension)new JBDimension(0, 5)));
        box.add(row);
        box.add(Box.createRigidArea((Dimension)new JBDimension(0, 12)));
        return box;
    }

    void notifyConsumer(KeymapScheme scheme) {
        if (this.internal) {
            return;
        }
        Keymap keymap2 = scheme == null ? null : scheme.getParent();
        String string = this.messageReplacement = keymap2 == null ? null : KeyMapBundle.message((String)"based.on.keymap.label", (Object[])new Object[]{keymap2.getPresentableName()});
        if (!this.messageShown) {
            this.clearMessage();
        }
        this.consumer.accept(scheme == null ? null : scheme.getCurrent());
    }

    void selectKeymap(KeymapScheme scheme, boolean reset2) {
        try {
            this.internal = true;
            if (reset2) {
                this.resetSchemes(this.getManager().getSchemes());
            }
            if (scheme != null) {
                this.selectScheme(scheme);
            }
        }
        finally {
            this.internal = false;
            this.notifyConsumer((KeymapScheme)this.getSelectedScheme());
        }
    }
}

