/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class RemovedMappingTracker {
    private final Map<FileNameMatcher, RemovedMapping> myRemovedMappings = new HashMap<FileNameMatcher, RemovedMapping>();
    @NonNls
    private static final String ELEMENT_REMOVED_MAPPING = "removed_mapping";
    @NonNls
    private static final String ATTRIBUTE_APPROVED = "approved";
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";

    RemovedMappingTracker() {
    }

    void clear() {
        this.myRemovedMappings.clear();
    }

    public void add(@NotNull FileNameMatcher matcher, @NotNull String fileTypeName, boolean approved) {
        this.myRemovedMappings.put(matcher, new RemovedMapping(matcher, fileTypeName, approved));
    }

    public void load(@NotNull Element e) {
        for (RemovedMapping mapping2 : RemovedMappingTracker.readRemovedMappings(e)) {
            this.myRemovedMappings.put(mapping2.myFileNameMatcher, mapping2);
        }
    }

    @NotNull
    static List<RemovedMapping> readRemovedMappings(@NotNull Element e) {
        List children2 = e.getChildren(ELEMENT_REMOVED_MAPPING);
        if (children2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RemovedMapping> result2 = new ArrayList<RemovedMapping>();
        for (Element mapping2 : children2) {
            String ext = mapping2.getAttributeValue("ext");
            ExtensionFileNameMatcher matcher = ext == null ? FileTypeManager.parseFromString((String)mapping2.getAttributeValue("pattern")) : new ExtensionFileNameMatcher(ext);
            boolean approved = Boolean.parseBoolean(mapping2.getAttributeValue(ATTRIBUTE_APPROVED));
            String fileTypeName = mapping2.getAttributeValue(ATTRIBUTE_TYPE);
            if (fileTypeName == null) continue;
            RemovedMapping removedMapping = new RemovedMapping((FileNameMatcher)matcher, fileTypeName, approved);
            result2.add(removedMapping);
        }
        return result2;
    }

    public void save(@NotNull Element element2) {
        for (RemovedMapping mapping2 : this.myRemovedMappings.values()) {
            Element content2 = RemovedMappingTracker.writeRemovedMapping(mapping2.myFileTypeName, mapping2.myFileNameMatcher, true, mapping2.myApproved);
            if (content2 == null) continue;
            element2.addContent(content2);
        }
    }

    void saveRemovedMappingsForFileType(@NotNull Element map2, @NotNull String fileTypeName, @NotNull Set<? extends FileNameMatcher> associations, boolean specifyTypeName) {
        for (FileNameMatcher fileNameMatcher : associations) {
            Element content2 = RemovedMappingTracker.writeRemovedMapping(fileTypeName, fileNameMatcher, specifyTypeName, this.isApproved(fileNameMatcher));
            if (content2 == null) continue;
            map2.addContent(content2);
        }
    }

    boolean hasRemovedMapping(@NotNull FileNameMatcher matcher) {
        return this.myRemovedMappings.containsKey(matcher);
    }

    private boolean isApproved(@NotNull FileNameMatcher matcher) {
        RemovedMapping mapping2 = this.myRemovedMappings.get(matcher);
        return mapping2 != null && mapping2.isApproved();
    }

    void approveRemoval(@NotNull String fileTypeName, @NotNull FileNameMatcher matcher) {
        this.myRemovedMappings.put(matcher, new RemovedMapping(matcher, fileTypeName, true));
    }

    @NotNull
    public List<RemovedMapping> getRemovedMappings() {
        return new ArrayList<RemovedMapping>(this.myRemovedMappings.values());
    }

    List<FileNameMatcher> getMappingsForFileType(@NotNull String name) {
        ArrayList<FileNameMatcher> result2 = new ArrayList<FileNameMatcher>();
        for (RemovedMapping mapping2 : this.myRemovedMappings.values()) {
            if (!mapping2.myFileTypeName.equals(name)) continue;
            result2.add(mapping2.myFileNameMatcher);
        }
        return result2;
    }

    void removeMatching(@NotNull BiPredicate<? super FileNameMatcher, ? super String> predicate) {
        this.myRemovedMappings.entrySet().removeIf(next -> predicate.test(((RemovedMapping)next.getValue()).myFileNameMatcher, ((RemovedMapping)next.getValue()).myFileTypeName));
    }

    @NotNull
    List<RemovedMapping> retrieveUnapprovedMappings() {
        ArrayList<RemovedMapping> result2 = new ArrayList<RemovedMapping>();
        Iterator<Map.Entry<FileNameMatcher, RemovedMapping>> it = this.myRemovedMappings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<FileNameMatcher, RemovedMapping> next = it.next();
            if (next.getValue().isApproved()) continue;
            result2.add(next.getValue());
            it.remove();
        }
        return result2;
    }

    private static Element writeRemovedMapping(@NotNull String fileTypeName, @NotNull FileNameMatcher matcher, boolean specifyTypeName, boolean approved) {
        Element mapping2 = new Element(ELEMENT_REMOVED_MAPPING);
        if (!AbstractFileType.writePattern(matcher, mapping2)) {
            return null;
        }
        if (approved) {
            mapping2.setAttribute(ATTRIBUTE_APPROVED, "true");
        }
        if (specifyTypeName) {
            mapping2.setAttribute(ATTRIBUTE_TYPE, fileTypeName);
        }
        return mapping2;
    }

    public static class RemovedMapping {
        private final FileNameMatcher myFileNameMatcher;
        private final String myFileTypeName;
        private boolean myApproved;

        private RemovedMapping(@NotNull FileNameMatcher matcher, @NotNull String name, boolean approved) {
            this.myFileNameMatcher = matcher;
            this.myFileTypeName = name;
            this.myApproved = approved;
        }

        public FileNameMatcher getFileNameMatcher() {
            return this.myFileNameMatcher;
        }

        public String getFileTypeName() {
            return this.myFileTypeName;
        }

        public boolean isApproved() {
            return this.myApproved;
        }

        public void setApproved(boolean approved) {
            this.myApproved = approved;
        }
    }
}

