/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.ide.highlighter.custom.AbstractCustomLexer;
import com.intellij.ide.highlighter.custom.tokens.BraceTokenParser;
import com.intellij.ide.highlighter.custom.tokens.TokenParser;
import com.intellij.ide.highlighter.custom.tokens.WhitespaceParser;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PlainTextSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(Project project, VirtualFile virtualFile) {
        return new SyntaxHighlighterBase(){

            @NotNull
            public Lexer getHighlightingLexer() {
                return PlainTextSyntaxHighlighterFactory.createPlainTextLexer();
            }

            public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
                return TextAttributesKey.EMPTY_ARRAY;
            }
        };
    }

    @NotNull
    public static Lexer createPlainTextLexer() {
        ArrayList<TokenParser> tokenParsers = new ArrayList<TokenParser>();
        tokenParsers.add(new WhitespaceParser());
        tokenParsers.addAll(BraceTokenParser.getBraces());
        tokenParsers.addAll(BraceTokenParser.getParens());
        tokenParsers.addAll(BraceTokenParser.getBrackets());
        tokenParsers.addAll(BraceTokenParser.getAngleBrackets());
        return new MergingLexerAdapter((Lexer)new AbstractCustomLexer(tokenParsers), TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.CHARACTER}));
    }
}

