/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.LanguageSyntaxHighlighters;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterLanguageFactory;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.messages.MessageBusConnection;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHighlighterUpdater {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final EditorEx myEditor;
    @Nullable
    private final VirtualFile myFile;

    public EditorHighlighterUpdater(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull EditorEx editor, @Nullable VirtualFile file2) {
        this.myProject = project;
        this.myEditor = editor;
        this.myFile = file2;
        MessageBusConnection connection = project.getMessageBus().connect(parentDisposable);
        connection.subscribe(FileTypeManager.TOPIC, (Object)new MyFileTypeListener());
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                EditorHighlighterUpdater.this.updateHighlighters();
            }

            public void exitDumbMode() {
                EditorHighlighterUpdater.this.updateHighlighters();
            }
        });
        this.updateHighlightersOnExtensionsChange(parentDisposable, LanguageSyntaxHighlighters.EP_NAME);
        this.updateHighlightersOnExtensionsChange(parentDisposable, SyntaxHighlighterLanguageFactory.EP_NAME);
        this.updateHighlightersOnExtensionsChange(parentDisposable, FileTypeEditorHighlighterProviders.EP_NAME);
        SyntaxHighlighter.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<KeyedFactoryEPBean>(){

            public void extensionAdded(@NotNull KeyedFactoryEPBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                EditorHighlighterUpdater.this.checkUpdateHighlighters(extension.key, false);
            }

            public void extensionRemoved(@NotNull KeyedFactoryEPBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                EditorHighlighterUpdater.this.checkUpdateHighlighters(extension.key, true);
            }
        }, parentDisposable);
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                FileType fileType;
                if (pluginDescriptor.getPluginId() == null) {
                    return;
                }
                IdeaPluginDescriptor loadedPluginDescriptor = PluginManagerCore.getPlugin(pluginDescriptor.getPluginId());
                if (loadedPluginDescriptor == null) {
                    return;
                }
                ClassLoader pluginClassLoader = loadedPluginDescriptor.getPluginClassLoader();
                if (EditorHighlighterUpdater.this.myFile != null && pluginClassLoader instanceof PluginClassLoader && ((fileType = EditorHighlighterUpdater.this.myFile.getFileType()).getClass().getClassLoader() == pluginClassLoader || fileType instanceof LanguageFileType && ((LanguageFileType)fileType).getClass().getClassLoader() == pluginClassLoader)) {
                    EditorHighlighterUpdater.this.myEditor.setHighlighter(EditorHighlighterUpdater.this.createHighlighter(true));
                }
            }
        });
    }

    private <T> void updateHighlightersOnExtensionsChange(@NotNull Disposable parentDisposable, @NotNull ExtensionPointName<KeyedLazyInstance<T>> epName) {
        epName.addExtensionPointListener(new ExtensionPointListener<KeyedLazyInstance<T>>(){

            public void extensionAdded(@NotNull KeyedLazyInstance<T> extension, @NotNull PluginDescriptor pluginDescriptor) {
                EditorHighlighterUpdater.this.checkUpdateHighlighters(extension.getKey(), false);
            }

            public void extensionRemoved(@NotNull KeyedLazyInstance<T> extension, @NotNull PluginDescriptor pluginDescriptor) {
                EditorHighlighterUpdater.this.checkUpdateHighlighters(extension.getKey(), true);
            }
        }, parentDisposable);
    }

    private void checkUpdateHighlighters(String key, boolean updateSynchronously) {
        if (this.myFile != null) {
            boolean needUpdate;
            FileType fileType = this.myFile.getFileType();
            boolean bl = needUpdate = fileType.getName().equals(key) || fileType instanceof LanguageFileType && ((LanguageFileType)fileType).getLanguage().getID().equals(key);
            if (!needUpdate) {
                return;
            }
        }
        if (ApplicationManager.getApplication().isDispatchThread() && updateSynchronously) {
            this.updateHighlightersSynchronously();
        } else {
            this.updateHighlighters();
        }
    }

    public void updateHighlightersAsync() {
        ReadAction.nonBlocking(() -> this.createHighlighter(false)).expireWith((Disposable)this.myProject).expireWhen(() -> this.myFile != null && !this.myFile.isValid() || this.myEditor.isDisposed()).coalesceBy(new Object[]{EditorHighlighterUpdater.class, this.myEditor}).finishOnUiThread(ModalityState.any(), highlighter -> this.myEditor.setHighlighter((EditorHighlighter)highlighter)).submit((Executor)NonUrgentExecutor.getInstance());
    }

    @NotNull
    protected EditorHighlighter createHighlighter(boolean forceEmpty) {
        EmptyEditorHighlighter highlighter = this.myFile != null && !forceEmpty ? EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, this.myFile) : new EmptyEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(HighlighterColors.TEXT));
        highlighter.setText(this.myEditor.getDocument().getImmutableCharSequence());
        return highlighter;
    }

    public void updateHighlighters() {
        if (!this.myProject.isDisposed() && !this.myEditor.isDisposed()) {
            this.updateHighlightersAsync();
        }
    }

    private void updateHighlightersSynchronously() {
        if (!this.myProject.isDisposed() && !this.myEditor.isDisposed()) {
            this.myEditor.setHighlighter(this.createHighlighter(false));
        }
    }

    public static void completeAsyncTasks() {
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
    }

    private final class MyFileTypeListener
    implements FileTypeListener {
        private MyFileTypeListener() {
        }

        public void fileTypesChanged(@NotNull FileTypeEvent event) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            FileType type = event.getRemovedFileType();
            if (type != null && !(type instanceof AbstractFileType)) {
                EditorHighlighterUpdater.this.updateHighlightersSynchronously();
            } else {
                EditorHighlighterUpdater.this.updateHighlighters();
            }
        }
    }
}

