/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.tabActions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BitUtil;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/fileEditor/impl/tabActions/CloseTab;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "c", "Ljavax/swing/JComponent;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "editorWindow", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Ljavax/swing/JComponent;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileEditor/impl/EditorWindow;Lcom/intellij/openapi/Disposable;)V", "getEditorWindow", "()Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.ide.impl"})
public final class CloseTab
extends AnAction
implements DumbAware {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final Project project;
    @NotNull
    private final EditorWindow editorWindow;

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setIcon(AllIcons.Actions.Close);
        e.getPresentation().setHoveredIcon(AllIcons.Actions.CloseHovered);
        e.getPresentation().setVisible(UISettings.Companion.getInstance().getShowCloseButton());
        e.getPresentation().setText(IdeBundle.messagePointer((String)"action.presentation.EditorTabbedContainer.text", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        FileEditorManagerEx mgr = FileEditorManagerEx.getInstanceEx(this.project);
        EditorWindow window = null;
        window = Intrinsics.areEqual((Object)"EditorTab", (Object)e.getPlace()) ? this.editorWindow : mgr.getCurrentWindow();
        if (window != null) {
            if (BitUtil.isSet((int)e.getModifiers(), (int)8)) {
                window.closeAllExcept(this.file);
            } else if (window.findFileComposite(this.file) != null) {
                mgr.closeFile(this.file, window);
            }
        }
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final EditorWindow getEditorWindow() {
        return this.editorWindow;
    }

    public CloseTab(@NotNull JComponent c, @NotNull VirtualFile file2, @NotNull Project project, @NotNull EditorWindow editorWindow, @NotNull Disposable parentDisposable) {
        this.file = file2;
        this.project = project;
        this.editorWindow = editorWindow;
        new ShadowAction((AnAction)this, ActionManager.getInstance().getAction("CloseContent"), c, parentDisposable);
    }
}

