/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.ProblemListener;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;

public class PsiAwareFileEditorManagerImpl
extends FileEditorManagerImpl {
    private final WolfTheProblemSolver myProblemSolver;

    public PsiAwareFileEditorManagerImpl(@NotNull Project project) {
        super(project);
        this.myProblemSolver = WolfTheProblemSolver.getInstance((Project)project);
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(PowerSaveMode.TOPIC, (Object)new PowerSaveMode.Listener(){

            public void powerSaveStateChanged() {
                UIUtil.invokeLaterIfNeeded(() -> {
                    for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                        ((EditorEx)editor).reinitSettings();
                    }
                });
            }
        });
        connection.subscribe(ProblemListener.TOPIC, (Object)new MyProblemListener());
    }

    @Override
    public boolean isProblem(@NotNull VirtualFile file2) {
        return this.myProblemSolver.isProblemFile(file2);
    }

    @Override
    @NotNull
    public String getFileTooltipText(@NotNull VirtualFile file2) {
        Module module;
        StringBuilder tooltipText = new StringBuilder();
        if (Registry.is((String)"ide.tab.tooltip.module") && (module = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)this.getProject())) != null && ModuleManager.getInstance((Project)this.getProject()).getModules().length > 1) {
            tooltipText.append("[");
            tooltipText.append(module.getName());
            tooltipText.append("] ");
        }
        tooltipText.append(super.getFileTooltipText(file2));
        return tooltipText.toString();
    }

    private final class MyProblemListener
    implements ProblemListener {
        private MyProblemListener() {
        }

        public void problemsAppeared(@NotNull VirtualFile file2) {
            this.updateFile(file2);
        }

        public void problemsDisappeared(@NotNull VirtualFile file2) {
            this.updateFile(file2);
        }

        public void problemsChanged(@NotNull VirtualFile file2) {
            this.updateFile(file2);
        }

        private void updateFile(@NotNull VirtualFile file2) {
            PsiAwareFileEditorManagerImpl.this.queueUpdateFile(file2);
        }
    }
}

