/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockableEditorContainerFactory
implements DockContainerFactory.Persistent {
    public static final String TYPE = "file-editors";
    private final Project myProject;
    private final FileEditorManagerImpl myFileEditorManager;

    public DockableEditorContainerFactory(@NotNull Project project, @NotNull FileEditorManagerImpl fileEditorManager) {
        this.myProject = project;
        this.myFileEditorManager = fileEditorManager;
    }

    @NotNull
    public DockContainer createContainer(@Nullable DockableContent content2) {
        return this.createContainer(false);
    }

    private DockContainer createContainer(boolean loadingState) {
        final Ref containerRef = new Ref();
        EditorsSplitters splitters = new EditorsSplitters(this.myFileEditorManager, false, (Disposable)this.myProject){

            @Override
            protected void afterFileClosed(@NotNull VirtualFile file2) {
                ((DockableEditorTabbedContainer)containerRef.get()).fireContentClosed(file2);
            }

            @Override
            protected void afterFileOpen(@NotNull VirtualFile file2) {
                ((DockableEditorTabbedContainer)containerRef.get()).fireContentOpen(file2);
            }

            @Override
            protected IdeFrameEx getFrame(@NotNull Project project) {
                IdeFrame frame = DockManager.getInstance((Project)project).getIdeFrame((DockContainer)containerRef.get());
                return frame instanceof IdeFrameEx ? (IdeFrameEx)frame : ProjectFrameHelper.getFrameHelper((IdeFrameImpl)frame);
            }

            @Override
            public boolean isFloating() {
                return true;
            }
        };
        if (!loadingState) {
            splitters.createCurrentWindow();
        }
        DockableEditorTabbedContainer container2 = new DockableEditorTabbedContainer(this.myProject, splitters, true);
        containerRef.set((Object)container2);
        container2.getSplitters().startListeningFocus();
        return container2;
    }

    public DockContainer loadContainerFrom(Element element2) {
        DockableEditorTabbedContainer container2 = (DockableEditorTabbedContainer)this.createContainer(true);
        container2.getSplitters().readExternal(element2.getChild("state"));
        return container2;
    }
}

