/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.SplitEditorToolbar;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.JBSplitter;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorWithPreview
extends UserDataHolderBase
implements TextEditor {
    protected final TextEditor myEditor;
    protected final FileEditor myPreview;
    @NotNull
    private final MyListenersMultimap myListenersGenerator = new MyListenersMultimap();
    private final Layout myDefaultLayout;
    private Layout myLayout;
    private JComponent myComponent;
    private SplitEditorToolbar myToolbarWrapper;
    private final String myName;
    public static final Key<Layout> DEFAULT_LAYOUT_FOR_FILE = Key.create((String)"TextEditorWithPreview.DefaultLayout");

    public TextEditorWithPreview(@NotNull TextEditor editor, @NotNull FileEditor preview, @NotNull String editorName, @NotNull Layout defaultLayout) {
        this.myEditor = editor;
        this.myPreview = preview;
        this.myName = editorName;
        this.myDefaultLayout = defaultLayout;
    }

    public TextEditorWithPreview(@NotNull TextEditor editor, @NotNull FileEditor preview, @NotNull String editorName) {
        this(editor, preview, editorName, Layout.SHOW_EDITOR_AND_PREVIEW);
    }

    public TextEditorWithPreview(@NotNull TextEditor editor, @NotNull FileEditor preview) {
        this(editor, preview, "TextEditorWithPreview");
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return this.myEditor.getBackgroundHighlighter();
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return this.myEditor.getCurrentLocation();
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return this.myEditor.getStructureViewBuilder();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myEditor);
        Disposer.dispose((Disposable)this.myPreview);
    }

    public void selectNotify() {
        this.myEditor.selectNotify();
        this.myPreview.selectNotify();
    }

    public void deselectNotify() {
        this.myEditor.deselectNotify();
        this.myPreview.deselectNotify();
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myComponent == null) {
            JBSplitter splitter = new JBSplitter(false, 0.5f, 0.15f, 0.85f);
            splitter.setSplitterProportionKey(this.getSplitterProportionKey());
            splitter.setFirstComponent(this.myEditor.getComponent());
            splitter.setSecondComponent(this.myPreview.getComponent());
            splitter.setDividerWidth(3);
            this.myToolbarWrapper = this.createMarkdownToolbarWrapper((JComponent)splitter);
            if (this.myLayout == null) {
                String lastUsed = PropertiesComponent.getInstance().getValue(this.getLayoutPropertyName());
                this.myLayout = Layout.fromName(lastUsed, this.myDefaultLayout);
            }
            this.adjustEditorsVisibility();
            this.myComponent = JBUI.Panels.simplePanel((Component)splitter).addToTop((Component)this.myToolbarWrapper);
        }
        return this.myComponent;
    }

    @NotNull
    private SplitEditorToolbar createMarkdownToolbarWrapper(@NotNull JComponent targetComponentForActions) {
        ActionToolbar leftToolbar = this.createToolbar();
        if (leftToolbar != null) {
            leftToolbar.setTargetComponent(targetComponentForActions);
            leftToolbar.setReservePlaceAutoPopupIcon(false);
        }
        ActionToolbar rightToolbar = this.createRightToolbar();
        rightToolbar.setTargetComponent(targetComponentForActions);
        rightToolbar.setReservePlaceAutoPopupIcon(false);
        return new SplitEditorToolbar(leftToolbar, rightToolbar);
    }

    public void setState(@NotNull FileEditorState state) {
        if (state instanceof MyFileEditorState) {
            MyFileEditorState compositeState = (MyFileEditorState)state;
            if (compositeState.getFirstState() != null) {
                this.myEditor.setState(compositeState.getFirstState());
            }
            if (compositeState.getSecondState() != null) {
                this.myPreview.setState(compositeState.getSecondState());
            }
            if (compositeState.getSplitLayout() != null) {
                this.myLayout = compositeState.getSplitLayout();
                this.invalidateLayout();
            }
        }
    }

    private void adjustEditorsVisibility() {
        this.myEditor.getComponent().setVisible(this.myLayout == Layout.SHOW_EDITOR || this.myLayout == Layout.SHOW_EDITOR_AND_PREVIEW);
        this.myPreview.getComponent().setVisible(this.myLayout == Layout.SHOW_PREVIEW || this.myLayout == Layout.SHOW_EDITOR_AND_PREVIEW);
    }

    private void invalidateLayout() {
        this.adjustEditorsVisibility();
        this.myToolbarWrapper.refresh();
        this.myComponent.repaint();
        JComponent focusComponent = this.getPreferredFocusedComponent();
        if (focusComponent != null) {
            IdeFocusManager.findInstanceByComponent((Component)focusComponent).requestFocus((Component)focusComponent, true);
        }
    }

    @NotNull
    protected String getSplitterProportionKey() {
        return "TextEditorWithPreview.SplitterProportionKey";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        switch (this.myLayout) {
            case SHOW_EDITOR_AND_PREVIEW: 
            case SHOW_EDITOR: {
                return this.myEditor.getPreferredFocusedComponent();
            }
            case SHOW_PREVIEW: {
                return this.myPreview.getPreferredFocusedComponent();
            }
        }
        throw new IllegalStateException(this.myLayout.myName);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        return new MyFileEditorState(this.myLayout, this.myEditor.getState(level), this.myPreview.getState(level));
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myEditor.addPropertyChangeListener(listener2);
        this.myPreview.addPropertyChangeListener(listener2);
        DoublingEventListenerDelegate delegate = this.myListenersGenerator.addListenerAndGetDelegate(listener2);
        this.myEditor.addPropertyChangeListener((PropertyChangeListener)delegate);
        this.myPreview.addPropertyChangeListener((PropertyChangeListener)delegate);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myEditor.removePropertyChangeListener(listener2);
        this.myPreview.removePropertyChangeListener(listener2);
        DoublingEventListenerDelegate delegate = this.myListenersGenerator.removeListenerAndGetDelegate(listener2);
        if (delegate != null) {
            this.myEditor.removePropertyChangeListener((PropertyChangeListener)delegate);
            this.myPreview.removePropertyChangeListener((PropertyChangeListener)delegate);
        }
    }

    @NotNull
    public TextEditor getTextEditor() {
        return this.myEditor;
    }

    public Layout getLayout() {
        return this.myLayout;
    }

    public boolean isModified() {
        return this.myEditor.isModified() || this.myPreview.isModified();
    }

    public boolean isValid() {
        return this.myEditor.isValid() && this.myPreview.isValid();
    }

    @Nullable
    protected ActionToolbar createToolbar() {
        ActionGroup actionGroup = this.createLeftToolbarActionGroup();
        if (actionGroup != null) {
            return ActionManager.getInstance().createActionToolbar("TextEditorWithPreview", actionGroup, true);
        }
        return null;
    }

    @Nullable
    protected ActionGroup createLeftToolbarActionGroup() {
        return null;
    }

    @NotNull
    private ActionToolbar createRightToolbar() {
        ActionGroup viewActions = this.createViewActionGroup();
        ActionGroup group = this.createRightToolbarActionGroup();
        ActionGroup rightToolbarActions = group == null ? viewActions : new DefaultActionGroup(new AnAction[]{group, Separator.create(), viewActions});
        return ActionManager.getInstance().createActionToolbar("TextEditorWithPreview", rightToolbarActions, true);
    }

    @NotNull
    protected ActionGroup createViewActionGroup() {
        return new DefaultActionGroup(new AnAction[]{this.getShowEditorAction(), this.getShowEditorAndPreviewAction(), this.getShowPreviewAction()});
    }

    @Nullable
    protected ActionGroup createRightToolbarActionGroup() {
        return null;
    }

    @NotNull
    protected ToggleAction getShowEditorAction() {
        return new ChangeViewModeAction(Layout.SHOW_EDITOR);
    }

    @NotNull
    protected ToggleAction getShowPreviewAction() {
        return new ChangeViewModeAction(Layout.SHOW_PREVIEW);
    }

    @NotNull
    protected ToggleAction getShowEditorAndPreviewAction() {
        return new ChangeViewModeAction(Layout.SHOW_EDITOR_AND_PREVIEW);
    }

    @NotNull
    private String getLayoutPropertyName() {
        return this.myName + "Layout";
    }

    @Nullable
    public VirtualFile getFile() {
        return this.getTextEditor().getFile();
    }

    @NotNull
    public Editor getEditor() {
        return this.getTextEditor().getEditor();
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        return this.getTextEditor().canNavigateTo(navigatable);
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        this.getTextEditor().navigateTo(navigatable);
    }

    private class ChangeViewModeAction
    extends ToggleAction
    implements DumbAware {
        private final Layout myActionLayout;

        ChangeViewModeAction(Layout layout) {
            super(layout.getName(), layout.getName(), layout.getIcon());
            this.myActionLayout = layout;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return TextEditorWithPreview.this.myLayout == this.myActionLayout;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (state) {
                TextEditorWithPreview.this.myLayout = this.myActionLayout;
                PropertiesComponent.getInstance().setValue(TextEditorWithPreview.this.getLayoutPropertyName(), TextEditorWithPreview.this.myLayout.myName, TextEditorWithPreview.this.myDefaultLayout.myName);
                TextEditorWithPreview.this.adjustEditorsVisibility();
            }
        }
    }

    public static enum Layout {
        SHOW_EDITOR("Editor only", AllIcons.General.LayoutEditorOnly),
        SHOW_PREVIEW("Preview only", AllIcons.General.LayoutPreviewOnly),
        SHOW_EDITOR_AND_PREVIEW("Editor and Preview", AllIcons.General.LayoutEditorPreview);

        private final String myName;
        private final Icon myIcon;

        private Layout(String name, Icon icon2) {
            this.myName = name;
            this.myIcon = icon2;
        }

        public static Layout fromName(String name, Layout defaultValue) {
            for (Layout layout : Layout.values()) {
                if (!layout.myName.equals(name)) continue;
                return layout;
            }
            return defaultValue;
        }

        public String getName() {
            return this.myName;
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }

    private class MyListenersMultimap {
        private final Map<PropertyChangeListener, Pair<Integer, DoublingEventListenerDelegate>> myMap = new HashMap<PropertyChangeListener, Pair<Integer, DoublingEventListenerDelegate>>();

        private MyListenersMultimap() {
        }

        @NotNull
        public DoublingEventListenerDelegate addListenerAndGetDelegate(@NotNull PropertyChangeListener listener2) {
            if (!this.myMap.containsKey(listener2)) {
                this.myMap.put(listener2, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)1, (Object)new DoublingEventListenerDelegate(listener2)));
            } else {
                Pair<Integer, DoublingEventListenerDelegate> oldPair = this.myMap.get(listener2);
                this.myMap.put(listener2, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)((Integer)oldPair.getFirst() + 1), (Object)oldPair.getSecond()));
            }
            return (DoublingEventListenerDelegate)this.myMap.get(listener2).getSecond();
        }

        @Nullable
        public DoublingEventListenerDelegate removeListenerAndGetDelegate(@NotNull PropertyChangeListener listener2) {
            Pair<Integer, DoublingEventListenerDelegate> oldPair = this.myMap.get(listener2);
            if (oldPair == null) {
                return null;
            }
            if ((Integer)oldPair.getFirst() == 1) {
                this.myMap.remove(listener2);
            } else {
                this.myMap.put(listener2, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)((Integer)oldPair.getFirst() - 1), (Object)oldPair.getSecond()));
            }
            return (DoublingEventListenerDelegate)oldPair.getSecond();
        }
    }

    private class DoublingEventListenerDelegate
    implements PropertyChangeListener {
        @NotNull
        private final PropertyChangeListener myDelegate;

        private DoublingEventListenerDelegate(PropertyChangeListener delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.myDelegate.propertyChange(new PropertyChangeEvent((Object)TextEditorWithPreview.this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
        }
    }

    static class MyFileEditorState
    implements FileEditorState {
        private final Layout mySplitLayout;
        private final FileEditorState myFirstState;
        private final FileEditorState mySecondState;

        MyFileEditorState(Layout layout, FileEditorState firstState, FileEditorState secondState) {
            this.mySplitLayout = layout;
            this.myFirstState = firstState;
            this.mySecondState = secondState;
        }

        @Nullable
        public Layout getSplitLayout() {
            return this.mySplitLayout;
        }

        @Nullable
        public FileEditorState getFirstState() {
            return this.myFirstState;
        }

        @Nullable
        public FileEditorState getSecondState() {
            return this.mySecondState;
        }

        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return !(!(otherState instanceof MyFileEditorState) || this.myFirstState != null && !this.myFirstState.canBeMergedWith(((MyFileEditorState)otherState).myFirstState, level) || this.mySecondState != null && !this.mySecondState.canBeMergedWith(((MyFileEditorState)otherState).mySecondState, level));
        }
    }
}

