/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude.ui;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.file.exclude.EnforcedPlainTextFileType;
import com.intellij.openapi.file.exclude.EnforcedPlainTextFileTypeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class MarkAsPlainTextAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        EnforcedPlainTextFileTypeManager typeManager = EnforcedPlainTextFileTypeManager.getInstance();
        JBIterable selectedFiles = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(file2 -> EnforcedPlainTextFileTypeManager.isApplicableFor(file2) && !typeManager.isMarkedAsPlainText((VirtualFile)file2));
        typeManager.markAsPlainText(project, VfsUtilCore.toVirtualFileArray((Collection)selectedFiles.toList()));
    }

    public void update(@NotNull AnActionEvent e) {
        EnforcedPlainTextFileTypeManager typeManager = EnforcedPlainTextFileTypeManager.getInstance();
        JBIterable selectedFiles = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(file2 -> EnforcedPlainTextFileTypeManager.isApplicableFor(file2) && !typeManager.isMarkedAsPlainText((VirtualFile)file2));
        boolean enabled = e.getProject() != null && !selectedFiles.isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
        e.getPresentation().setIcon(EnforcedPlainTextFileType.INSTANCE.getIcon());
    }
}

