/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.file.exclude.ProjectPlainTextFileTypeManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FileContentUtilCore;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class EnforcedPlainTextFileTypeManager {
    private Collection[] explicitlyMarkedSets = new Collection[0];
    private Project[] explicitlyMarkedProjects = new Project[0];

    public EnforcedPlainTextFileTypeManager() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                this.addProjectPlainTextFiles(project);
            }

            public void projectClosed(@NotNull Project project) {
                EnforcedPlainTextFileTypeManager.this.ensureProjectFileSetRemoved(project);
            }

            private void addProjectPlainTextFiles(@NotNull Project project) {
                if (!project.isDisposed()) {
                    EnforcedPlainTextFileTypeManager.this.ensureProjectFileUpToDate(project);
                    Disposer.register((Disposable)project, () -> EnforcedPlainTextFileTypeManager.this.ensureProjectFileSetRemoved(project));
                }
            }
        });
    }

    public static EnforcedPlainTextFileTypeManager getInstance() {
        return (EnforcedPlainTextFileTypeManager)ApplicationManager.getApplication().getService(EnforcedPlainTextFileTypeManager.class);
    }

    public boolean isMarkedAsPlainText(@NotNull VirtualFile file2) {
        if (!(file2 instanceof VirtualFileWithId) || file2.isDirectory()) {
            return false;
        }
        for (Collection explicitlyMarked : this.explicitlyMarkedSets) {
            if (!explicitlyMarked.contains(file2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isApplicableFor(@Nullable VirtualFile file2) {
        if (!(file2 instanceof VirtualFileWithId) || file2.isDirectory()) {
            return false;
        }
        if (ScratchUtil.isScratch(file2)) {
            return false;
        }
        FileType originalType = FileTypeManager.getInstance().getFileTypeByFileName(file2.getNameSequence());
        return !originalType.isBinary() && originalType != FileTypes.PLAIN_TEXT && originalType != StdFileTypes.JAVA;
    }

    public void markAsPlainText(@NotNull Project project, VirtualFile ... files2) {
        this.setPlainTextStatus(project, true, files2);
    }

    public void resetOriginalFileType(@NotNull Project project, VirtualFile ... files2) {
        this.setPlainTextStatus(project, false, files2);
    }

    private void setPlainTextStatus(@NotNull Project project, boolean toAdd, VirtualFile ... files2) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
            ProjectPlainTextFileTypeManager plainTextFileTypeManager = ProjectPlainTextFileTypeManager.getInstance(project);
            for (VirtualFile file2 : files2) {
                boolean changed2;
                if (!fileIndex.isInContent(file2) && !fileIndex.isInLibrarySource(file2) && !fileIndex.isExcluded(file2)) continue;
                boolean bl = changed2 = toAdd ? plainTextFileTypeManager.addFile(file2) : plainTextFileTypeManager.removeFile(file2);
                if (!changed2) continue;
                this.ensureProjectFileUpToDate(project);
            }
            FileContentUtilCore.reparseFiles((VirtualFile[])files2);
        });
    }

    private void ensureProjectFileUpToDate(@NotNull Project project) {
        int i2 = ArrayUtil.indexOf((Object[])this.explicitlyMarkedProjects, (Object)project);
        ProjectPlainTextFileTypeManager projectPlainTextFileTypeManager = ProjectPlainTextFileTypeManager.getInstance(project);
        if (i2 == -1) {
            this.explicitlyMarkedProjects = (Project[])ArrayUtil.append((Object[])this.explicitlyMarkedProjects, (Object)project);
            this.explicitlyMarkedSets = (Collection[])ArrayUtil.append((Object[])this.explicitlyMarkedSets, (Object)projectPlainTextFileTypeManager.getFiles());
        } else {
            this.explicitlyMarkedSets[i2] = projectPlainTextFileTypeManager.getFiles();
        }
    }

    private void ensureProjectFileSetRemoved(@NotNull Project project) {
        int i2 = ArrayUtil.indexOf((Object[])this.explicitlyMarkedProjects, (Object)project);
        if (i2 >= 0) {
            this.explicitlyMarkedProjects = (Project[])ArrayUtil.remove((Object[])this.explicitlyMarkedProjects, (int)i2);
            this.explicitlyMarkedSets = (Collection[])ArrayUtil.remove((Object[])this.explicitlyMarkedSets, (int)i2);
        }
    }
}

