/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.TaskNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Order(value=10)
public class TasksNode
extends ExternalSystemNode<Object> {
    private final MultiMap<String, TaskNode> myTasksMap = new MultiMap();

    public TasksNode(ExternalProjectsView externalProjectsView, Collection<? extends DataNode<?>> dataNodes) {
        super(externalProjectsView, null, null);
        if (dataNodes != null && !dataNodes.isEmpty()) {
            for (DataNode<?> dataNode : dataNodes) {
                if (!(dataNode.getData() instanceof TaskData)) continue;
                String group = ((TaskData)dataNode.getData()).getGroup();
                if (group == null) {
                    group = "other";
                }
                this.myTasksMap.putValue((Object)StringUtil.toLowerCase((String)group), (Object)new TaskNode(externalProjectsView, dataNode));
            }
        }
    }

    protected void update(@NotNull PresentationData presentation2) {
        super.update(presentation2);
        presentation2.setIcon(AllIcons.Nodes.ConfigFolder);
    }

    @Override
    public String getName() {
        return "Tasks";
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.hasChildren();
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode<?>> doBuildChildren() {
        ArrayList<1> result2 = new ArrayList<1>();
        boolean isGroup = this.getExternalProjectsView().getGroupTasks();
        if (isGroup) {
            for (Map.Entry collectionEntry : this.myTasksMap.entrySet()) {
                final String group = (String)ObjectUtils.notNull(collectionEntry.getKey(), (Object)"other");
                ExternalSystemNode<Object> tasksGroupNode = new ExternalSystemNode<Object>(this.getExternalProjectsView(), null, null){

                    protected void update(@NotNull PresentationData presentation2) {
                        super.update(presentation2);
                        presentation2.setIcon(AllIcons.Nodes.ConfigFolder);
                    }

                    @Override
                    public String getName() {
                        return group;
                    }

                    @Override
                    public boolean isVisible() {
                        return super.isVisible() && this.hasChildren();
                    }

                    @Override
                    public int compareTo(@NotNull ExternalSystemNode node) {
                        return "other".equals(group) ? 1 : super.compareTo(node);
                    }
                };
                tasksGroupNode.addAll((Collection)collectionEntry.getValue());
                result2.add(tasksGroupNode);
            }
        } else {
            result2.addAll(this.myTasksMap.values());
        }
        return result2;
    }
}

