/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J'\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001f\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014\u00a2\u0006\u0002\u0010\u0015R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/externalSystem/service/remote/MultiLoaderObjectInputStream;", "Ljava/io/ObjectInputStream;", "inputStream", "Ljava/io/InputStream;", "loaders", "", "Ljava/lang/ClassLoader;", "(Ljava/io/InputStream;Ljava/util/Collection;)V", "getLoaders", "()Ljava/util/Collection;", "doResolveProxyClass", "Ljava/lang/Class;", "interfaces", "", "", "loader", "([Ljava/lang/String;Ljava/lang/ClassLoader;)Ljava/lang/Class;", "resolveClass", "desc", "Ljava/io/ObjectStreamClass;", "resolveProxyClass", "([Ljava/lang/String;)Ljava/lang/Class;", "intellij.platform.externalSystem.impl"})
public final class MultiLoaderObjectInputStream
extends ObjectInputStream {
    @NotNull
    private final Collection<ClassLoader> loaders;

    @Override
    @NotNull
    protected Class<?> resolveClass(@NotNull ObjectStreamClass desc) {
        Iterable $this$forEach$iv = this.loaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassLoader it = (ClassLoader)element$iv;
            boolean bl = false;
            try {
                return Class.forName(desc.getName(), false, it);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return super.resolveClass(desc);
    }

    @Override
    @NotNull
    protected Class<?> resolveProxyClass(@NotNull String[] interfaces) {
        Iterable $this$forEach$iv = this.loaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassLoader it = (ClassLoader)element$iv;
            boolean bl = false;
            try {
                return this.doResolveProxyClass(interfaces, it);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return super.resolveProxyClass(interfaces);
    }

    /*
     * WARNING - void declaration
     */
    private final Class<?> doResolveProxyClass(String[] interfaces, ClassLoader loader) {
        ClassLoader nonPublicLoader = null;
        boolean hasNonPublicInterface = false;
        Class[] classObjs = new Class[interfaces.length];
        int n = 0;
        int n2 = interfaces.length;
        while (n < n2) {
            void i2;
            Class<?> cl = Class.forName(interfaces[i2], false, loader);
            if ((cl.getModifiers() & 1) == 0) {
                if (hasNonPublicInterface) {
                    if (nonPublicLoader != cl.getClassLoader()) {
                        throw (Throwable)new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    nonPublicLoader = cl.getClassLoader();
                    hasNonPublicInterface = true;
                }
            }
            classObjs[i2] = cl;
            ++i2;
        }
        try {
            return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : loader, Arrays.copyOf(classObjs, classObjs.length));
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)new ClassNotFoundException(null, e);
        }
    }

    @NotNull
    public final Collection<ClassLoader> getLoaders() {
        return this.loaders;
    }

    public MultiLoaderObjectInputStream(@NotNull InputStream inputStream, @NotNull Collection<? extends ClassLoader> loaders) {
        super(inputStream);
        this.loaders = loaders;
    }
}

