/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleSdkData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectRootManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u00020\u0006\u00a2\u0006\u0002\b\bH\u0016J6\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/manage/ModuleSdkDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleSdkData;", "Lcom/intellij/openapi/project/Project;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "importData", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "importModuleSdk", "module", "Lcom/intellij/openapi/module/Module;", "sdkData", "useDefaultsIfCan", "", "intellij.platform.externalSystem.impl"})
public final class ModuleSdkDataService
extends AbstractProjectDataService<ModuleSdkData, Project> {
    @NotNull
    public Key<ModuleSdkData> getTargetDataKey() {
        return ModuleSdkData.KEY;
    }

    public void importData(@NotNull Collection<DataNode<ModuleSdkData>> toImport, @Nullable ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport.isEmpty() || projectData2 == null) {
            return;
        }
        boolean useDefaultsIfCan = ExternalSystemApiUtil.isOneToOneMapping((Project)project, (ProjectData)projectData2, (Module[])modelsProvider.getModules());
        for (DataNode<ModuleSdkData> sdkDataNode : toImport) {
            Module module;
            DataNode moduleNode;
            if (sdkDataNode.getParent(ModuleData.class) == null) {
                continue;
            }
            if ((Module)moduleNode.getUserData(AbstractModuleDataService.MODULE_KEY) == null) {
                continue;
            }
            this.importModuleSdk(module, (ModuleSdkData)sdkDataNode.getData(), modelsProvider, useDefaultsIfCan);
        }
    }

    private final void importModuleSdk(Module module, ModuleSdkData sdkData, IdeModifiableModelsProvider modelsProvider, boolean useDefaultsIfCan) {
        Sdk sdk2;
        String moduleSdkName = sdkData.getSdkName();
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        String string = moduleSdkName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            sdk2 = projectJdkTable.findJdk(moduleSdkName);
        } else {
            sdk2 = null;
        }
        Sdk sdk3 = sdk2;
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        if (modifiableRootModel.getSdk() != null) {
            return;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)module.getProject());
        Sdk projectSdk = projectRootManager.getProjectSdk();
        if (useDefaultsIfCan && Intrinsics.areEqual((Object)sdk3, (Object)projectSdk)) {
            modifiableRootModel.inheritSdk();
        } else if (moduleSdkName == null && sdk3 == null) {
            modifiableRootModel.inheritSdk();
        } else if (sdk3 == null) {
            modifiableRootModel.setInvalidSdk(moduleSdkName, ExternalSystemBundle.message((String)"unknown.sdk.type", (Object[])new Object[0]));
        } else {
            modifiableRootModel.setSdk(sdk3);
        }
    }
}

