/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NewEditableErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.EditableNotificationMessageElement;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.MessageCounter;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationMessageElement;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemNotificationManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ExternalSystemNotificationManager.class);
    @NotNull
    private static final Key<Pair<NotificationSource, ProjectSystemId>> CONTENT_ID_KEY = Key.create((String)"CONTENT_ID");
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    @Nullable
    private volatile Project myProject;
    @NotNull
    private final Set<Notification> myNotifications;
    @NotNull
    private final Map<Key, Notification> myUniqueNotifications;
    @NotNull
    private final Set<ProjectSystemId> initializedExternalSystem;
    @NotNull
    private final MessageCounter myMessageCounter;

    public ExternalSystemNotificationManager(@NotNull Project project) {
        this.myProject = project;
        this.myNotifications = ContainerUtil.newConcurrentSet();
        this.myUniqueNotifications = new ConcurrentHashMap<Key, Notification>();
        this.initializedExternalSystem = ContainerUtil.newConcurrentSet();
        this.myMessageCounter = new MessageCounter();
        this.myUpdateQueue = new MergingUpdateQueue(this.getClass() + " updates", 500, true, null, (Disposable)this, null, false);
    }

    @NotNull
    public static ExternalSystemNotificationManager getInstance(@NotNull Project project) {
        return (ExternalSystemNotificationManager)ServiceManager.getService((Project)project, ExternalSystemNotificationManager.class);
    }

    @Nullable
    public NotificationData createNotification(@NotNull String title, @NotNull Throwable error, @NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull DataProvider dataProvider) {
        if (ExternalSystemNotificationManager.isInternalError(error, externalSystemId)) {
            return null;
        }
        String message = ExternalSystemApiUtil.buildErrorMessage((Throwable)error);
        NotificationCategory notificationCategory = NotificationCategory.ERROR;
        String filePath = null;
        Integer line = null;
        Integer column = null;
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)error);
        if (unwrapped instanceof LocationAwareExternalSystemException) {
            LocationAwareExternalSystemException locationAwareExternalSystemException = (LocationAwareExternalSystemException)unwrapped;
            filePath = locationAwareExternalSystemException.getFilePath();
            line = locationAwareExternalSystemException.getLine();
            column = locationAwareExternalSystemException.getColumn();
        }
        NotificationData notificationData = new NotificationData(title, message, notificationCategory, NotificationSource.PROJECT_SYNC, filePath, (Integer)ObjectUtils.notNull((Object)line, (Object)-1), (Integer)ObjectUtils.notNull((Object)column, (Object)-1), false);
        if (unwrapped instanceof BuildIssueException) {
            BuildIssue buildIssue = ((BuildIssueException)((Object)unwrapped)).getBuildIssue();
            for (BuildIssueQuickFix quickFix : buildIssue.getQuickFixes()) {
                notificationData.setListener(quickFix.getId(), (notification, event) -> quickFix.runQuickFix(project, dataProvider));
            }
            return notificationData;
        }
        for (ExternalSystemNotificationExtension extension : (ExternalSystemNotificationExtension[])ExternalSystemNotificationExtension.EP_NAME.getExtensions()) {
            ProjectSystemId targetExternalSystemId = extension.getTargetExternalSystemId();
            if (!externalSystemId.equals((Object)targetExternalSystemId) && !targetExternalSystemId.equals((Object)ProjectSystemId.IDE)) continue;
            extension.customize(notificationData, project, error);
        }
        return notificationData;
    }

    private static boolean isInternalError(@NotNull Throwable error, @NotNull ProjectSystemId externalSystemId) {
        if (RemoteUtil.unwrap((Throwable)error) instanceof BuildIssueException) {
            return false;
        }
        return ExternalSystemNotificationExtension.EP_NAME.extensions().anyMatch(extension -> externalSystemId.equals((Object)extension.getTargetExternalSystemId()) && extension.isInternalError(error));
    }

    public boolean isNotificationActive(@NotNull Key<String> notificationKey) {
        Notification notification = this.myUniqueNotifications.get(notificationKey);
        return notification != null && !notification.isExpired();
    }

    public void showNotification(@NotNull ProjectSystemId externalSystemId, @NotNull NotificationData notificationData) {
        this.showNotification(externalSystemId, notificationData, null);
    }

    public void showNotification(final @NotNull ProjectSystemId externalSystemId, final @NotNull NotificationData notificationData, final @Nullable Key<String> notificationKey) {
        Disposer.register((Disposable)this, (Disposable)notificationData);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            if (notificationData.getNotificationCategory() == NotificationCategory.INFO) {
                LOG.debug(notificationData.getMessage());
            } else {
                LOG.warn(notificationData.getMessage());
            }
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PrintStream out = notificationData.getNotificationCategory() == NotificationCategory.INFO ? System.out : System.err;
            out.println(notificationData.getMessage());
            return;
        }
        if (notificationKey != null && this.isNotificationActive(notificationKey)) {
            return;
        }
        this.myUpdateQueue.queue(new Update(new Object()){

            public void run() {
                if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                    return;
                }
                assert (ExternalSystemNotificationManager.this.myProject != null);
                Project project = ExternalSystemNotificationManager.this.myProject;
                Application app = ApplicationManager.getApplication();
                Runnable action2 = () -> {
                    NotificationGroup group;
                    if (!ExternalSystemNotificationManager.this.initializedExternalSystem.contains(externalSystemId)) {
                        app.runWriteAction(() -> {
                            if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                                return;
                            }
                            ExternalSystemUtil.ensureToolWindowContentInitialized(project, externalSystemId);
                            ExternalSystemNotificationManager.this.initializedExternalSystem.add(externalSystemId);
                        });
                    }
                    if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                        return;
                    }
                    if (notificationData.getBalloonGroup() == null) {
                        ExternalProjectsView externalProjectsView = ExternalProjectsManagerImpl.getInstance(project).getExternalProjectsView(externalSystemId);
                        group = externalProjectsView instanceof ExternalProjectsViewImpl ? ((ExternalProjectsViewImpl)externalProjectsView).getNotificationGroup() : null;
                    } else {
                        NotificationGroup registeredGroup = NotificationGroup.findRegisteredGroup((String)notificationData.getBalloonGroup());
                        NotificationGroup notificationGroup = group = registeredGroup != null ? registeredGroup : NotificationGroup.balloonGroup((String)notificationData.getBalloonGroup());
                    }
                    if (group == null) {
                        return;
                    }
                    Notification notification = group.createNotification(notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType(), notificationData.getListener());
                    if (notificationKey == null) {
                        ExternalSystemNotificationManager.this.myNotifications.add(notification);
                    } else {
                        Notification oldNotification = ExternalSystemNotificationManager.this.myUniqueNotifications.put(notificationKey, notification);
                        if (oldNotification != null) {
                            oldNotification.expire();
                        }
                    }
                    if (notificationData.isBalloonNotification()) {
                        ExternalSystemNotificationManager.this.applyNotification(notification);
                    } else {
                        ExternalSystemNotificationManager.this.addMessage(notification, externalSystemId, notificationData);
                    }
                };
                app.invokeLater(action2, ModalityState.defaultModalityState(), project.getDisposed());
            }
        });
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void clearNotifications(@NotNull NotificationSource notificationSource, @NotNull ProjectSystemId externalSystemId) {
        this.clearNotifications(null, notificationSource, externalSystemId);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void clearNotifications(final @Nullable String groupName, @NotNull NotificationSource notificationSource, @NotNull ProjectSystemId externalSystemId) {
        this.myMessageCounter.remove(groupName, notificationSource, externalSystemId);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final Pair contentIdPair = Pair.create((Object)((Object)notificationSource), (Object)externalSystemId);
        this.myUpdateQueue.queue(new Update(new Object()){

            public void run() {
                if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                    return;
                }
                assert (ExternalSystemNotificationManager.this.myProject != null);
                Project project = ExternalSystemNotificationManager.this.myProject;
                Iterator iterator2 = ExternalSystemNotificationManager.this.myNotifications.iterator();
                while (iterator2.hasNext()) {
                    Notification notification = (Notification)iterator2.next();
                    if (groupName != null && !groupName.equals(notification.getGroupId())) continue;
                    notification.expire();
                    iterator2.remove();
                }
                SmartList toRemove2 = new SmartList();
                ExternalSystemNotificationManager.this.myUniqueNotifications.forEach((arg_0, arg_1) -> 2.lambda$run$0(groupName, (List)toRemove2, arg_0, arg_1));
                toRemove2.forEach(ExternalSystemNotificationManager.this.myUniqueNotifications::remove);
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Messages");
                if (toolWindow == null) {
                    return;
                }
                MessageView messageView = (MessageView)ServiceManager.getService((Project)project, MessageView.class);
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    for (Content content2 : messageView.getContentManager().getContents()) {
                        if (content2.isPinned() || !contentIdPair.equals(content2.getUserData(CONTENT_ID_KEY))) continue;
                        if (groupName == null) {
                            messageView.getContentManager().removeContent(content2, true);
                            continue;
                        }
                        assert (content2.getComponent() instanceof NewEditableErrorTreeViewPanel);
                        NewEditableErrorTreeViewPanel errorTreeView = (NewEditableErrorTreeViewPanel)content2.getComponent();
                        ErrorViewStructure errorViewStructure = errorTreeView.getErrorViewStructure();
                        errorViewStructure.removeGroup(groupName);
                    }
                });
            }

            private static /* synthetic */ void lambda$run$0(String groupName2, List toRemove2, Key key, Notification notification) {
                if (groupName2 == null || groupName2.equals(notification.getGroupId())) {
                    notification.expire();
                    toRemove2.add(key);
                }
            }
        });
    }

    private void addMessage(@NotNull Notification notification, @NotNull ProjectSystemId externalSystemId, @NotNull NotificationData notificationData) {
        int guiColumn;
        VirtualFile virtualFile = notificationData.getFilePath() != null ? ExternalSystemUtil.findLocalFileByPath(notificationData.getFilePath()) : null;
        String groupName = virtualFile != null ? virtualFile.getPresentableUrl() : notificationData.getTitle();
        this.myMessageCounter.increment(groupName, notificationData.getNotificationSource(), notificationData.getNotificationCategory(), externalSystemId);
        int line = notificationData.getLine() - 1;
        int column = notificationData.getColumn() - 1;
        if (virtualFile == null) {
            column = -1;
            line = -1;
        }
        int guiLine = line < 0 ? -1 : line + 1;
        int n = guiColumn = column < 0 ? 0 : column + 1;
        if (this.isDisposedOrNotOpen()) {
            return;
        }
        assert (this.myProject != null);
        Project project = this.myProject;
        Navigatable navigatable = notificationData.getNavigatable() != null ? notificationData.getNavigatable() : (virtualFile != null ? new OpenFileDescriptor(project, virtualFile, line, column) : NonNavigatable.INSTANCE);
        ErrorTreeElementKind kind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)notificationData.getNotificationCategory().getMessageCategory());
        String[] message = notificationData.getMessage().split("\n");
        String exportPrefix = NewErrorTreeViewPanel.createExportPrefix(guiLine);
        String rendererPrefix = NewErrorTreeViewPanel.createRendererPrefix(guiLine, guiColumn);
        UIUtil.invokeLaterIfNeeded(() -> {
            boolean activate2 = notificationData.getNotificationCategory() == NotificationCategory.ERROR || notificationData.getNotificationCategory() == NotificationCategory.WARNING;
            NewErrorTreeViewPanel errorTreeView = this.prepareMessagesView(externalSystemId, notificationData.getNotificationSource(), activate2);
            GroupingElement groupingElement = errorTreeView.getErrorViewStructure().getGroupingElement(groupName, null, virtualFile);
            NotificationMessageElement navigatableMessageElement = notificationData.hasLinks() && !ScreenReader.isActive() ? new EditableNotificationMessageElement(notification, kind, groupingElement, message, navigatable, exportPrefix, rendererPrefix) : new NotificationMessageElement(kind, groupingElement, message, navigatable, exportPrefix, rendererPrefix);
            errorTreeView.getErrorViewStructure().addNavigatableMessage(groupName, navigatableMessageElement);
            errorTreeView.updateTree();
        });
    }

    private void applyNotification(@NotNull Notification notification) {
        if (!this.isDisposedOrNotOpen()) {
            notification.notify(this.myProject);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    @NotNull
    public NewErrorTreeViewPanel prepareMessagesView(@NotNull ProjectSystemId externalSystemId, @NotNull NotificationSource notificationSource, boolean activateView) {
        NewEditableErrorTreeViewPanel errorTreeView;
        ApplicationManager.getApplication().assertIsDispatchThread();
        String contentDisplayName = ExternalSystemNotificationManager.getContentDisplayName(notificationSource, externalSystemId);
        Pair contentIdPair = Pair.create((Object)((Object)notificationSource), (Object)externalSystemId);
        Content targetContent = this.findContent((Pair<NotificationSource, ProjectSystemId>)contentIdPair, contentDisplayName);
        assert (this.myProject != null);
        MessageView messageView = (MessageView)ServiceManager.getService((Project)this.myProject, MessageView.class);
        if (targetContent == null || !contentIdPair.equals(targetContent.getUserData(CONTENT_ID_KEY))) {
            errorTreeView = new NewEditableErrorTreeViewPanel(this.myProject, null, true, true, null);
            targetContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)errorTreeView, contentDisplayName, true);
            targetContent.putUserData(CONTENT_ID_KEY, (Object)contentIdPair);
            messageView.getContentManager().addContent(targetContent);
            Disposer.register((Disposable)targetContent, (Disposable)errorTreeView);
        } else {
            assert (targetContent.getComponent() instanceof NewEditableErrorTreeViewPanel);
            errorTreeView = (NewEditableErrorTreeViewPanel)targetContent.getComponent();
        }
        messageView.getContentManager().setSelectedContent(targetContent);
        ToolWindow tw = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Messages");
        if (activateView && tw != null && !tw.isActive()) {
            tw.activate(null, false);
        }
        return errorTreeView;
    }

    @Nullable
    private Content findContent(@NotNull Pair<NotificationSource, ProjectSystemId> contentIdPair, @NotNull String contentDisplayName) {
        Content targetContent = null;
        assert (this.myProject != null);
        MessageView messageView = (MessageView)ServiceManager.getService((Project)this.myProject, MessageView.class);
        for (Content content2 : messageView.getContentManager().getContents()) {
            if (!contentIdPair.equals(content2.getUserData(CONTENT_ID_KEY)) || !StringUtil.equals((CharSequence)content2.getDisplayName(), (CharSequence)contentDisplayName) || content2.isPinned()) continue;
            targetContent = content2;
        }
        return targetContent;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    @NotNull
    public static String getContentDisplayName(@NotNull NotificationSource notificationSource, @NotNull ProjectSystemId externalSystemId) {
        String contentDisplayName;
        switch (notificationSource) {
            case PROJECT_SYNC: {
                contentDisplayName = ExternalSystemBundle.message((String)"notification.messages.project.sync.tab.name", (Object[])new Object[]{externalSystemId.getReadableName()});
                break;
            }
            case TASK_EXECUTION: {
                contentDisplayName = ExternalSystemBundle.message((String)"notification.messages.task.execution.tab.name", (Object[])new Object[]{externalSystemId.getReadableName()});
                break;
            }
            default: {
                throw new AssertionError((Object)("unsupported notification source found: " + (Object)((Object)notificationSource)));
            }
        }
        return contentDisplayName;
    }

    public void dispose() {
        this.myProject = null;
        this.myNotifications.clear();
        this.myUniqueNotifications.clear();
        this.initializedExternalSystem.clear();
    }

    private boolean isDisposedOrNotOpen() {
        return this.myProject == null || this.myProject.isDisposed() || !this.myProject.isOpen();
    }
}

