/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.errorTreeView.EditableMessageElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.externalSystem.service.notification.NotificationMessageElement;
import com.intellij.pom.Navigatable;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JEditorPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditableNotificationMessageElement
extends NotificationMessageElement
implements EditableMessageElement {
    @NotNull
    private final TreeCellEditor myRightTreeCellEditor;
    @NotNull
    private final Notification myNotification;
    @NotNull
    private final Map<String, String> disabledLinks;

    public EditableNotificationMessageElement(@NotNull Notification notification, @NotNull ErrorTreeElementKind kind, @Nullable GroupingElement parent, String[] message, @NotNull Navigatable navigatable, String exportText, String rendererTextPrefix) {
        super(kind, parent, message, navigatable, exportText, rendererTextPrefix);
        this.myNotification = notification;
        this.disabledLinks = new HashMap<String, String>();
        this.myRightTreeCellEditor = new MyCellEditor();
    }

    public void addDisabledLink(@NotNull String url, @Nullable String text) {
        this.disabledLinks.put(url, text);
    }

    @Override
    @NotNull
    public TreeCellEditor getRightSelfEditor() {
        return this.myRightTreeCellEditor;
    }

    @Override
    public boolean startEditingOnMouseMove() {
        return true;
    }

    public static void disableLink(@NotNull HyperlinkEvent event) {
        EditableNotificationMessageElement.disableLink(event, null);
    }

    private static void disableLink(@NotNull HyperlinkEvent event, @Nullable String linkText) {
        if (event.getSource() instanceof MyJEditorPane) {
            UIUtil.invokeLaterIfNeeded(() -> {
                MyJEditorPane editorPane = (MyJEditorPane)event.getSource();
                editorPane.myElement.addDisabledLink(event.getDescription(), linkText);
                editorPane.myElement.updateStyle(editorPane, null, null, true, false);
            });
        }
    }

    @Override
    protected void updateStyle(@NotNull JEditorPane editorPane, @Nullable JTree tree, Object value2, boolean selected2, boolean hasFocus) {
        super.updateStyle(editorPane, tree, value2, selected2, hasFocus);
        HTMLDocument htmlDocument = (HTMLDocument)editorPane.getDocument();
        Style linkStyle = htmlDocument.getStyleSheet().getStyle("linkStyle");
        StyleConstants.setForeground(linkStyle, IdeTooltipManager.getInstance().getLinkForeground(false));
        StyleConstants.setItalic(linkStyle, true);
        HTMLDocument.Iterator iterator2 = htmlDocument.getIterator(HTML.Tag.A);
        while (iterator2.isValid()) {
            boolean disabledLink = false;
            AttributeSet attributes = iterator2.getAttributes();
            if (attributes instanceof SimpleAttributeSet) {
                Object attribute = attributes.getAttribute(HTML.Attribute.HREF);
                if (attribute instanceof String && this.disabledLinks.containsKey(attribute)) {
                    disabledLink = true;
                    ((SimpleAttributeSet)attributes).removeAttribute(HTML.Attribute.HREF);
                }
                if (attribute == null) {
                    disabledLink = true;
                }
            }
            if (!disabledLink) {
                htmlDocument.setCharacterAttributes(iterator2.getStartOffset(), iterator2.getEndOffset() - iterator2.getStartOffset(), linkStyle, false);
            }
            iterator2.next();
        }
    }

    private class MyCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final JEditorPane editorComponent;
        @Nullable
        private JTree myTree;

        private MyCellEditor() {
            this.editorComponent = EditableNotificationMessageElement.this.installJep(new MyJEditorPane(EditableNotificationMessageElement.this));
            ActivatedHyperlinkListener hyperlinkListener = new ActivatedHyperlinkListener();
            this.editorComponent.addHyperlinkListener(hyperlinkListener);
            this.editorComponent.addMouseListener((MouseListener)new PopupHandler(){

                public void invokePopup(Component comp, int x, int y) {
                    if (MyCellEditor.this.myTree == null) {
                        return;
                    }
                    TreePath path = MyCellEditor.this.myTree.getLeadSelectionPath();
                    if (path == null) {
                        return;
                    }
                    DefaultActionGroup group = new DefaultActionGroup();
                    group.add(ActionManager.getInstance().getAction("EditSource"));
                    group.add(ActionManager.getInstance().getAction("$Copy"));
                    ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("CompilerMessagesPopup", (ActionGroup)group);
                    menu.getComponent().show(comp, x, y);
                }
            });
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row) {
            this.myTree = tree;
            EditableNotificationMessageElement.this.updateStyle(this.editorComponent, tree, value2, selected2, false);
            return this.editorComponent;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        private class ActivatedHyperlinkListener
        implements HyperlinkListener {
            private ActivatedHyperlinkListener() {
            }

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                NotificationListener notificationListener;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (notificationListener = EditableNotificationMessageElement.this.myNotification.getListener()) != null) {
                    notificationListener.hyperlinkUpdate(EditableNotificationMessageElement.this.myNotification, e);
                }
            }
        }
    }

    private static class MyJEditorPane
    extends JEditorPane {
        @NotNull
        private final EditableNotificationMessageElement myElement;

        MyJEditorPane(@NotNull EditableNotificationMessageElement element2) {
            this.myElement = element2;
        }
    }
}

