/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution.cmd;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.externalSystem.service.execution.cmd.ParametersListLexer;
import com.intellij.util.TextFieldCompletionProvider;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;

public abstract class CommandLineCompletionProvider
extends TextFieldCompletionProvider {
    private final Options myOptions;

    public CommandLineCompletionProvider(Options options2) {
        super(true);
        this.myOptions = options2;
    }

    @Override
    @NotNull
    protected String getPrefix(@NotNull String currentTextPrefix) {
        ParametersListLexer lexer = new ParametersListLexer(currentTextPrefix);
        while (lexer.nextToken()) {
            if (lexer.getTokenEnd() != currentTextPrefix.length()) continue;
            return lexer.getCurrentToken();
        }
        return "";
    }

    protected LookupElement createLookupElement(@NotNull Option option2, @NotNull String text) {
        LookupElementBuilder res2 = LookupElementBuilder.create((String)text);
        if (option2.getDescription() != null) {
            return TailTypeDecorator.withTail((LookupElement)res2.withTypeText(option2.getDescription(), true), (TailType)TailType.INSERT_SPACE);
        }
        return res2;
    }

    protected abstract void addArgumentVariants(@NotNull CompletionResultSet var1);

    @Override
    protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        ParametersListLexer lexer = new ParametersListLexer(text);
        int argCount = 0;
        while (lexer.nextToken() && offset >= lexer.getTokenStart()) {
            Option option22;
            if (offset <= lexer.getTokenEnd()) {
                if (argCount == 0) {
                    if (prefix.startsWith("--")) {
                        for (Option option22 : this.myOptions.getOptions()) {
                            if (option22.getLongOpt() == null) continue;
                            result2.addElement(this.createLookupElement(option22, "--" + option22.getLongOpt()));
                        }
                    } else if (prefix.startsWith("-")) {
                        for (Option option22 : this.myOptions.getOptions()) {
                            if (option22.getOpt() == null) continue;
                            result2.addElement(this.createLookupElement(option22, "-" + option22.getOpt()));
                        }
                    } else {
                        this.addArgumentVariants(result2);
                    }
                }
                return;
            }
            if (argCount > 0) {
                --argCount;
                continue;
            }
            String token = lexer.getCurrentToken();
            if (!token.startsWith("-") || (option22 = this.myOptions.getOption(token)) == null) continue;
            int optionArgCount = option22.getArgs();
            if (optionArgCount == -2) {
                argCount = Integer.MAX_VALUE;
                continue;
            }
            if (optionArgCount == -1) continue;
            argCount = optionArgCount;
        }
        if (argCount > 0) {
            return;
        }
        this.addArgumentVariants(result2);
    }
}

