/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildViewManager;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SearchScopeProvidingRunProfile;
import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationEditor;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationExtension;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemRunConfiguration
extends LocatableConfigurationBase
implements SearchScopeProvidingRunProfile {
    static final ExtensionPointName<ExternalSystemRunConfigurationExtension> EP_NAME = ExtensionPointName.create((String)"com.intellij.externalSystem.runConfigurationExtension");
    public static final Key<InputStream> RUN_INPUT_KEY = Key.create((String)"RUN_INPUT_KEY");
    public static final Key<Class<? extends BuildProgressListener>> PROGRESS_LISTENER_KEY = Key.create((String)"PROGRESS_LISTENER_KEY");
    static final Logger LOG = Logger.getInstance(ExternalSystemRunConfiguration.class);
    private ExternalSystemTaskExecutionSettings mySettings = new ExternalSystemTaskExecutionSettings();
    static final boolean DISABLE_FORK_DEBUGGER = Boolean.getBoolean("external.system.disable.fork.debugger");

    public ExternalSystemRunConfiguration(@NotNull ProjectSystemId externalSystemId, Project project, ConfigurationFactory factory2, String name) {
        super(project, factory2, name);
        this.mySettings.setExternalSystemIdString(externalSystemId.getId());
    }

    public String suggestedName() {
        return AbstractExternalSystemTaskConfigurationType.generateName(this.getProject(), this.mySettings);
    }

    public ExternalSystemRunConfiguration clone() {
        Element element2 = new Element("toClone");
        try {
            this.writeExternal(element2);
            RunConfiguration configuration = this.getFactory().createTemplateConfiguration(this.getProject());
            configuration.setName(this.getName());
            configuration.readExternal(element2);
            return (ExternalSystemRunConfiguration)configuration;
        }
        catch (InvalidDataException | WriteExternalException e) {
            LOG.error(e);
            return null;
        }
    }

    public void readExternal(@NotNull Element element2) throws InvalidDataException {
        super.readExternal(element2);
        Element e = element2.getChild("ExternalSystemSettings");
        if (e != null) {
            this.mySettings = (ExternalSystemTaskExecutionSettings)XmlSerializer.deserialize((Element)e, ExternalSystemTaskExecutionSettings.class);
        }
        EP_NAME.forEachExtensionSafe(extension -> extension.readExternal(this, element2));
    }

    public void writeExternal(@NotNull Element element2) throws WriteExternalException {
        super.writeExternal(element2);
        element2.addContent(XmlSerializer.serialize((Object)this.mySettings, (SerializationFilter)new SerializationFilter(){

            public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
                switch (accessor.getName()) {
                    case "passParentEnvs": {
                        return !ExternalSystemRunConfiguration.this.mySettings.isPassParentEnvs();
                    }
                    case "env": {
                        return !ExternalSystemRunConfiguration.this.mySettings.getEnv().isEmpty();
                    }
                }
                return true;
            }
        }));
        EP_NAME.forEachExtensionSafe(extension -> extension.writeExternal(this, element2));
    }

    @NotNull
    public ExternalSystemTaskExecutionSettings getSettings() {
        return this.mySettings;
    }

    @NotNull
    public SettingsEditor<ExternalSystemRunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new ExternalSystemRunConfigurationEditor(this.getProject(), this.mySettings.getExternalSystemId()));
        EP_NAME.forEachExtensionSafe(extension -> extension.appendEditors(this, (SettingsEditorGroup<ExternalSystemRunConfiguration>)group));
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), new LogConfigurationPanel());
        return group;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        String debugExecutorId = "Debug";
        ExternalSystemRunnableState runnableState = new ExternalSystemRunnableState(this.mySettings, this.getProject(), debugExecutorId.equals(executor.getId()), this, env);
        this.copyUserDataTo(runnableState);
        return runnableState;
    }

    @Nullable
    public GlobalSearchScope getSearchScope() {
        Module module;
        VirtualFile file2;
        GlobalSearchScope scope = null;
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.mySettings.getExternalSystemId());
        if (manager != null) {
            scope = manager.getSearchScope(this.getProject(), this.mySettings);
        }
        if (scope == null && (file2 = VfsUtil.findFileByIoFile((File)new File(this.mySettings.getExternalProjectPath()), (boolean)false)) != null && (module = DirectoryIndex.getInstance(this.getProject()).getInfoForFile(file2).getModule()) != null) {
            scope = GlobalSearchScopes.executionScope(Collections.singleton(module));
        }
        return scope;
    }

    static void foldGreetingOrFarewell(@Nullable ExecutionConsole consoleView, String text, boolean isGreeting) {
        DuplexConsoleView duplexConsoleView;
        int limit = 100;
        if (text.length() < limit) {
            return;
        }
        ConsoleViewImpl consoleViewImpl = consoleView instanceof ConsoleViewImpl ? (ConsoleViewImpl)consoleView : (consoleView instanceof DuplexConsoleView ? ((duplexConsoleView = (DuplexConsoleView)consoleView).getPrimaryConsoleView() instanceof ConsoleViewImpl ? (ConsoleViewImpl)duplexConsoleView.getPrimaryConsoleView() : (duplexConsoleView.getSecondaryConsoleView() instanceof ConsoleViewImpl ? (ConsoleViewImpl)duplexConsoleView.getSecondaryConsoleView() : null)) : null);
        if (consoleViewImpl != null) {
            consoleViewImpl.performWhenNoDeferredOutput(() -> {
                int line;
                if (!ApplicationManager.getApplication().isDispatchThread()) {
                    return;
                }
                Document document = consoleViewImpl.getEditor().getDocument();
                int n = line = isGreeting ? 0 : document.getLineCount() - 2;
                if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)document.getLineStartOffset(line), (CharSequence)text)) {
                    FoldingModel foldingModel = consoleViewImpl.getEditor().getFoldingModel();
                    foldingModel.runBatchFoldingOperation(() -> {
                        FoldRegion region = foldingModel.addFoldRegion(document.getLineStartOffset(line), document.getLineEndOffset(line) + 1, StringUtil.trimLog((String)text, (int)limit));
                        if (region != null) {
                            region.setExpanded(false);
                        }
                    });
                }
            });
        }
    }

    static class MyTaskRerunAction
    extends FakeRerunAction {
        private final BuildProgressListener myProgressListener;
        private final RunContentDescriptor myContentDescriptor;
        private final ExecutionEnvironment myEnvironment;

        MyTaskRerunAction(BuildProgressListener progressListener, ExecutionEnvironment environment, RunContentDescriptor contentDescriptor) {
            this.myProgressListener = progressListener;
            this.myContentDescriptor = contentDescriptor;
            this.myEnvironment = environment;
        }

        @Override
        public void update(@NotNull AnActionEvent event) {
            Presentation presentation2 = event.getPresentation();
            ExecutionEnvironment environment = this.getEnvironment(event);
            if (environment != null) {
                presentation2.setText(ExecutionBundle.messagePointer((String)"rerun.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)environment.getRunProfile().getName())}));
                Icon icon2 = ExecutionManagerImpl.isProcessRunning(this.getDescriptor(event)) ? AllIcons.Actions.Restart : (this.myProgressListener instanceof BuildViewManager ? AllIcons.Actions.Compile : environment.getExecutor().getIcon());
                presentation2.setIcon(icon2);
                presentation2.setEnabled(this.isEnabled(event));
                return;
            }
            presentation2.setEnabled(false);
        }

        @Override
        @Nullable
        protected RunContentDescriptor getDescriptor(AnActionEvent event) {
            return this.myContentDescriptor != null ? this.myContentDescriptor : super.getDescriptor(event);
        }

        @Override
        protected ExecutionEnvironment getEnvironment(@NotNull AnActionEvent event) {
            return this.myEnvironment;
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static class MyRunnableState
    extends ExternalSystemRunnableState {
        public MyRunnableState(@NotNull ExternalSystemTaskExecutionSettings settings, @NotNull Project project, boolean debug, @NotNull ExternalSystemRunConfiguration configuration, @NotNull ExecutionEnvironment env) {
            super(settings, project, debug, configuration, env);
        }
    }
}

