/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.BeforeRunTask;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemBeforeRunTask
extends BeforeRunTask<ExternalSystemBeforeRunTask> {
    @NotNull
    private final ExternalSystemTaskExecutionSettings myTaskExecutionSettings;

    public ExternalSystemBeforeRunTask(@NotNull Key<ExternalSystemBeforeRunTask> providerId, @NotNull ProjectSystemId systemId) {
        super(providerId);
        this.myTaskExecutionSettings = new ExternalSystemTaskExecutionSettings();
        this.myTaskExecutionSettings.setExternalSystemIdString(systemId.getId());
    }

    private ExternalSystemBeforeRunTask(@NotNull ExternalSystemBeforeRunTask source) {
        super(source.myProviderId);
        this.myTaskExecutionSettings = source.myTaskExecutionSettings.clone();
    }

    @NotNull
    public ExternalSystemTaskExecutionSettings getTaskExecutionSettings() {
        return this.myTaskExecutionSettings;
    }

    public void writeExternal(@NotNull Element element2) {
        super.writeExternal(element2);
        element2.setAttribute("tasks", StringUtil.join((Collection)this.myTaskExecutionSettings.getTaskNames(), (String)" "));
        if (this.myTaskExecutionSettings.getExternalProjectPath() != null) {
            element2.setAttribute("externalProjectPath", this.myTaskExecutionSettings.getExternalProjectPath());
        }
        if (this.myTaskExecutionSettings.getVmOptions() != null) {
            element2.setAttribute("vmOptions", this.myTaskExecutionSettings.getVmOptions());
        }
        if (this.myTaskExecutionSettings.getScriptParameters() != null) {
            element2.setAttribute("scriptParameters", this.myTaskExecutionSettings.getScriptParameters());
        }
    }

    public void readExternal(@NotNull Element element2) {
        super.readExternal(element2);
        this.myTaskExecutionSettings.setTaskNames(StringUtil.split((String)StringUtil.notNullize((String)element2.getAttributeValue("tasks")), (String)" "));
        this.myTaskExecutionSettings.setExternalProjectPath(element2.getAttributeValue("externalProjectPath"));
        this.myTaskExecutionSettings.setVmOptions(element2.getAttributeValue("vmOptions"));
        this.myTaskExecutionSettings.setScriptParameters(element2.getAttributeValue("scriptParameters"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalSystemBeforeRunTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalSystemBeforeRunTask task2 = (ExternalSystemBeforeRunTask)((Object)o);
        return this.myTaskExecutionSettings.equals((Object)task2.myTaskExecutionSettings);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myTaskExecutionSettings.hashCode();
        return result2;
    }

    public BeforeRunTask clone() {
        return new ExternalSystemBeforeRunTask(this);
    }
}

