/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ShowExternalSystemSettingsAction
extends ExternalSystemAction {
    public ShowExternalSystemSettingsAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.messagePointer((String)"action.open.settings.text", (Object[])new Object[]{"External"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.messagePointer((String)"action.open.settings.description", (Object[])new Object[]{"external"}));
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        ProjectSystemId systemId = this.getSystemId(e);
        if (systemId == null) {
            return false;
        }
        e.getPresentation().setText(ExternalSystemBundle.messagePointer((String)"action.open.settings.text", (Object[])new Object[]{systemId.getReadableName()}));
        e.getPresentation().setDescription(ExternalSystemBundle.messagePointer((String)"action.open.settings.description", (Object[])new Object[]{systemId.getReadableName()}));
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ProjectSystemId systemId = this.getSystemId(e);
        if (systemId != null) {
            Project project = this.getProject(e);
            ExternalSystemActionsCollector.trigger(project, systemId, this, e);
            ShowExternalSystemSettingsAction.showSettingsFor(project, systemId);
        }
    }

    protected static void showSettingsFor(Project project, @NotNull ProjectSystemId systemId) {
        ShowSettingsUtil.getInstance().showSettingsDialog(project, systemId.getReadableName());
    }
}

