/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.module.Module;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalSystemActionUtil {
    public static void executeAction(String actionId, InputEvent e) {
        ExternalSystemActionUtil.executeAction(actionId, "", e);
    }

    public static void executeAction(String actionId, @NotNull String place, InputEvent e) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action2 = actionManager.getAction(actionId);
        if (action2 != null) {
            Presentation presentation2 = new Presentation();
            AnActionEvent event = new AnActionEvent(e, DataManager.getInstance().getDataContext(e.getComponent()), place, presentation2, actionManager, 0);
            action2.update(event);
            if (presentation2.isEnabled()) {
                action2.actionPerformed(event);
            }
        }
    }

    @Nullable
    public static Module getModule(DataContext context) {
        Module module = (Module)LangDataKeys.MODULE.getData(context);
        return module != null ? module : (Module)LangDataKeys.MODULE_CONTEXT.getData(context);
    }

    public static <E> void setElements(ElementsChooser<E> chooser, Collection<? extends E> all, Collection<E> selected2, Comparator<? super E> comparator2) {
        List selection = chooser.getSelectedElements();
        chooser.clear();
        TreeSet<? extends E> sorted = new TreeSet<E>(comparator2);
        sorted.addAll(all);
        for (Object e : sorted) {
            chooser.addElement(e, selected2.contains(e));
        }
        chooser.selectElements(selection);
    }

    public static void installCheckboxRenderer(final SimpleTree tree, final CheckboxHandler handler2) {
        final JCheckBox checkbox = new JCheckBox();
        final JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)checkbox, "West");
        final TreeCellRenderer baseRenderer = tree.getCellRenderer();
        tree.setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component baseComponent = baseRenderer.getTreeCellRendererComponent(tree, value2, selected2, expanded, leaf, row, hasFocus);
                Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
                if (!handler2.isVisible(userObject)) {
                    return baseComponent;
                }
                Color foreground = UIUtil.getTreeForeground((boolean)selected2, (boolean)hasFocus);
                Color background = UIUtil.getTreeBackground((boolean)selected2, (boolean)hasFocus);
                panel2.add(baseComponent, "Center");
                panel2.setBackground(background);
                panel2.setForeground(foreground);
                CheckBoxState state = handler2.getState(userObject);
                checkbox.setSelected(state != CheckBoxState.UNCHECKED);
                checkbox.setEnabled(state != CheckBoxState.PARTIAL);
                checkbox.setBackground(background);
                checkbox.setForeground(foreground);
                return panel2;
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = tree.getRowForLocation(e.getX(), e.getY());
                if (row >= 0) {
                    TreePath path = tree.getPathForRow(row);
                    if (!ExternalSystemActionUtil.isCheckboxEnabledFor(path, handler2)) {
                        return;
                    }
                    Rectangle checkBounds = checkbox.getBounds();
                    checkBounds.setLocation(tree.getRowBounds(row).getLocation());
                    if (checkBounds.contains(e.getPoint())) {
                        handler2.toggle(path, e);
                        e.consume();
                        tree.setSelectionRow(row);
                    }
                }
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TreePath[] treePaths;
                if (e.getKeyCode() == 32 && (treePaths = tree.getSelectionPaths()) != null) {
                    for (TreePath treePath : treePaths) {
                        if (!ExternalSystemActionUtil.isCheckboxEnabledFor(treePath, handler2)) continue;
                        handler2.toggle(treePath, e);
                    }
                    e.consume();
                }
            }
        });
    }

    private static boolean isCheckboxEnabledFor(TreePath path, CheckboxHandler handler2) {
        Object userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        return handler2.isVisible(userObject);
    }

    @NotNull
    public static ExternalTaskExecutionInfo buildTaskInfo(@NotNull TaskData task2) {
        ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
        settings.setExternalProjectPath(task2.getLinkedExternalProjectPath());
        settings.setTaskNames(Collections.singletonList(task2.getName()));
        settings.setTaskDescriptions(Collections.singletonList(task2.getDescription()));
        settings.setExternalSystemIdString(task2.getOwner().toString());
        return new ExternalTaskExecutionInfo(settings, "Run");
    }

    public static enum CheckBoxState {
        CHECKED,
        UNCHECKED,
        PARTIAL;

    }

    public static interface CheckboxHandler {
        public void toggle(TreePath var1, InputEvent var2);

        public boolean isVisible(Object var1);

        public CheckBoxState getState(Object var1);
    }
}

