/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import org.jetbrains.annotations.NotNull;

public class CopyAsRichTextAction
extends DumbAwareAction {
    public CopyAsRichTextAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation p = e.getPresentation();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        p.setVisible(!RichCopySettings.getInstance().isEnabled() && (e.isFromActionToolbar() || editor != null && editor.getSelectionModel().hasSelection(true)) && (editor == null || CopyAsRichTextAction.isRichCopyPossible(editor)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        RichCopySettings settings = RichCopySettings.getInstance();
        boolean savedValue = settings.isEnabled();
        try {
            settings.setEnabled(true);
            ActionManager.getInstance().getAction("EditorCopy").actionPerformed(e);
        }
        finally {
            settings.setEnabled(savedValue);
        }
    }

    static boolean isRichCopyPossible(@NotNull Editor editor) {
        return FileDocumentManager.getInstance().getFile(editor.getDocument()) != null;
    }
}

