/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.util.Key;
import com.intellij.util.DocumentUtil;
import java.awt.Point;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class InlineInlayImpl<R extends EditorCustomElementRenderer>
extends InlayImpl<R, InlineInlayImpl<?>> {
    private static final Key<Integer> ORDER_BEFORE_DISPOSAL = Key.create((String)"inlay.order.before.disposal");

    InlineInlayImpl(@NotNull EditorImpl editor, int offset, boolean relatesToPrecedingText, @NotNull R renderer) {
        super(editor, offset, relatesToPrecedingText, renderer);
    }

    @Override
    RangeMarkerTree<InlineInlayImpl<?>> getTree() {
        return this.myEditor.getInlayModel().myInlineElementsTree;
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        this.myEditor.getInlayModel().myPutMergedIntervalsAtBeginning = this.intervalStart() == e.getOffset();
        super.changedUpdateImpl(e);
        if (this.isValid() && DocumentUtil.isInsideSurrogatePair(this.getDocument(), this.intervalStart())) {
            this.invalidate(e);
        }
    }

    @Override
    protected void onReTarget(@NotNull DocumentEvent e) {
        InlayModelImpl inlayModel = this.myEditor.getInlayModel();
        boolean bl = inlayModel.myPutMergedIntervalsAtBeginning = this.intervalStart() == e.getMoveOffset() + e.getNewLength();
        if (DocumentUtil.isInsideSurrogatePair(this.getDocument(), this.getOffset())) {
            inlayModel.myMoveInProgress = true;
            try {
                this.invalidate("moved inside surrogate pair on retarget");
            }
            finally {
                inlayModel.myMoveInProgress = false;
            }
        }
    }

    @Override
    public void dispose() {
        if (this.isValid()) {
            int offset = this.getOffset();
            List<Inlay<?>> inlays = this.myEditor.getInlayModel().getInlineElementsInRange(offset, offset);
            this.putUserData(ORDER_BEFORE_DISPOSAL, inlays.indexOf(this));
        }
        super.dispose();
    }

    @Override
    void doUpdate() {
        this.myWidthInPixels = this.myRenderer.calcWidthInPixels((Inlay)this);
        if (this.myWidthInPixels <= 0) {
            throw PluginException.createByClass((String)("Positive width should be defined for an inline element by " + this.myRenderer), null, this.myRenderer.getClass());
        }
    }

    @NotNull
    public Inlay.Placement getPlacement() {
        return Inlay.Placement.INLINE;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        int offset = this.getOffset();
        VisualPosition pos = this.myEditor.offsetToVisualPosition(offset);
        List<Inlay<?>> inlays = this.myEditor.getInlayModel().getInlineElementsInRange(offset, offset);
        int order = inlays.indexOf(this);
        return new VisualPosition(pos.line, pos.column + order, true);
    }

    @Override
    Point getPosition() {
        VisualPosition pos = this.getVisualPosition();
        return this.myEditor.visualPositionToXY(pos);
    }

    public int getHeightInPixels() {
        return this.myEditor.getLineHeight();
    }

    int getOrder() {
        Integer value2 = (Integer)this.getUserData(ORDER_BEFORE_DISPOSAL);
        return value2 == null ? -1 : value2;
    }

    @Override
    public String toString() {
        return "[Inline inlay, offset=" + this.getOffset() + ", width=" + this.myWidthInPixels + ", renderer=" + this.myRenderer + "]";
    }
}

