/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.AfterLineEndInlayImpl;
import com.intellij.openapi.editor.impl.BlockInlayImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorLocation;
import com.intellij.openapi.editor.impl.HardReferencingRangeMarkerTree;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.InlineInlayImpl;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.MarkerTreeWithPartialSums;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.util.DocumentEventUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InlayModelImpl
implements InlayModel,
PrioritizedDocumentListener,
Disposable,
Dumpable {
    private static final Logger LOG = Logger.getInstance(InlayModelImpl.class);
    private static final Comparator<Inlay> INLINE_ELEMENTS_COMPARATOR = Comparator.comparingInt(i2 -> i2.getOffset()).thenComparing(i2 -> i2.isRelatedToPrecedingText());
    private static final Comparator<BlockInlayImpl> BLOCK_ELEMENTS_PRIORITY_COMPARATOR = Comparator.comparingInt(i2 -> -i2.myPriority);
    private static final Comparator<BlockInlayImpl> BLOCK_ELEMENTS_COMPARATOR = Comparator.comparing(i2 -> i2.getPlacement()).thenComparing(i2 -> i2.getPlacement() == Inlay.Placement.ABOVE_LINE ? i2.myPriority : -i2.myPriority);
    private static final Comparator<AfterLineEndInlayImpl> AFTER_LINE_END_ELEMENTS_OFFSET_COMPARATOR = Comparator.comparingInt(i2 -> i2.getOffset()).thenComparingInt(i2 -> i2.myOrder);
    private static final Comparator<AfterLineEndInlayImpl> AFTER_LINE_END_ELEMENTS_COMPARATOR = Comparator.comparingInt(i2 -> i2.myOrder);
    private static final Processor<InlayImpl> UPDATE_PROCESSOR = inlay -> {
        inlay.update();
        return true;
    };
    private final EditorImpl myEditor;
    private final EventDispatcher<InlayModel.Listener> myDispatcher = EventDispatcher.create(InlayModel.Listener.class);
    private final List<InlayImpl> myInlaysInvalidatedOnMove = new ArrayList<InlayImpl>();
    final RangeMarkerTree<InlineInlayImpl<?>> myInlineElementsTree;
    final MarkerTreeWithPartialSums<BlockInlayImpl<?>> myBlockElementsTree;
    final RangeMarkerTree<AfterLineEndInlayImpl<?>> myAfterLineEndElementsTree;
    boolean myMoveInProgress;
    boolean myPutMergedIntervalsAtBeginning;
    private boolean myConsiderCaretPositionOnDocumentUpdates = true;
    private List<Inlay<?>> myInlaysAtCaret;
    private boolean myInBatchMode;

    InlayModelImpl(@NotNull EditorImpl editor) {
        this.myEditor = editor;
        this.myInlineElementsTree = new InlineElementsTree(editor.getDocument());
        this.myBlockElementsTree = new BlockElementsTree(editor.getDocument());
        this.myAfterLineEndElementsTree = new AfterLineEndElementTree(editor.getDocument());
        this.myEditor.getDocument().addDocumentListener(this, this);
    }

    @Override
    public int getPriority() {
        return 150;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        List<Inlay<?>> inlays;
        int inlayCount;
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        if (this.myInBatchMode) {
            LOG.error("Document shouldn't be changed during batch inlay operation");
        }
        int offset = event.getOffset();
        if (this.myConsiderCaretPositionOnDocumentUpdates && event.getOldLength() == 0 && offset == this.myEditor.getCaretModel().getOffset() && (inlayCount = (inlays = this.getInlineElementsInRange(offset, offset)).size()) > 0) {
            VisualPosition inlaysStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
            VisualPosition caretPosition = this.myEditor.getCaretModel().getVisualPosition();
            if (inlaysStartPosition.line == caretPosition.line && caretPosition.column >= inlaysStartPosition.column && caretPosition.column <= inlaysStartPosition.column + inlayCount) {
                this.myInlaysAtCaret = inlays;
                for (int i2 = 0; i2 < inlayCount; ++i2) {
                    ((InlayImpl)inlays.get(i2)).setStickingToRight(i2 >= caretPosition.column - inlaysStartPosition.column);
                }
            }
        }
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (this.myInlaysAtCaret != null) {
            for (Inlay<?> inlay : this.myInlaysAtCaret) {
                ((InlayImpl)inlay).setStickingToRight(inlay.isRelatedToPrecedingText());
            }
            this.myInlaysAtCaret = null;
        }
        if (DocumentEventUtil.isMoveInsertion(event)) {
            for (InlayImpl inlayImpl : this.myInlaysInvalidatedOnMove) {
                this.notifyRemoved(inlayImpl);
            }
            this.myInlaysInvalidatedOnMove.clear();
        }
    }

    void reinitSettings() {
        this.myInlineElementsTree.processAll(UPDATE_PROCESSOR);
        this.myBlockElementsTree.processAll(UPDATE_PROCESSOR);
        this.myAfterLineEndElementsTree.processAll(UPDATE_PROCESSOR);
    }

    public void dispose() {
        this.myInlineElementsTree.dispose(this.myEditor.getDocument());
        this.myBlockElementsTree.dispose(this.myEditor.getDocument());
        this.myAfterLineEndElementsTree.dispose(this.myEditor.getDocument());
    }

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addInlineElement(int offset, boolean relatesToPrecedingText, @NotNull T renderer) {
        EditorImpl.assertIsDispatchThread();
        DocumentEx document = this.myEditor.getDocument();
        if (DocumentUtil.isInsideSurrogatePair(document, offset)) {
            return null;
        }
        offset = Math.max(0, Math.min(document.getTextLength(), offset));
        InlineInlayImpl<T> inlay = new InlineInlayImpl<T>(this.myEditor, offset, relatesToPrecedingText, renderer);
        this.notifyAdded(inlay);
        return inlay;
    }

    @NotNull
    public <T extends EditorCustomElementRenderer> Inlay<T> addBlockElement(int offset, boolean relatesToPrecedingText, boolean showAbove, int priority, @NotNull T renderer) {
        EditorImpl.assertIsDispatchThread();
        offset = Math.max(0, Math.min(this.myEditor.getDocument().getTextLength(), offset));
        BlockInlayImpl<T> inlay = new BlockInlayImpl<T>(this.myEditor, offset, relatesToPrecedingText, showAbove, priority, renderer);
        this.notifyAdded(inlay);
        return inlay;
    }

    @NotNull
    public <T extends EditorCustomElementRenderer> Inlay<T> addAfterLineEndElement(int offset, boolean relatesToPrecedingText, @NotNull T renderer) {
        EditorImpl.assertIsDispatchThread();
        DocumentEx document = this.myEditor.getDocument();
        offset = Math.max(0, Math.min(document.getTextLength(), offset));
        AfterLineEndInlayImpl<T> inlay = new AfterLineEndInlayImpl<T>(this.myEditor, offset, relatesToPrecedingText, renderer);
        this.notifyAdded(inlay);
        return inlay;
    }

    @NotNull
    public List<Inlay<?>> getInlineElementsInRange(int startOffset, int endOffset) {
        return InlayModelImpl.getElementsInRange(this.myInlineElementsTree, startOffset, endOffset, inlay -> true, INLINE_ELEMENTS_COMPARATOR);
    }

    @NotNull
    public <T> List<Inlay<? extends T>> getInlineElementsInRange(int startOffset, int endOffset, @NotNull Class<T> type) {
        List<Inlay<? extends T>> range2 = InlayModelImpl.getElementsInRange(this.myInlineElementsTree, startOffset, endOffset, inlay -> type.isInstance(inlay.myRenderer), INLINE_ELEMENTS_COMPARATOR);
        return range2;
    }

    @NotNull
    public List<Inlay<?>> getBlockElementsInRange(int startOffset, int endOffset) {
        List<Inlay<?>> range2 = InlayModelImpl.getElementsInRange(this.myBlockElementsTree, startOffset, endOffset, inlay -> true, BLOCK_ELEMENTS_PRIORITY_COMPARATOR);
        return range2;
    }

    @NotNull
    public <T> List<Inlay<? extends T>> getBlockElementsInRange(int startOffset, int endOffset, @NotNull Class<T> type) {
        List<Inlay<? extends T>> range2 = InlayModelImpl.getElementsInRange(this.myBlockElementsTree, startOffset, endOffset, inlay -> type.isInstance(inlay.myRenderer), BLOCK_ELEMENTS_PRIORITY_COMPARATOR);
        return range2;
    }

    private static <T extends Inlay<?>> List<T> getElementsInRange(@NotNull IntervalTreeImpl<? extends T> tree, int startOffset, int endOffset, Predicate<? super T> predicate, Comparator<? super T> comparator2) {
        ArrayList result2 = new ArrayList();
        tree.processOverlappingWith(startOffset, endOffset, inlay -> {
            if (predicate.test(inlay)) {
                result2.add((Object)inlay);
            }
            return true;
        });
        result2.sort(comparator2);
        return result2;
    }

    @NotNull
    public List<Inlay<?>> getBlockElementsForVisualLine(int visualLine, boolean above) {
        int visibleLineCount = this.myEditor.getVisibleLineCount();
        if (visualLine < 0 || visualLine >= visibleLineCount || this.myBlockElementsTree.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList result2 = new ArrayList();
        int startOffset = this.myEditor.visualLineStartOffset(visualLine);
        int endOffset = visualLine == visibleLineCount - 1 ? this.myEditor.getDocument().getTextLength() : this.myEditor.visualLineStartOffset(visualLine + 1) - 1;
        this.myBlockElementsTree.processOverlappingWith(startOffset, endOffset, inlay -> {
            if (inlay.myShowAbove == above && !EditorUtil.isInlayFolded(inlay)) {
                result2.add((Inlay<?>)inlay);
            }
            return true;
        });
        if (above) {
            Collections.reverse(result2);
        }
        result2.sort(BLOCK_ELEMENTS_COMPARATOR);
        return result2;
    }

    public int getHeightOfBlockElementsBeforeVisualLine(int visualLine) {
        int endOffset;
        if (visualLine < 0 || !this.hasBlockElements()) {
            return 0;
        }
        int visibleLineCount = this.myEditor.getVisibleLineCount();
        if (visualLine >= visibleLineCount) {
            return this.myBlockElementsTree.getSumOfValuesUpToOffset(Integer.MAX_VALUE) - this.myEditor.getFoldingModel().getTotalHeightOfFoldedBlockInlays();
        }
        int[] result2 = new int[]{0};
        int startOffset = this.myEditor.visualLineStartOffset(visualLine);
        int n = endOffset = visualLine >= visibleLineCount - 1 ? this.myEditor.getDocument().getTextLength() : this.myEditor.visualLineStartOffset(visualLine + 1) - 1;
        if (visualLine > 0) {
            result2[0] = result2[0] + (this.myBlockElementsTree.getSumOfValuesUpToOffset(startOffset - 1) - this.myEditor.getFoldingModel().getHeightOfFoldedBlockInlaysBefore(startOffset));
        }
        this.myBlockElementsTree.processOverlappingWith(startOffset, endOffset, inlay -> {
            if (inlay.myShowAbove && !EditorUtil.isInlayFolded(inlay)) {
                result2[0] = result2[0] + inlay.getHeightInPixels();
            }
            return true;
        });
        return result2[0];
    }

    public boolean hasBlockElements() {
        return this.myBlockElementsTree.size() > 0;
    }

    public boolean hasInlineElementsInRange(int startOffset, int endOffset) {
        return !this.myInlineElementsTree.processOverlappingWith(startOffset, endOffset, inlay -> false);
    }

    public boolean hasInlineElements() {
        return this.myInlineElementsTree.size() > 0;
    }

    public boolean hasInlineElementAt(int offset) {
        return !this.myInlineElementsTree.processOverlappingWith(offset, offset, inlay -> false);
    }

    public boolean hasInlineElementAt(@NotNull VisualPosition visualPosition) {
        int offset = this.myEditor.visualPositionToOffset(visualPosition);
        int inlayCount = this.getInlineElementsInRange(offset, offset).size();
        if (inlayCount == 0) {
            return false;
        }
        VisualPosition inlayStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
        return visualPosition.line == inlayStartPosition.line && visualPosition.column >= inlayStartPosition.column && visualPosition.column < inlayStartPosition.column + inlayCount;
    }

    @Nullable
    public Inlay getInlineElementAt(@NotNull VisualPosition visualPosition) {
        int offset = this.myEditor.visualPositionToOffset(visualPosition);
        List<Inlay<?>> inlays = this.getInlineElementsInRange(offset, offset);
        if (inlays.isEmpty()) {
            return null;
        }
        VisualPosition inlayStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
        if (visualPosition.line != inlayStartPosition.line) {
            return null;
        }
        int inlayIndex = visualPosition.column - inlayStartPosition.column;
        return inlayIndex >= 0 && inlayIndex < inlays.size() ? inlays.get(inlayIndex) : null;
    }

    @Nullable
    public Inlay getElementAt(@NotNull Point point) {
        return this.getElementAt(new EditorLocation(this.myEditor, point), false);
    }

    Inlay getElementAt(@NotNull EditorLocation location, boolean ignoreBlockElementWidth) {
        Inlay<?> inlay;
        int offset;
        List<Inlay<?>> inlays;
        Insets insets = this.myEditor.getContentComponent().getInsets();
        Point point = location.getPoint();
        if (point.y < insets.top) {
            return null;
        }
        int relX = point.x - insets.left;
        if (relX < 0) {
            return null;
        }
        boolean hasInlineElements = this.hasInlineElements();
        boolean hasBlockElements = this.hasBlockElements();
        boolean hasAfterLineEndElements = this.hasAfterLineEndElements();
        if (!(hasInlineElements || hasBlockElements || hasAfterLineEndElements)) {
            return null;
        }
        VisualPosition visualPosition = location.getVisualPosition();
        if (hasBlockElements) {
            int visualLine = visualPosition.line;
            int baseY = location.getVisualLineBaseY();
            if (point.y < baseY) {
                List<Inlay<?>> inlays2 = this.getBlockElementsForVisualLine(visualLine, true);
                int yDiff = baseY - point.y;
                for (int i2 = inlays2.size() - 1; i2 >= 0; --i2) {
                    Inlay<?> inlay2 = inlays2.get(i2);
                    if ((yDiff -= inlay2.getHeightInPixels()) > 0) continue;
                    return ignoreBlockElementWidth || relX < inlay2.getWidthInPixels() ? inlay2 : null;
                }
                LOG.error("Inconsistent state: " + point + ", " + visualPosition + ", baseY=" + baseY + ", " + inlays2, new Attachment[]{new Attachment("editorState.txt", this.myEditor.dumpState())});
                return null;
            }
            int lineBottom = baseY + this.myEditor.getLineHeight();
            if (point.y >= lineBottom) {
                List<Inlay<?>> inlays3 = this.getBlockElementsForVisualLine(visualLine, false);
                int yDiff = point.y - lineBottom;
                for (Inlay<?> inlay3 : inlays3) {
                    if ((yDiff -= inlay3.getHeightInPixels()) >= 0) continue;
                    return relX < inlay3.getWidthInPixels() ? inlay3 : null;
                }
                LOG.error("Inconsistent state: " + point + ", " + visualPosition + ", lineBottom=" + lineBottom + ", " + inlays3, new Attachment[]{new Attachment("editorState.txt", this.myEditor.dumpState())});
                return null;
            }
        }
        if (hasInlineElements && !(inlays = this.getInlineElementsInRange(offset = location.getOffset(), offset)).isEmpty()) {
            VisualPosition startVisualPosition = this.myEditor.offsetToVisualPosition(offset);
            Point inlayPoint = this.myEditor.visualPositionToXY(startVisualPosition);
            if (point.y < inlayPoint.y || point.y >= inlayPoint.y + this.myEditor.getLineHeight()) {
                return null;
            }
            inlay = InlayModelImpl.findInlay(inlays, point.x, inlayPoint.x);
            if (inlay != null) {
                return inlay;
            }
        }
        if (hasAfterLineEndElements) {
            List<Inlay<?>> inlays4;
            offset = location.getOffset();
            int logicalLine = this.myEditor.getDocument().getLineNumber(offset);
            if (offset == this.myEditor.getDocument().getLineEndOffset(logicalLine) && !this.myEditor.getFoldingModel().isOffsetCollapsed(offset) && !(inlays4 = this.myEditor.getInlayModel().getAfterLineEndElementsForLogicalLine(logicalLine)).isEmpty()) {
                Rectangle bounds2 = inlays4.get(0).getBounds();
                assert (bounds2 != null);
                if (point.y < bounds2.y || point.y >= bounds2.y + bounds2.height) {
                    return null;
                }
                inlay = InlayModelImpl.findInlay(inlays4, point.x, bounds2.x);
                if (inlay != null) {
                    return inlay;
                }
            }
        }
        return null;
    }

    private static Inlay<?> findInlay(List<Inlay<?>> inlays, int x, int startX) {
        for (Inlay<?> inlay : inlays) {
            int endX = startX + inlay.getWidthInPixels();
            if (x >= startX && x < endX) {
                return inlay;
            }
            startX = endX;
        }
        return null;
    }

    @NotNull
    public List<Inlay<?>> getAfterLineEndElementsInRange(int startOffset, int endOffset) {
        if (!this.hasAfterLineEndElements()) {
            return Collections.emptyList();
        }
        List<Inlay<?>> range2 = InlayModelImpl.getElementsInRange(this.myAfterLineEndElementsTree, startOffset, endOffset, inlay -> true, AFTER_LINE_END_ELEMENTS_OFFSET_COMPARATOR);
        return range2;
    }

    @NotNull
    public <T> List<Inlay<? extends T>> getAfterLineEndElementsInRange(int startOffset, int endOffset, @NotNull Class<T> type) {
        if (!this.hasAfterLineEndElements()) {
            return Collections.emptyList();
        }
        List<Inlay<? extends T>> range2 = InlayModelImpl.getElementsInRange(this.myAfterLineEndElementsTree, startOffset, endOffset, inlay -> type.isInstance(inlay.myRenderer), AFTER_LINE_END_ELEMENTS_OFFSET_COMPARATOR);
        return range2;
    }

    @NotNull
    public List<Inlay<?>> getAfterLineEndElementsForLogicalLine(int logicalLine) {
        DocumentEx document = this.myEditor.getDocument();
        if (!this.hasAfterLineEndElements() || logicalLine < 0 || logicalLine > 0 && logicalLine >= document.getLineCount()) {
            return Collections.emptyList();
        }
        ArrayList result2 = new ArrayList();
        int startOffset = document.getLineStartOffset(logicalLine);
        int endOffset = document.getLineEndOffset(logicalLine);
        this.myAfterLineEndElementsTree.processOverlappingWith(startOffset, endOffset, inlay -> {
            result2.add((Inlay<?>)inlay);
            return true;
        });
        result2.sort(AFTER_LINE_END_ELEMENTS_COMPARATOR);
        return result2;
    }

    public boolean hasAfterLineEndElements() {
        return this.myAfterLineEndElementsTree.size() > 0;
    }

    public void setConsiderCaretPositionOnDocumentUpdates(boolean enabled) {
        this.myConsiderCaretPositionOnDocumentUpdates = enabled;
    }

    public void execute(boolean batchMode, @NotNull Runnable operation) {
        EditorImpl.assertIsDispatchThread();
        if (this.myInBatchMode || !batchMode) {
            operation.run();
        } else {
            try {
                this.notifyBatchModeStarting();
                this.myInBatchMode = true;
                operation.run();
            }
            finally {
                this.myInBatchMode = false;
                this.notifyBatchModeFinished();
            }
        }
    }

    public boolean isInBatchMode() {
        return this.myInBatchMode;
    }

    public void addListener(@NotNull InlayModel.Listener listener2, @NotNull Disposable disposable2) {
        EditorImpl.assertIsDispatchThread();
        this.myDispatcher.addListener((EventListener)listener2, disposable2);
    }

    private void notifyAdded(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onAdded((Inlay)inlay);
    }

    void notifyChanged(InlayImpl inlay, int changeFlags) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onUpdated((Inlay)inlay, changeFlags);
    }

    void notifyRemoved(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onRemoved((Inlay)inlay);
    }

    private void notifyBatchModeStarting() {
        List listeners = this.myDispatcher.getListeners();
        for (int i2 = listeners.size() - 1; i2 >= 0; --i2) {
            ((InlayModel.Listener)listeners.get(i2)).onBatchModeStart((Editor)this.myEditor);
        }
    }

    private void notifyBatchModeFinished() {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onBatchModeFinish((Editor)this.myEditor);
    }

    public void validateState() {
        for (Inlay<?> inlay : this.getInlineElementsInRange(0, this.myEditor.getDocument().getTextLength())) {
            LOG.assertTrue(!DocumentUtil.isInsideSurrogatePair(this.myEditor.getDocument(), inlay.getOffset()));
        }
    }

    @NotNull
    public String dumpState() {
        return "Inline elements: " + InlayModelImpl.dumpInlays(this.myInlineElementsTree) + ", after-line-end elements: " + InlayModelImpl.dumpInlays(this.myAfterLineEndElementsTree) + ", block elements: " + InlayModelImpl.dumpInlays(this.myBlockElementsTree);
    }

    private static String dumpInlays(RangeMarkerTree<? extends InlayImpl> tree) {
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        tree.processAll((Processor<? extends InlayImpl>)((Processor)o -> {
            joiner.add(Integer.toString(o.getOffset()));
            return true;
        }));
        return joiner.toString();
    }

    private class AfterLineEndElementTree
    extends HardReferencingRangeMarkerTree<AfterLineEndInlayImpl<?>> {
        AfterLineEndElementTree(Document document) {
            super(document);
        }

        @Override
        void fireBeforeRemoved(@NotNull AfterLineEndInlayImpl inlay, @NotNull @NonNls Object reason) {
            if (inlay.getUserData(InlayImpl.OFFSET_BEFORE_DISPOSAL) == null) {
                InlayModelImpl.this.notifyRemoved(inlay);
            }
        }
    }

    private final class BlockElementsTree
    extends MarkerTreeWithPartialSums<BlockInlayImpl<?>> {
        BlockElementsTree(Document document) {
            super(document);
        }

        @Override
        void fireBeforeRemoved(@NotNull BlockInlayImpl inlay, @NotNull @NonNls Object reason) {
            if (inlay.getUserData(InlayImpl.OFFSET_BEFORE_DISPOSAL) == null) {
                InlayModelImpl.this.notifyRemoved(inlay);
            }
        }
    }

    private class InlineElementsTree
    extends HardReferencingRangeMarkerTree<InlineInlayImpl<?>> {
        InlineElementsTree(Document document) {
            super(document);
        }

        @Override
        @NotNull
        protected RangeMarkerTree.RMNode<InlineInlayImpl<?>> createNewNode(@NotNull InlineInlayImpl key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
            return new RangeMarkerTree.RMNode<InlineInlayImpl<?>>(this, key, start2, end, greedyToLeft, greedyToRight, stickingToRight){

                @Override
                void addIntervalsFrom(@NotNull IntervalTreeImpl.IntervalNode<InlineInlayImpl<?>> otherNode) {
                    super.addIntervalsFrom(otherNode);
                    if (InlayModelImpl.this.myPutMergedIntervalsAtBeginning) {
                        List added = ContainerUtil.subList((List)this.intervals, (int)(this.intervals.size() - otherNode.intervals.size()));
                        ArrayList addedCopy = new ArrayList(added);
                        added.clear();
                        this.intervals.addAll(0, addedCopy);
                    }
                }
            };
        }

        @Override
        void fireBeforeRemoved(@NotNull InlineInlayImpl inlay, @NotNull @NonNls Object reason) {
            if (inlay.getUserData(InlayImpl.OFFSET_BEFORE_DISPOSAL) == null) {
                if (InlayModelImpl.this.myMoveInProgress) {
                    InlayModelImpl.this.myInlaysInvalidatedOnMove.add(inlay);
                } else {
                    InlayModelImpl.this.notifyRemoved(inlay);
                }
            }
        }
    }
}

