/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FilteringMarkupIterator;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorFilteringMarkupModelEx
implements MarkupModelEx {
    @NotNull
    private final EditorImpl myEditor;
    @NotNull
    private final MarkupModelEx myDelegate;
    private final Condition<RangeHighlighter> IS_AVAILABLE = this::isAvailable;

    EditorFilteringMarkupModelEx(@NotNull EditorImpl editor, @NotNull MarkupModelEx delegate) {
        this.myEditor = editor;
        this.myDelegate = delegate;
    }

    @NotNull
    public MarkupModelEx getDelegate() {
        return this.myDelegate;
    }

    private boolean isAvailable(@NotNull RangeHighlighter highlighter) {
        return highlighter.getEditorFilter().avaliableIn((Editor)this.myEditor) && this.myEditor.isHighlighterAvailable(highlighter);
    }

    @Override
    public boolean containsHighlighter(@NotNull RangeHighlighter highlighter) {
        return this.isAvailable(highlighter) && this.myDelegate.containsHighlighter(highlighter);
    }

    @Override
    public boolean processRangeHighlightersOverlappingWith(int start2, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        FilteringProcessor filteringProcessor = new FilteringProcessor(this.IS_AVAILABLE, processor2);
        return this.myDelegate.processRangeHighlightersOverlappingWith(start2, end, (Processor<? super RangeHighlighterEx>)filteringProcessor);
    }

    @Override
    public boolean processRangeHighlightersOutside(int start2, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        FilteringProcessor filteringProcessor = new FilteringProcessor(this.IS_AVAILABLE, processor2);
        return this.myDelegate.processRangeHighlightersOutside(start2, end, (Processor<? super RangeHighlighterEx>)filteringProcessor);
    }

    @Override
    @NotNull
    public MarkupIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset) {
        return new FilteringMarkupIterator<RangeHighlighterEx>(this.myDelegate.overlappingIterator(startOffset, endOffset), this::isAvailable);
    }

    @Override
    @NotNull
    public MarkupIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset, boolean onlyRenderedInGutter) {
        return new FilteringMarkupIterator<RangeHighlighterEx>(this.myDelegate.overlappingIterator(startOffset, endOffset, onlyRenderedInGutter), this::isAvailable);
    }

    public RangeHighlighter @NotNull [] getAllHighlighters() {
        List list2 = ContainerUtil.filter((Object[])this.myDelegate.getAllHighlighters(), this.IS_AVAILABLE);
        return list2.toArray(RangeHighlighter.EMPTY_ARRAY);
    }

    @Override
    public void addMarkupModelListener(@NotNull Disposable parentDisposable, @NotNull MarkupModelListener listener2) {
        this.myDelegate.addMarkupModelListener(parentDisposable, listener2);
    }

    @Override
    public void dispose() {
    }

    @NotNull
    public Document getDocument() {
        return this.myDelegate.getDocument();
    }

    @Override
    public void fireAttributesChanged(@NotNull RangeHighlighterEx segmentHighlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
        this.myDelegate.fireAttributesChanged(segmentHighlighter, renderersChanged, fontStyleOrColorChanged);
    }

    @Override
    public void fireAfterAdded(@NotNull RangeHighlighterEx segmentHighlighter) {
        this.myDelegate.fireAfterAdded(segmentHighlighter);
    }

    @Override
    public void fireBeforeRemoved(@NotNull RangeHighlighterEx segmentHighlighter) {
        this.myDelegate.fireBeforeRemoved(segmentHighlighter);
    }

    @Override
    @Nullable
    public RangeHighlighterEx addPersistentLineHighlighter(@Nullable TextAttributesKey textAttributesKey, int lineNumber, int layer) {
        return this.myDelegate.addPersistentLineHighlighter(textAttributesKey, lineNumber, layer);
    }

    @Override
    @Nullable
    public RangeHighlighterEx addPersistentLineHighlighter(int lineNumber, int layer, @Nullable TextAttributes textAttributes) {
        return this.myDelegate.addPersistentLineHighlighter(lineNumber, layer, textAttributes);
    }

    @Override
    public void addRangeHighlighter(@NotNull RangeHighlighterEx marker, int start2, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        this.myDelegate.addRangeHighlighter(marker, start2, end, greedyToLeft, greedyToRight, layer);
    }

    @NotNull
    public RangeHighlighter addRangeHighlighter(@Nullable TextAttributesKey textAttributesKey, int startOffset, int endOffset, int layer, @NotNull HighlighterTargetArea targetArea) {
        return this.myDelegate.addRangeHighlighter(textAttributesKey, startOffset, endOffset, layer, targetArea);
    }

    @NotNull
    public RangeHighlighter addRangeHighlighter(int startOffset, int endOffset, int layer, @Nullable TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea) {
        return this.myDelegate.addRangeHighlighter(startOffset, endOffset, layer, textAttributes, targetArea);
    }

    @NotNull
    public RangeHighlighter addLineHighlighter(@Nullable TextAttributesKey textAttributesKey, int line, int layer) {
        return this.myDelegate.addLineHighlighter(textAttributesKey, line, layer);
    }

    @NotNull
    public RangeHighlighter addLineHighlighter(int line, int layer, @Nullable TextAttributes textAttributes) {
        return this.myDelegate.addLineHighlighter(line, layer, textAttributes);
    }

    @Override
    @NotNull
    public RangeHighlighterEx addRangeHighlighterAndChangeAttributes(@Nullable TextAttributesKey textAttributesKey, int startOffset, int endOffset, int layer, @NotNull HighlighterTargetArea targetArea, boolean isPersistent, @Nullable Consumer<? super RangeHighlighterEx> changeAttributesAction) {
        return this.myDelegate.addRangeHighlighterAndChangeAttributes(textAttributesKey, startOffset, endOffset, layer, targetArea, isPersistent, changeAttributesAction);
    }

    @Override
    public void setRangeHighlighterAttributes(@NotNull RangeHighlighter highlighter, @NotNull TextAttributes textAttributes) {
        this.myDelegate.setRangeHighlighterAttributes(highlighter, textAttributes);
    }

    @Override
    public void changeAttributesInBatch(@NotNull RangeHighlighterEx highlighter, @NotNull Consumer<? super RangeHighlighterEx> changeAttributesAction) {
        this.myDelegate.changeAttributesInBatch(highlighter, changeAttributesAction);
    }

    public void removeHighlighter(@NotNull RangeHighlighter rangeHighlighter) {
        this.myDelegate.removeHighlighter(rangeHighlighter);
    }

    public void removeAllHighlighters() {
        this.myDelegate.removeAllHighlighters();
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myDelegate.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        this.myDelegate.putUserData(key, value2);
    }
}

