/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorEmbeddedComponentManager {
    private static final Key<ComponentInlays> COMPONENT_INLAYS_KEY = Key.create((String)"editor.embedded.component.inlays");
    private static final int RESIZE_POINT_DELTA = JBUI.scale((int)5);
    private static final EditorEmbeddedComponentManager ourInstance = new EditorEmbeddedComponentManager();

    private EditorEmbeddedComponentManager() {
    }

    @NotNull
    public static EditorEmbeddedComponentManager getInstance() {
        return ourInstance;
    }

    @Nullable
    public Inlay<?> addComponent(@NotNull EditorEx editor, @NotNull JComponent component2, @NotNull Properties properties) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ComponentInlays inlays = EditorEmbeddedComponentManager.getComponentInlaysFor(editor);
        return inlays.add(component2, properties.resizePolicy, properties.rendererFactory, properties.relatesToPrecedingText, properties.showAbove, properties.priority, properties.offset);
    }

    @NotNull
    private static ComponentInlays getComponentInlaysFor(@NotNull EditorEx editor) {
        if (!COMPONENT_INLAYS_KEY.isIn((UserDataHolder)editor)) {
            COMPONENT_INLAYS_KEY.set((UserDataHolder)editor, (Object)new ComponentInlays(editor));
        }
        return (ComponentInlays)COMPONENT_INLAYS_KEY.get((UserDataHolder)editor);
    }

    private static class ComponentInlays
    implements Disposable {
        private final EditorEx myEditor;
        private final List<Inlay<? extends MyRenderer>> myInlays;
        private final ResizeListener myResizeListener;

        ComponentInlays(@NotNull EditorEx editor) {
            this.myEditor = editor;
            this.myInlays = new ArrayList<Inlay<? extends MyRenderer>>();
            this.myResizeListener = new ResizeListener();
            this.setup();
        }

        @Nullable
        Inlay<MyRenderer> add(final @NotNull JComponent component2, @NotNull ResizePolicy policy, @Nullable Properties.RendererFactory rendererFactory, boolean relatesToPrecedingText, boolean showAbove, int priority, int offset) {
            MyRenderer renderer = new MyRenderer(component2, policy, rendererFactory);
            final Inlay inlay = this.myEditor.getInlayModel().addBlockElement(offset, relatesToPrecedingText, showAbove, priority, (EditorCustomElementRenderer)renderer);
            if (inlay == null) {
                return null;
            }
            renderer.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    inlay.update();
                    this.updateAllInlaysBelow(component2.getBounds());
                }
            });
            component2.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.updateSize((Inlay<? extends MyRenderer>)inlay);
                    inlay.update();
                    this.updateAllInlaysBelow(component2.getBounds());
                }
            });
            renderer.addMouseWheelListener(this.myEditor.getContentComponent()::dispatchEvent);
            this.update((Inlay<? extends MyRenderer>)inlay);
            inlay.update();
            this.myEditor.getContentComponent().add(renderer);
            this.myInlays.add((Inlay<? extends MyRenderer>)inlay);
            Disposer.register((Disposable)inlay, () -> {
                this.myEditor.getContentComponent().remove(renderer);
                this.myInlays.remove(inlay);
            });
            return inlay;
        }

        private void updateAllInlaysBelow(@NotNull Rectangle bounds2) {
            for (Inlay<? extends MyRenderer> i2 : this.getInlaysBelow(bounds2.y)) {
                this.update(i2);
            }
        }

        private void setup() {
            EditorUtil.disposeWithEditor(this.myEditor, this);
            this.myEditor.getFoldingModel().addListener(new FoldingListener(){

                @Override
                public void onFoldProcessingEnd() {
                    for (Inlay inlay : myInlays) {
                        this.update((Inlay<? extends MyRenderer>)inlay);
                    }
                }
            }, this);
            this.myEditor.getInlayModel().addListener((InlayModel.Listener)new InlayModel.SimpleAdapter(){

                public void onUpdated(@NotNull Inlay inlay, int changeFlags) {
                    Rectangle bounds2;
                    if ((changeFlags & 2) != 0 && (bounds2 = inlay.getBounds()) != null) {
                        this.updateAllInlaysBelow(bounds2);
                    }
                }

                public void onRemoved(@NotNull Inlay inlay) {
                    Disposer.dispose((Disposable)inlay);
                }
            }, (Disposable)this);
            ComponentAdapter viewportListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int maxY = ((ComponentInlays)this).myEditor.getScrollPane().getViewport().getViewRect().y;
                    for (Inlay inlay : this.getInlaysBelow(maxY)) {
                        this.updateSize((Inlay<? extends MyRenderer>)inlay);
                    }
                }
            };
            JViewport viewport = this.myEditor.getScrollPane().getViewport();
            viewport.addComponentListener(viewportListener);
            Disposer.register((Disposable)this, () -> viewport.removeComponentListener(viewportListener));
            this.myEditor.addEditorMouseListener(this.myResizeListener);
            this.myEditor.addEditorMouseMotionListener(this.myResizeListener);
        }

        @NotNull
        private Collection<Inlay<? extends MyRenderer>> getInlaysBelow(int y) {
            return ContainerUtil.filter(this.myInlays, inlay -> {
                Rectangle bounds2 = ((MyRenderer)inlay.getRenderer()).getBounds();
                return bounds2 != null && bounds2.y + bounds2.height >= y;
            });
        }

        private void update(@NotNull Inlay<? extends MyRenderer> inlay) {
            Rectangle bounds2 = inlay.getBounds();
            MyRenderer renderer = (MyRenderer)inlay.getRenderer();
            if (bounds2 == null) {
                renderer.setVisible(false);
                return;
            }
            JScrollBar vsb = this.myEditor.getScrollPane().getVerticalScrollBar();
            renderer.setLocation(new Point(this.isVerticalScrollbarFlipped() ? vsb.getWidth() : 0, bounds2.getLocation().y));
            renderer.setVisible(true);
            this.updateSize(inlay);
        }

        private boolean isVerticalScrollbarFlipped() {
            Object flipProperty = this.myEditor.getScrollPane().getClientProperty(JBScrollPane.Flip.class);
            return flipProperty == JBScrollPane.Flip.HORIZONTAL || flipProperty == JBScrollPane.Flip.BOTH;
        }

        private void updateSize(@NotNull Inlay<? extends MyRenderer> inlay) {
            MyRenderer renderer = (MyRenderer)inlay.getRenderer();
            if (!renderer.isVisible() || this.myResizeListener.isResizeInProgress(renderer)) {
                return;
            }
            int componentWidth = renderer.getPreferredWidth();
            int componentHeight = renderer.getPreferredHeight();
            JScrollPane scrollPane = this.myEditor.getScrollPane();
            int visibleWidth = scrollPane.getViewport().getWidth() - scrollPane.getVerticalScrollBar().getWidth();
            int minWidth = renderer.isWidthSet() ? componentWidth : visibleWidth;
            int width = Math.min(componentWidth, minWidth);
            Dimension newSize = new Dimension(Math.max(width, 0), Math.max(componentHeight, 0));
            if (!renderer.getSize().equals(newSize)) {
                renderer.setSize(newSize);
            }
        }

        public void dispose() {
            this.myEditor.setCustomCursor(this, null);
            for (int i2 = this.myInlays.size() - 1; i2 > -1; --i2) {
                Disposer.dispose((Disposable)((Disposable)this.myInlays.get(i2)));
            }
        }

        private class ResizeListener
        implements EditorMouseListener,
        EditorMouseMotionListener {
            private ResizeInfo info;

            private ResizeListener() {
            }

            public void mouseMoved(EditorMouseEvent e) {
                ResizeInfo info = this.getInfoForResizeUnder(e.getMouseEvent().getPoint());
                if (info == null) {
                    this.resetCursor();
                    return;
                }
                ComponentInlays.this.myEditor.setCustomCursor(ComponentInlays.this, info.direction.cursor);
            }

            public void mousePressed(EditorMouseEvent event) {
                Point point = event.getMouseEvent().getPoint();
                this.info = this.getInfoForResizeUnder(point);
                if (this.info == null) {
                    return;
                }
                event.consume();
            }

            public void mouseReleased(@NotNull EditorMouseEvent event) {
                this.info = null;
                this.resetCursor();
            }

            public void mouseDragged(@NotNull EditorMouseEvent event) {
                if (this.info == null) {
                    return;
                }
                Point currentPoint = event.getMouseEvent().getPoint();
                MyRenderer renderer = (MyRenderer)this.info.inlay.getRenderer();
                int xDelta = this.info.direction.xMultiplier * (currentPoint.x - renderer.getX() - renderer.getWidth());
                int yDelta = this.info.direction.yMultiplier * (currentPoint.y - renderer.getY() - renderer.getHeight());
                Dimension size = renderer.getSize();
                int newWidth = Math.max(Math.max(((MyRenderer)this.info.inlay.getRenderer()).getMinimumSize().width, size.width + xDelta), 0);
                int newHeight = Math.max(Math.max(((MyRenderer)this.info.inlay.getRenderer()).getMinimumSize().height, size.height + yDelta), 0);
                renderer.setCustomWidth(newWidth);
                renderer.setCustomHeight(newHeight);
                renderer.setSize(newWidth, newHeight);
                renderer.revalidate();
                renderer.repaint(50L);
                this.scrollTo(renderer.getBounds());
                event.consume();
            }

            public void mouseExited(@NotNull EditorMouseEvent event) {
                this.resetCursor();
            }

            boolean isResizeInProgress(@NotNull MyRenderer wrapper2) {
                return this.info != null && wrapper2 == this.info.inlay.getRenderer();
            }

            private void scrollTo(@NotNull Rectangle inlayBounds) {
                Rectangle contentComponentBounds = ComponentInlays.this.myEditor.getScrollPane().getViewport().getViewRect();
                int compMinX = contentComponentBounds.x;
                int compMaxX = compMinX + contentComponentBounds.width;
                int compMinY = contentComponentBounds.y;
                int compMaxY = compMinY + contentComponentBounds.height;
                int inlayMaxX = inlayBounds.x + inlayBounds.width;
                int inlayMaxY = inlayBounds.y + inlayBounds.height;
                JScrollBar hsb = ComponentInlays.this.myEditor.getScrollPane().getHorizontalScrollBar();
                JScrollBar vsb = ComponentInlays.this.myEditor.getScrollPane().getVerticalScrollBar();
                int hsbNewValue = hsb.getValue() + this.info.direction.xMultiplier * (inlayMaxX > compMaxX ? inlayMaxX - compMaxX : (inlayMaxX < compMinX ? inlayMaxX - compMinX : 0));
                int vsbNewValue = vsb.getValue() + this.info.direction.yMultiplier * (inlayMaxY > compMaxY ? inlayMaxY - compMaxY : (inlayMaxY < compMinY ? inlayMaxY - compMinY : 0));
                hsb.setValue(Math.max(0, hsbNewValue));
                vsb.setValue(Math.max(0, vsbNewValue));
            }

            private void resetCursor() {
                if (this.info == null) {
                    ComponentInlays.this.myEditor.setCustomCursor(ComponentInlays.this, null);
                }
            }

            @Nullable
            private ResizeInfo getInfoForResizeUnder(@NotNull Point point) {
                return (ResizeInfo)ContainerUtil.getFirstItem((List)ContainerUtil.mapNotNull((Collection)ComponentInlays.this.myInlays, inlay -> {
                    boolean dragFromRight;
                    ResizePolicy policy = ((MyRenderer)inlay.getRenderer()).resizePolicy;
                    if (!policy.isResizable()) {
                        return null;
                    }
                    Rectangle bounds2 = inlay.getBounds();
                    if (bounds2 == null) {
                        return null;
                    }
                    int pressY = point.y;
                    int pressX = point.x;
                    int inlayTY = bounds2.y;
                    int inlayLX = bounds2.x;
                    int inlayBY = bounds2.y + bounds2.height;
                    int inlayRX = bounds2.x + bounds2.width;
                    boolean dragFromBottom = policy.isResizableFromBottom() && this.isInside(pressX, inlayLX, inlayRX) && this.isNearTo(pressY, inlayBY);
                    boolean bl = dragFromRight = policy.isResizableFromRight() && this.isInside(pressY, inlayTY, inlayBY) && this.isNearTo(pressX, inlayRX);
                    ResizeDirection direction = dragFromBottom && dragFromRight ? ResizeDirection.BOTTOM_RIGHT : (dragFromBottom ? ResizeDirection.BOTTOM : (dragFromRight ? ResizeDirection.RIGHT : null));
                    return direction == null ? null : new ResizeInfo((Inlay<? extends MyRenderer>)inlay, direction);
                }));
            }

            private boolean isNearTo(int value2, int coordinate) {
                return this.isInside(value2, coordinate, coordinate);
            }

            private boolean isInside(int value2, int min, int max) {
                return value2 > min - RESIZE_POINT_DELTA && value2 < max + RESIZE_POINT_DELTA;
            }
        }

        private static enum ResizeDirection {
            BOTTOM(0, 1, Cursor.getPredefinedCursor(9)),
            RIGHT(1, 0, Cursor.getPredefinedCursor(11)),
            BOTTOM_RIGHT(1, 1, Cursor.getPredefinedCursor(5));

            final int xMultiplier;
            final int yMultiplier;
            final Cursor cursor;

            private ResizeDirection(@NotNull int xMultiplier, int yMultiplier, Cursor cursor) {
                this.xMultiplier = xMultiplier;
                this.yMultiplier = yMultiplier;
                this.cursor = cursor;
            }
        }

        private static class ResizeInfo {
            final Inlay<? extends MyRenderer> inlay;
            final ResizeDirection direction;
            final int startWidth;

            ResizeInfo(@NotNull Inlay<? extends MyRenderer> inlay, @NotNull ResizeDirection direction) {
                this.inlay = inlay;
                this.direction = direction;
                this.startWidth = ((MyRenderer)inlay.getRenderer()).getWidth();
            }
        }
    }

    private static class MyRenderer
    extends JPanel
    implements EditorCustomElementRenderer {
        private static final int UNDEFINED = -1;
        final ResizePolicy resizePolicy;
        private final Properties.RendererFactory myRendererFactory;
        private int myCustomWidth = -1;
        private int myCustomHeight = -1;

        MyRenderer(@NotNull JComponent component2, @NotNull ResizePolicy resizePolicy, @Nullable Properties.RendererFactory rendererFactory) {
            super(new BorderLayout());
            this.resizePolicy = resizePolicy;
            this.myRendererFactory = rendererFactory;
            this.add((Component)component2, "Center");
            this.setOpaque(false);
        }

        @Nullable
        public GutterIconRenderer calcGutterIconRenderer(@NotNull Inlay inlay) {
            return this.myRendererFactory == null ? null : this.myRendererFactory.createRenderer(inlay);
        }

        void setCustomWidth(int customWidth) {
            if (customWidth != this.getPreferredWidth()) {
                this.myCustomWidth = customWidth;
            }
        }

        void setCustomHeight(int customHeight) {
            if (customHeight != this.getPreferredHeight()) {
                this.myCustomHeight = customHeight;
            }
        }

        int getPreferredWidth() {
            return this.isWidthSet() ? this.myCustomWidth : this.getPreferredSize().width;
        }

        int getPreferredHeight() {
            return this.myCustomHeight == -1 ? this.getPreferredSize().height : this.myCustomHeight;
        }

        boolean isWidthSet() {
            return this.myCustomWidth != -1;
        }

        public int calcHeightInPixels(@NotNull Inlay inlay) {
            return Math.max(this.getHeight(), 0);
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            return Math.max(this.getWidth(), 0);
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            Rectangle currentBounds = inlay.getBounds();
            if (currentBounds == null || Objects.equals(currentBounds, this.getBounds())) {
                return;
            }
            this.setBounds(currentBounds);
            this.revalidate();
            this.repaint(50L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Composite old = g2d.getComposite();
            try {
                g2d.setComposite(AlphaComposite.SrcOver);
                super.paint(g);
            }
            finally {
                g2d.setComposite(old);
            }
        }
    }

    public static class Properties {
        final ResizePolicy resizePolicy;
        final RendererFactory rendererFactory;
        final boolean relatesToPrecedingText;
        final boolean showAbove;
        final int priority;
        final int offset;

        public Properties(@NotNull ResizePolicy resizePolicy, @Nullable RendererFactory rendererFactory, boolean relatesToPrecedingText, boolean showAbove, int priority, int offset) {
            this.resizePolicy = resizePolicy;
            this.rendererFactory = rendererFactory;
            this.relatesToPrecedingText = relatesToPrecedingText;
            this.showAbove = showAbove;
            this.priority = priority;
            this.offset = offset;
        }

        public static interface RendererFactory {
            @Nullable
            public GutterIconRenderer createRenderer(@NotNull Inlay<?> var1);
        }
    }

    public static class ResizePolicy {
        private static final int RIGHT = 2;
        private static final int BOTTOM = 4;
        private static final ResizePolicy ourAny = new ResizePolicy(6);
        private static final ResizePolicy ourNone = new ResizePolicy(0);
        private final int myFlags;

        private ResizePolicy(int flags) {
            this.myFlags = flags;
        }

        public boolean isResizable() {
            return this.isResizableFromRight() || this.isResizableFromBottom();
        }

        public static ResizePolicy any() {
            return ourAny;
        }

        @NotNull
        public static ResizePolicy none() {
            return ourNone;
        }

        public boolean isResizableFromRight() {
            return (this.myFlags & 2) != 0;
        }

        public boolean isResizableFromBottom() {
            return (this.myFlags & 4) != 0;
        }
    }
}

